/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller.wechat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.business.common.feignclient.WechatService;
import kr.weitao.business.entity.QrcodeScanLog;
import kr.weitao.business.entity.User;
import kr.weitao.business.entity.data.Material;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.common.util.XML;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.config.annotation.WebLog;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.controller.wechat.WechatController;
import kr.weitao.weitaokr.service.WechatOpenAuthorizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5fae\u4fe1\u5e73\u53f0\u7ba1\u7406", description="\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u670d\u52a1", tags={"wechatService"})
@RefreshScope
@RestController
@RequestMapping(value={"/wechat"})
public class WechatController {
    private static final Logger log = LogManager.getLogger(WechatController.class);
    @Autowired
    WechatService wechatService;
    @Autowired
    RedisClient redisClient;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    WechatOpenAuthorizer wechatOpenAuthorizer;
    @Value(value="${weixin.server.pay.url}")
    String order_pay_url;
    @Value(value="${weixin.server.pay.domain}")
    String order_pay_domain;

    @ResponseBody
    @ApiOperation(value="\u5f00\u653e\u5e73\u53f0\u7ba1\u7406", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/open/authorize"}, method={RequestMethod.POST})
    public String authorize(HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/open/authorize";
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        data_request.setData(param);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            return "success";
        }
        return "success";
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u6388\u6743\u7801", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/open/getAuhtorizeUrl"}, method={RequestMethod.POST})
    public DataResponse getPrecode(@RequestBody DataRequest request) {
        String real_path = "/wechat/open/getAuhtorizeUrl";
        DataResponse response = this.wechatService.getData(real_path, request);
        return response;
    }

    @ResponseBody
    @ApiOperation(value="\u516c\u4f17\u5e73\u53f0\u4e8b\u4ef6", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/public/event/{appid}", "/mp/event/{appid}"}, method={RequestMethod.POST, RequestMethod.GET})
    public String publicEvent(@PathVariable(value="appid") String publicAppid, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/public/event/" + publicAppid;
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        data_request.setData(param);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        log.info("data_response:" + (data_response == null ? " is null" : data_response.toJSONObject()));
        return this.getResult(data_response);
    }

    @ResponseBody
    @ApiOperation(value="\u516c\u4f17\u53f7\u6388\u6743\u56de\u8c03\u4e8b\u4ef6", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/public/authorize/{path}"}, method={RequestMethod.GET, RequestMethod.POST})
    public String publicAuthorizeEvent(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/public/authorize/" + path;
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        data_request.setData(param);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        log.info(real_path + " result :" + data_response.toJSONObject());
        return data_response == null ? "" : data_response.toJSONObject().toJSONString();
    }

    @ApiOperation(value="\u5fae\u4fe1JS\u5bc6\u94a5", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/public/getJssdk"}, method={RequestMethod.POST})
    public DataResponse getJssdk(@RequestBody DataRequest request) {
        DataResponse data_response = this.wechatService.getData("/wechat/public/getJssdk", request);
        return data_response;
    }

    @ApiOperation(value="\u5fae\u4fe1\u7528\u6237\u6388\u6743\u56de\u8c03\u4e8b\u4ef6", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/callback/{path}"}, method={RequestMethod.GET})
    public void AuthorizeEvent(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/public/fans/" + path;
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        JSONObject get_param = param.getJSONObject("get_param");
        data_request.setData(get_param);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            if (data_response == null) {
                data_response = new DataResponse();
            }
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject data = data_response.getData();
        if (data == null || data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject result_data = data.getJSONObject("message");
        log.info("get openid result:" + result_data);
        if (result_data == null || result_data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        String openid = result_data.getString("openid");
        String access_token = result_data.getString("access_token");
        String appid = request.getParameter("appid");
        get_param = new JSONObject();
        get_param.put("openid", (Object)openid);
        get_param.put("access_token", (Object)access_token);
        get_param.put("public_appid", (Object)appid);
        data_request.setData(get_param);
        data_response = this.wechatService.getData("/wechat/public/fans/getScopeInfo", data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            if (data_response == null) {
                data_response = new DataResponse();
            }
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        log.info((Object)data_response.getData());
        JSONObject wx = data_response.getData();
        this.redisClient.getValueOps().setValueString("wx_" + appid + "_" + openid, wx.toJSONString());
        String order_id = request.getParameter("order_id");
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        try {
            String url = this.order_pay_domain + request.getParameter("order_url") + "?order_id=" + order_id + "&open_id=" + openid + "&appid=" + appid;
            log.info("order_url----" + url);
            response.sendRedirect(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u5fae\u4fe1\u7528\u6237\u6388\u6743\u56de\u8c03\u4e8b\u4ef6", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/corpMaterial/{path}"}, method={RequestMethod.GET})
    public void MaterialAuthorizeEvent(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        DataResponse data_response;
        String real_path = "/wechat/public/fans/" + path;
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        JSONObject get_param = param.getJSONObject("get_param");
        JSONObject get_param_ = param.getJSONObject("get_param");
        log.info("----get_param---" + get_param);
        data_request.setData(get_param);
        String user_id = get_param.getString("user_id");
        String product_id = get_param.getString("product_id");
        User user = (User)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"user_id").is((Object)user_id)), User.class);
        String store_id = "";
        store_id = null != user ? (StringUtils.isNull((Object)user.getStore_id()) ? "1234" : user.getStore_id()) : "1234";
        String team_id = get_param.getString("team_id");
        if (StringUtils.isNull((Object)team_id) || "<team_id>".equals(team_id)) {
            team_id = "";
        }
        if ((data_response = this.wechatService.getData(real_path, data_request)) == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            if (data_response == null) {
                data_response = new DataResponse();
            }
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject data = data_response.getData();
        if (data == null || data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject result_data = data.getJSONObject("message");
        log.info("get openid result:" + result_data);
        if (result_data == null || result_data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        String openid = result_data.getString("openid");
        String access_token = result_data.getString("access_token");
        String appid = request.getParameter("appid");
        get_param = new JSONObject();
        get_param.put("openid", (Object)openid);
        get_param.put("access_token", (Object)access_token);
        get_param.put("public_appid", (Object)appid);
        data_request.setData(get_param);
        data_response = this.wechatService.getData("/wechat/public/fans/getScopeInfo", data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            if (data_response == null) {
                data_response = new DataResponse();
            }
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        log.info((Object)data_response.getData());
        JSONObject wx = data_response.getData();
        this.redisClient.getValueOps().setValueString("wx_" + appid + "_" + openid, wx.toJSONString());
        String material_id = request.getParameter("material_id");
        String hash = request.getParameter("hash");
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        try {
            QrcodeScanLog scanLog = new QrcodeScanLog();
            scanLog.setCreated_time(TimeUtils.getTime((long)System.currentTimeMillis()));
            scanLog.setOpen_id(openid);
            scanLog.setApp_id(appid);
            scanLog.setTeam_id(team_id);
            scanLog.setUser_id(user_id);
            scanLog.setType("material");
            JSONObject m_param = new JSONObject();
            m_param.put("material_id", (Object)material_id);
            if (StringUtils.isNotNull((Object)material_id)) {
                Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id));
                Material material = (Material)this.mongoTemplate.findOne(query, Material.class);
                String brand_name = "";
                if (material != null) {
                    m_param.put("material_name", (Object)material.getMaterial_name());
                    m_param.put("material_type", (Object)material.getMaterial_type());
                    m_param.put("corp_code", (Object)material.getCorp_code());
                    if ("2".equals(material.getMaterial_type())) {
                        JSONArray image_url = material.getImage_url();
                        for (int i = 0; i < image_url.size(); ++i) {
                            if (!StringUtils.isNotNull((Object)image_url.getJSONObject(i).getString("brand_name"))) continue;
                            brand_name = image_url.getJSONObject(i).getString("brand_name");
                            if (!StringUtils.isNull((Object)team_id)) break;
                            team_id = image_url.getJSONObject(i).getString("team_id");
                            break;
                        }
                    }
                    m_param.put("brand_name", (Object)brand_name);
                }
            }
            scanLog.setParam(m_param);
            this.mongoTemplate.insert((Object)scanLog);
        }
        catch (Exception scanLog) {
            // empty catch block
        }
        try {
            String url = request.getParameter("product_url") + "?material_id=" + material_id + "&open_id=" + openid + "&appid=" + appid + "&hash=" + hash + "&user_id=" + user_id + "&team_id=" + team_id + "&store_id=" + store_id;
            log.info("material_url----" + url);
            get_param_.put("open_id", (Object)openid);
            get_param_.put("product_url", (Object)url);
            try {
                1 order_commission = new /* Unavailable Anonymous Inner Class!! */;
                Thread thread = new Thread((Runnable)order_commission);
                thread.start();
            }
            catch (Exception e) {
                log.error("order recurrenceListlogistics_info error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            response.sendRedirect(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u5fae\u4fe1\u7528\u6237\u6388\u6743\u56de\u8c03\u4e8b\u4ef6", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/public/fans/{path}"}, method={RequestMethod.GET})
    public void fansAuthorizeEvent(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/public/fans/" + path;
        JSONObject param = this.getParam(request);
        DataRequest data_request = new DataRequest();
        JSONObject get_param = param.getJSONObject("get_param");
        String states = get_param.getString("state");
        log.info("--get_param---" + get_param);
        data_request.setData(get_param);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("open authorize error");
            if (data_response == null) {
                data_response = new DataResponse();
            }
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject data = data_response.getData();
        if (data == null || data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        JSONObject result_data = data.getJSONObject("message");
        log.info("get openid result:" + result_data);
        if (result_data == null || result_data.isEmpty()) {
            data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
            try {
                this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        log.info("---result_data---" + result_data);
        String openid = result_data.getString("openid");
        get_param.put("open_id", (Object)openid);
        String scope = result_data.getString("scope");
        log.info("---scope--" + scope);
        if (StringUtils.isNotNull((Object)scope) && "snsapi_userinfo".equals(scope)) {
            String access_token = result_data.getString("access_token");
            String appid = request.getParameter("appid");
            JSONObject getparam = new JSONObject();
            getparam.put("openid", (Object)openid);
            getparam.put("access_token", (Object)access_token);
            getparam.put("public_appid", (Object)appid);
            data_request.setData(getparam);
            data_response = this.wechatService.getData("/wechat/public/fans/getScopeInfo", data_request);
            if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
                log.info("\u83b7\u53d6getScopeInfo\u5931\u8d25");
                if (data_response == null) {
                    data_response = new DataResponse();
                }
                data_response.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25");
                try {
                    this.write((OutputStream)response.getOutputStream(), data_response.toJSONObject().toJSONString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            log.info("--\u83b7\u53d6getScopeInfo---" + data_response.getData());
            JSONObject wx = data_response.getData();
            this.redisClient.getValueOps().setValueString("wx_" + appid + "_" + openid, wx.toJSONString());
        }
        String unionid = StringUtils.isNull((Object)result_data.getString("unionid")) ? "" : result_data.getString("unionid");
        String url = "";
        String query_url = request.getQueryString();
        WechatOpenAuthorizer wechatOpenAuthorizer = null;
        String bean_name = get_param.getString("method");
        if (StringUtils.isNull((Object)bean_name)) {
            bean_name = "wechatOpenAuthorizerImpl";
        }
        wechatOpenAuthorizer = (WechatOpenAuthorizer)SpringUtils.getBean((String)bean_name);
        String user_id = request.getParameter("user_id");
        String team_id = request.getParameter("team_id");
        String product_id = request.getParameter("product_id");
        String product_url = request.getParameter("product_url");
        String material_id = request.getParameter("material_id");
        String article_id = request.getParameter("article_id");
        String app_id = request.getParameter("appid");
        String state = request.getParameter("state");
        JSONObject object = new JSONObject();
        object.put("open_id", (Object)openid);
        object.put("unionid", (Object)unionid);
        object.put("user_id", (Object)user_id);
        object.put("team_id", (Object)team_id);
        object.put("app_id", (Object)app_id);
        object.put("product_url", (Object)product_url);
        if (StringUtils.isNotNull((Object)material_id)) {
            object.put("material_id", (Object)material_id);
        }
        if (StringUtils.isNotNull((Object)article_id)) {
            object.put("article_id", (Object)article_id);
        }
        if (StringUtils.isNotNull((Object)product_id)) {
            object.put("product_id", (Object)product_id);
        }
        object.put("url", (Object)query_url);
        object.put("state", (Object)state);
        JSONObject url_data = null;
        try {
            url_data = wechatOpenAuthorizer.dispose(object);
        }
        catch (Exception e) {
            log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        if (url_data.containsKey((Object)"url")) {
            url = url_data.getString("url");
        }
        log.info("url:" + url);
        get_param.put("product_url", (Object)url);
        try {
            WechatOpenAuthorizer finalWechatOpenAuthorizer = wechatOpenAuthorizer;
            2 notice = new /* Unavailable Anonymous Inner Class!! */;
            Thread thread = new Thread((Runnable)notice);
            thread.start();
        }
        catch (Exception e) {
            log.error("order recurrenceListlogistics_info error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        StringBuffer html_str = new StringBuffer();
        html_str.append("<html><body><script>window.location.href='").append(url).append("';</script></body></html>");
        try {
            response.sendRedirect(url);
        }
        catch (Exception e) {
            log.error("forward error:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5fae\u4fe1\u7d20\u6750\u7ba1\u7406", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/material/{path}"}, method={RequestMethod.POST})
    public DataResponse material(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/material/" + path;
        DataRequest data_request = DataRequest.getRequestPayload((HttpServletRequest)request);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        return data_response;
    }

    @ResponseBody
    @ApiOperation(value="\u5fae\u4fe1\u6d88\u606f\u7ba1\u7406", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/message/{path}"}, method={RequestMethod.POST})
    public DataResponse message(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/wechat/message/" + path;
        DataRequest data_request = DataRequest.getRequestPayload((HttpServletRequest)request);
        DataResponse data_response = this.wechatService.getData(real_path, data_request);
        return data_response;
    }

    private JSONObject getParam(HttpServletRequest request) {
        String post_str = null;
        ServletInputStream inputStream = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            post_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("-1", "\u83b7\u53d6POST\u53c2\u6570\u5931\u8d25");
        }
        log.info("post_param:" + post_str);
        log.info("get_param:" + request.getQueryString());
        JSONObject param = new JSONObject();
        JSONObject post_param = null;
        if (StringUtils.isNotNull((Object)post_str)) {
            try {
                post_param = post_str.startsWith("<xml") ? XML.toJSONObject((String)post_str) : JSONObject.parseObject((String)post_str);
            }
            catch (Exception e) {
                log.error("xml to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (post_param == null) {
            post_param = new JSONObject();
        }
        param.put("post_param", (Object)post_param);
        JSONObject get_param_info = new JSONObject();
        Map get_param = request.getParameterMap();
        if (get_param != null && !get_param.isEmpty()) {
            Set entrys = get_param.entrySet();
            for (Map.Entry entry : entrys) {
                if (StringUtils.isNull(entry.getValue())) {
                    get_param_info.put((String)entry.getKey(), (Object)"");
                    continue;
                }
                if (((String[])entry.getValue()).length > 0) {
                    get_param_info.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                    continue;
                }
                get_param_info.put((String)entry.getKey(), (Object)"");
            }
        }
        param.put("get_param", (Object)get_param_info);
        return param;
    }

    private String getResult(DataResponse response) {
        String result = "success";
        if (response == null || Status.FAILED.equals((Object)response.getStatus())) {
            log.error("open authorize error");
            return result;
        }
        JSONObject data = response.getData();
        if (data == null || data.isEmpty()) {
            return result;
        }
        Object result_data = data.get((Object)"message");
        if (StringUtils.isNull((Object)result_data)) {
            return result;
        }
        result = result_data instanceof String ? (String)result_data : JSON.toJSONString((Object)result_data);
        return result;
    }

    private void write(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error("write error:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u5df2\u5173\u6ce8")
    @RequestMapping(value={"/checkFansExist"}, method={RequestMethod.POST})
    public DataResponse checkFansExist(@RequestBody DataRequest dataRequest) {
        return this.wechatOpenAuthorizer.checkFansExist(dataRequest.getData());
    }

    @WebLog(description="\u83b7\u53d6code2Session")
    @ResponseBody
    @ApiOperation(value="\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7ba1\u7406", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/mini/{path}"}, method={RequestMethod.POST})
    public DataResponse miniProgram(@PathVariable(value="path") String path, @RequestBody DataRequest request) {
        String real_path = "/wechat/mini/" + path;
        DataResponse data_response = this.wechatService.getData(real_path, request);
        return data_response;
    }
}

