/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller.ui;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.business.common.feignclient.UiService;
import kr.weitao.common.util.HttpClient;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@RequestMapping(value={"/ui"})
public class UiController {
    private static final Logger log = LogManager.getLogger(UiController.class);
    @Autowired
    UiService uiService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Value(value="${weixin.server.pay.domain}")
    String server_doamin;

    @RequestMapping(value={"/activity/mob/{path}"}, method={RequestMethod.POST})
    public DataResponse webApiRequest(@PathVariable(value="path") String path, @org.springframework.web.bind.annotation.RequestBody DataRequest request) {
        String real_path = "/management/activity/mob/" + path;
        log.info("uiController" + real_path);
        return this.uiService.getData(real_path, request);
    }

    @RequestMapping(value={"/order/{path}"}, method={RequestMethod.POST})
    public DataResponse orderManagement(@PathVariable(value="path") String path, @org.springframework.web.bind.annotation.RequestBody DataRequest request) {
        String real_path = "/management/order/" + path;
        log.info("uiController" + real_path);
        return this.uiService.getData(real_path, request);
    }

    @RequestMapping(value={"/activity/mobV1/{path}"}, method={RequestMethod.POST})
    public DataResponse webApiRequest3(@PathVariable(value="path") String path, @org.springframework.web.bind.annotation.RequestBody DataRequest request) {
        try {
            HttpClient httpClient = new HttpClient();
            String real_path = "/api/management/activity/mob/" + path;
            RequestBody body = RequestBody.create((MediaType)HttpClient.JSON, (String)request.toString());
            Request requestm = new Request.Builder().url(this.server_doamin + real_path).addHeader("Content-Type", "application/json; charset=utf-8").post(body).build();
            Response responsem = httpClient.post(requestm);
            String returns = responsem.body().string();
            DataResponse response = (DataResponse)JSONObject.parseObject((String)returns, DataResponse.class);
            return response;
        }
        catch (Exception e) {
            return new DataResponse().setMsg(e.getLocalizedMessage());
        }
    }
}

