/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller.tinyurl;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.business.common.feignclient.TinyUrlService;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u77ed\u94fe\u670d\u52a1", description="\u77ed\u94fe\u670d\u52a1", tags={"tinyurlService"})
@RefreshScope
@RestController
public class TinyUrlController {
    private static final Logger log = LogManager.getLogger(TinyUrlController.class);
    @Value(value="${api.server.domain}")
    String api_server_domain;
    @Autowired
    TinyUrlService tinyUrlService;

    @ApiOperation(value="\u77ed\u94fe\u670d\u52a1", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/tinyUrl/{path}"}, method={RequestMethod.POST})
    public DataResponse generate(@PathVariable(value="path") String path, @RequestBody DataRequest dataRequest) {
        String real_url = "/tinyUrl/" + path;
        return this.tinyUrlService.getData(real_url, dataRequest);
    }

    @ApiOperation(value="\u77ed\u94fe\u670d\u52a1\u8df3\u8f6c", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/s/{path}"}, method={RequestMethod.GET})
    public void visit(@PathVariable(value="path") String path, HttpServletRequest request, HttpServletResponse response) {
        String real_url = "/tinyUrl/getOrgUrl";
        DataRequest data_request = new DataRequest();
        JSONObject get_param = new JSONObject();
        get_param.put("tiny_url", (Object)(this.api_server_domain + "/s/" + path));
        data_request.setData(get_param);
        DataResponse dataResponse = this.tinyUrlService.getData(real_url, data_request);
        log.info("--\u83b7\u53d6\u8fde\u63a5---" + dataResponse);
        try {
            if ("SUCCESS".equals(dataResponse.getStatus().toString())) {
                String org_url = dataResponse.getData().getString("org_url");
                response.sendRedirect(org_url);
            } else {
                response.sendRedirect("https://weitao.kr/manage");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

