/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller.pay;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.business.common.feignclient.WeixinPayService;
import kr.weitao.common.util.IpAdrressUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.XML;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u652f\u4ed8", description="\u652f\u4ed8\u670d\u52a1", tags={"payService"})
@RestController
@RefreshScope
public class PayController {
    private static final Logger log = LogManager.getLogger(PayController.class);
    @Autowired
    WeixinPayService weixinPayService;

    @ApiOperation(value="\u4e0b\u5355", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/weixinOrder/unifiedOrder"}, method={RequestMethod.POST})
    public DataResponse unifiedOrder(@RequestBody DataRequest request) {
        String real_path = "/weixinOrder/unifiedOrder";
        return this.weixinPayService.getData(real_path, request);
    }

    @ApiOperation(value="\u9000\u6b3e", notes="\u6d4b\u8bd5\u53c2\u6570{\n\t\"id\": \"string\",\n\t\"method\": \"string\",\n\t\"sign\": \"string\",\n\t\"source\": \"WHALE\",\n\t\"timestamp\": \"string\",\n\t\"access_key\": \"string\",\n\t\"data\": {\n\t\t\"order_id\": \"5b64084fca2d3c4fb51a8e4c\",\n\t\t\"out_refund_no\": \"5b64084fca2d3c4fb51a8e4c--45a5\",\n\t\t\"refund_fee\": \"0.1\"\n\t\n\t}\n}")
    @RequestMapping(value={"/weixinOrder/refund"}, method={RequestMethod.POST})
    public DataResponse refund(@RequestBody DataRequest request) {
        String real_path = "/weixinOrder/refund";
        return this.weixinPayService.getData(real_path, request);
    }

    @ResponseBody
    @RequestMapping(value={"/weixinOrder/payCallback"}, method={RequestMethod.POST})
    public String weixinorder(HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/weixinOrder/payCallback";
        String weixin_paycallback_str = null;
        ServletInputStream inputStream = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            weixin_paycallback_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
            return "";
        }
        log.info("rv:" + weixin_paycallback_str);
        StringBuffer result_sb = new StringBuffer("<xml>");
        if (StringUtils.isNull((Object)weixin_paycallback_str)) {
            log.error("param can not be null");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        JSONObject weixinpay_callback_param = XML.toJSONObject((String)weixin_paycallback_str);
        log.info("----weixinpay_callback_param------" + weixinpay_callback_param);
        if (weixinpay_callback_param == null || weixinpay_callback_param.isEmpty()) {
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        DataRequest data_request = new DataRequest();
        data_request.setData(weixinpay_callback_param);
        if (weixinpay_callback_param.containsKey((Object)"req_info")) {
            real_path = "/weixinOrder/refundCallback";
        }
        DataResponse data_response = null;
        try {
            data_response = this.weixinPayService.getData(real_path, data_request);
        }
        catch (Exception e) {
            log.error("call paysuccess callback error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("dispose weixin pay callback error");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        result_sb.append("<return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg>");
        result_sb.append("</xml>");
        return result_sb.toString();
    }

    @ResponseBody
    @RequestMapping(value={"/weixinOrder/refundCallback"}, method={RequestMethod.POST})
    public String refundorder(HttpServletRequest request, HttpServletResponse response) {
        String real_path = "/weixinOrder/refundCallback";
        String weixin_paycallback_str = null;
        ServletInputStream inputStream = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            weixin_paycallback_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
            return "";
        }
        log.info("rv:" + weixin_paycallback_str);
        StringBuffer result_sb = new StringBuffer("<xml>");
        if (StringUtils.isNull((Object)weixin_paycallback_str)) {
            log.error("param can not be null");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        JSONObject weixinpay_callback_param = XML.toJSONObject((String)weixin_paycallback_str);
        log.info("----weixinpay_callback_param------" + weixinpay_callback_param);
        if (weixinpay_callback_param == null || weixinpay_callback_param.isEmpty()) {
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        DataRequest data_request = new DataRequest();
        data_request.setData(weixinpay_callback_param);
        DataResponse data_response = this.weixinPayService.getData(real_path, data_request);
        if (data_response == null || Status.FAILED.equals((Object)data_response.getStatus())) {
            log.error("dispose weixin pay callback error");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        result_sb.append("<return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg>");
        result_sb.append("</xml>");
        return result_sb.toString();
    }

    @ResponseBody
    @RequestMapping(value={"/payCallback/**"}, method={RequestMethod.POST})
    public String payCallBack(HttpServletRequest request, HttpServletResponse response) {
        String real_path = request.getServletPath();
        String weixin_paycallback_str = null;
        ServletInputStream inputStream = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            weixin_paycallback_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
            return "";
        }
        log.info("rv:" + weixin_paycallback_str);
        StringBuffer result_sb = new StringBuffer("<xml>");
        if (StringUtils.isNull((Object)weixin_paycallback_str)) {
            log.error("param can not be null");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        JSONObject weixinpay_callback_param = XML.toJSONObject((String)weixin_paycallback_str);
        log.info("----weixinpay_callback_param------" + weixinpay_callback_param);
        if (weixinpay_callback_param == null || weixinpay_callback_param.isEmpty()) {
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        DataRequest data_request = new DataRequest();
        data_request.setData(weixinpay_callback_param);
        if (weixinpay_callback_param.containsKey((Object)"req_info")) {
            real_path = "/weixinOrder/refundCallback";
        }
        String data_response = this.weixinPayService.getStringData(real_path, data_request);
        if (StringUtils.isNull((Object)data_request)) {
            log.error("dispose weixin pay callback error");
            result_sb.append("<return_code><![CDATA[FAILED]]></return_code><return_msg><![CDATA[FAILED]]></return_msg>");
            result_sb.append("</xml>");
            return result_sb.toString();
        }
        return data_response;
    }

    @ApiOperation(value="\u652f\u4ed8", notes="\u6d4b\u8bd5\u53c2\u6570<br>{<br>\"id\": \"string\",<br>\"method\": \"string\",<br>\"sign\": \"string\",<br>\"source\": \"WHALE\",<br>\"timestamp\": \"string\",<br>\"access_key\": \"string\",<br>\"data\": {<br>\"user_id\": \"\u767b\u9646\u7528\u6237\u4e3b\u952e\",<br>\"name\": \"\u56e2\u961f\u540d\u79f0\"<br>}<br>}")
    @RequestMapping(value={"/pay/**"}, method={RequestMethod.POST})
    public DataResponse pay(HttpServletRequest request, HttpServletResponse response) {
        String real_path = request.getServletPath();
        log.error("real_path:" + real_path);
        ServletInputStream inputStream = null;
        String weixin_paycallback_str = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            weixin_paycallback_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u652f\u4ed8\u5931\u8d25");
        }
        log.info("param:" + weixin_paycallback_str);
        JSONObject param = JSONObject.parseObject((String)weixin_paycallback_str);
        param = param.getJSONObject("data");
        String ip = IpAdrressUtil.getIpAddr((HttpServletRequest)request);
        param.put("ip", (Object)ip);
        DataRequest data_request = new DataRequest();
        data_request.setData(param);
        return this.weixinPayService.getData(real_path, data_request);
    }
}

