/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.business.common.agent.WechatAgent;
import kr.weitao.business.common.feignclient.TinyUrlService;
import kr.weitao.business.common.feignclient.WechatService;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.LogShare;
import kr.weitao.business.entity.data.LogMpCode;
import kr.weitao.business.entity.data.Material;
import kr.weitao.business.entity.data.Product;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.WechatOpenAuthorizer;
import kr.weitao.weitaokr.service.common.UserRedisUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5206\u4eab", description="\u5206\u4eab\u7ba1\u7406", tags={"share"})
@RestController
@RefreshScope
@RequestMapping(value={"/share"})
public class ShareController {
    private static final Logger log = LogManager.getLogger(ShareController.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    WechatService wechatService;
    @Autowired
    TinyUrlService tinyUrlService;
    @Autowired
    UserRedisUtils userRedisUtils;
    @Autowired
    WechatAgent wechatAgent;
    @Autowired
    WechatOpenAuthorizer wechatOpenAuthorizer;
    @Value(value="${weixin.server.pay.domain}")
    String web_server_domain;
    @Value(value="${page.orderDetail}")
    String orderDetailPage;
    @Value(value="${page.goodDetail}")
    String goodDetailPage;
    @Value(value="${page.groupDetail}")
    String groupDetailPage;
    @Value(value="${page.taskDetail}")
    String taskDetailPage;
    @Value(value="${page.appointmentDetail}")
    String appointmentDetailPage;
    @Value(value="${page.container}")
    String containerPage;

    @ApiOperation(value="\u65b0\u589e\u5206\u4eab\u65e5\u5fd7", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {<br>\"user_id\":\"18652083705\",\n<br>\"src\":\"\u5206\u4eab\u6765\u6e90 \u8be6\u60c5\u9875\u9762detail/\u52a8\u6001news\",\n<br>\"type\":\"\u5206\u4eab\u7c7b\u578b \u5546\u54c1product/\u7d20\u6750material/\u6d3b\u52a8activity/\u8ba2\u5355order\",\n<br>\"product_id\":\"\u5546\u54c1id\",\n<br>\"material_id\":\"\u7d20\u6750id\",\n<br>\"activity_id\":\"\u6d3b\u52a8id\",\n<br>\"order_id\":\"\u8ba2\u5355id\",\n<br>\"team_id\":\"\u56e2\u961fid\"\n<br>},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public DataResponse create(@RequestBody DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String log_share_id = data.getString("log_share_id");
        LogShare logShare = (LogShare)JSON.parseObject((String)data.toJSONString(), LogShare.class);
        logShare.setCreated_time(TimeUtils.getTime((long)System.currentTimeMillis()));
        logShare.setCreator(logShare.getUser_id());
        if ("material".equals(logShare.getType())) {
            String material_id = logShare.getMaterial_id();
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id));
            Material material = (Material)this.mongoTemplate.findOne(query, Material.class);
            String brand_name = "";
            if (material != null) {
                if ("2".equals(material.getMaterial_type())) {
                    JSONArray image_url = material.getImage_url();
                    for (int i = 0; i < image_url.size(); ++i) {
                        if (!StringUtils.isNotNull((Object)image_url.getJSONObject(i).getString("brand_name"))) continue;
                        brand_name = image_url.getJSONObject(i).getString("brand_name");
                        break;
                    }
                }
                logShare.setBrand_name(brand_name);
                logShare.setCorp_code(material.getCorp_code());
            }
        } else if ("product".equals(logShare.getType())) {
            String product_id = logShare.getProduct_id();
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id));
            Product product = (Product)this.mongoTemplate.findOne(query, Product.class);
            if (product != null) {
                logShare.setBrand_name(product.getBrand_name());
                logShare.setCorp_code(product.getCorp_code());
            }
        }
        if (StringUtils.isNotNull((Object)log_share_id)) {
            logShare.set_id(new ObjectId(log_share_id));
            logShare.setLog_share_id(log_share_id);
        }
        this.mongoTemplate.insert((Object)logShare);
        JSONObject object = new JSONObject();
        object.put("message", (Object)"\u5206\u4eab\u6210\u529f");
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u4eab\u94fe\u63a5", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {<br>\"user_id\":\"18652083705\",\n<br>\"product_id\":\"\u5546\u54c1id\",\n<br>\"material_id\":\"\u7d20\u6750id\",\n<br>\"team_id\":\"\u56e2\u961fid\"\n<br>},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/getshareUrl"}, method={RequestMethod.POST})
    public DataResponse getshareUrl(@RequestBody DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String user_id = data.getString("user_id");
        String team_id = data.getString("team_id");
        String product_id = data.getString("product_id");
        String activity_id = data.getString("activity_id");
        String is_scope = data.getString("is_scope");
        String material_id = data.getString("material_id");
        String url = data.getString("url");
        if (StringUtils.isNull((Object)url)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("url\u53c2\u6570\u4e3a\u7a7a");
        }
        String need_tiny = data.getString("need_tiny");
        JSONObject get_param = new JSONObject();
        JSONObject post_param = new JSONObject();
        post_param.put("method", (Object)"getOrderVipOpenidAuthorizeUrl");
        post_param.put("url", (Object)url);
        String brand_name = "";
        String hash = "";
        String corp_code = "";
        String app_id = "";
        if ("N".equals(is_scope)) {
            post_param.put("scope", (Object)"snsapi_userinfo");
        } else {
            post_param.put("scope", (Object)"snsapi_base");
        }
        if (StringUtils.isNotNull((Object)product_id)) {
            Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
            corp_code = product.getCorp_code();
        }
        String redir = "";
        if (StringUtils.isNotNull((Object)activity_id)) {
            redir = "/api/management/activity/mob/getOpenid?";
            post_param.put("state", (Object)"activity");
        } else if (StringUtils.isNotNull((Object)corp_code)) {
            if (StringUtils.isNotNull((Object)material_id)) {
                post_param.put("state", (Object)"material");
                if (StringUtils.isNotNull((Object)product_id)) {
                    redir = "/wechat/corpMaterial/getWebAuthorize?";
                    Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                    brand_name = product.getBrand_name();
                    Corp corp = null;
                    corp = StringUtils.isNotNull((Object)brand_name) ? (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code).and("app_name").is((Object)brand_name)), Corp.class) : (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code)), Corp.class);
                    if (null == corp) {
                        corp = (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)"C00000")), Corp.class);
                    }
                    app_id = corp.getApp_id();
                    hash = corp.getHash();
                    post_param.put("app_id", (Object)app_id);
                    post_param.put("scope", (Object)"snsapi_userinfo");
                } else {
                    redir = "/wechat/public/fans/getWebAuthorize?";
                }
            } else {
                if (StringUtils.isNotNull((Object)product_id)) {
                    post_param.put("state", (Object)"product");
                }
                redir = "/wechat/public/fans/getWebAuthorize?";
            }
        } else {
            if (StringUtils.isNotNull((Object)material_id)) {
                post_param.put("state", (Object)"material");
            }
            if (StringUtils.isNull((Object)material_id) && StringUtils.isNotNull((Object)product_id)) {
                post_param.put("state", (Object)"product");
            }
            redir = "/wechat/public/fans/getWebAuthorize?";
        }
        StringBuffer redirectUrl = new StringBuffer(redir);
        if (!StringUtils.isNotNull((Object)user_id)) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u7f3a\u5c11user_id\u53c2\u6570");
        }
        redirectUrl.append("user_id=" + user_id);
        if (StringUtils.isNotNull((Object)team_id)) {
            redirectUrl.append("&team_id=" + team_id);
        }
        if (StringUtils.isNotNull((Object)hash)) {
            redirectUrl.append("&hash=" + hash);
        }
        if (StringUtils.isNotNull((Object)product_id)) {
            redirectUrl.append("&product_id=" + product_id);
        }
        if (StringUtils.isNotNull((Object)activity_id)) {
            redirectUrl.append("&aid=" + activity_id);
            redirectUrl.append("&uid=" + user_id);
            if (StringUtils.isNotNull((Object)team_id)) {
                redirectUrl.append("&tid=" + team_id);
            }
        }
        if (StringUtils.isNotNull((Object)material_id)) {
            redirectUrl.append("&material_id=" + material_id);
            Material material = (Material)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"material_id").is((Object)material_id)), Material.class);
            if (null != material && StringUtils.isNotNull((Object)material.getApp_id())) {
                post_param.put("app_id", (Object)material.getApp_id());
            }
            if (StringUtils.isNotNull((Object)data.getString("article_id"))) {
                String article_id = data.getString("article_id");
                redirectUrl.append("&article_id=" + article_id);
                url = this.web_server_domain + "/m/share/news.html?id=" + material_id + "&articleId=" + article_id;
            }
        }
        if (StringUtils.isNull((Object)material_id) && StringUtils.isNotNull((Object)product_id)) {
            Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
            brand_name = product.getBrand_name();
            Corp corp = (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code).and("app_name").is((Object)brand_name)), Corp.class);
            if (null != corp) {
                app_id = corp.getApp_id();
                hash = corp.getHash();
                post_param.put("app_id", (Object)app_id);
                post_param.put("scope", (Object)"snsapi_userinfo");
            }
        }
        if (StringUtils.isNotNull((Object)url)) {
            try {
                redirectUrl.append("&product_url=" + URLEncoder.encode(url, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        post_param.put("redirect_url", (Object)redirectUrl.toString());
        log.info("---redirectUrl---" + post_param);
        JSONObject param = new JSONObject();
        param.put("get_param", (Object)get_param);
        param.put("post_param", (Object)post_param);
        DataRequest data_request = new DataRequest();
        data_request.setData(param);
        DataResponse data_response = this.wechatService.getData("/wechat/public/authorize/getAuhtorizeUrl", data_request);
        log.info("data_response-----" + data_response);
        if (!Status.SUCCESS.equals((Object)data_response.getStatus())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        JSONObject result_jo = data_response.getData();
        if (result_jo == null || !result_jo.containsKey((Object)"authorize_url")) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        url = result_jo.getString("authorize_url");
        if (StringUtils.isNull((Object)url)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        log.info("-authorize_url---" + url);
        if ("N".equals(need_tiny)) {
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
        }
        data.put("url", (Object)url);
        data_response = this.tinyUrlService.getData("/tinyUrl/generate", dataRequest);
        log.info("data_response-----" + data_response);
        if (!Status.SUCCESS.equals((Object)data_response.getStatus())) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        result_jo = data_response.getData();
        if (result_jo == null || !result_jo.containsKey((Object)"tiny_url")) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        url = result_jo.getString("tiny_url");
        if (StringUtils.isNull((Object)url)) {
            return new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6url\u5931\u8d25");
        }
        log.info("--tiny_url--" + url);
        JSONObject object = new JSONObject();
        object.put("url", (Object)url);
        return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
    }

    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {<br>\"user_id\":\"18652083705\",\n<br>\"product_id\":\"\u5546\u54c1id\",\n<br>\"material_id\":\"\u7d20\u6750id\",\n<br>\"team_id\":\"\u56e2\u961fid\"\n<br>},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/getshareUrl/v2"}, method={RequestMethod.POST})
    public DataResponse getshareUrlV2(@RequestBody DataRequest dataRequest) {
        StringBuffer param;
        Object product;
        Query query;
        JSONObject data = dataRequest.getData();
        String userId = data.getString("user_id");
        String miniAppid = data.getString("mini_appid");
        String productId = data.getString("product_id");
        String activityId = data.getString("activity_id");
        String materialId = data.getString("material_id");
        String orderId = data.getString("order_id");
        String taskId = data.getString("task_id");
        String vipId = data.getString("vip_id");
        String url = data.getString("url");
        String team_id = data.getString("team_id");
        JSONObject sceneValue = new JSONObject();
        if (StringUtils.isNotNull((Object)userId)) {
            sceneValue.put("user_id", (Object)userId);
        }
        if (StringUtils.isNotNull((Object)team_id)) {
            sceneValue.put("team_id", (Object)team_id);
        }
        if (StringUtils.isNotNull((Object)vipId)) {
            sceneValue.put("vip_id", (Object)vipId);
        }
        String log_share_id = new ObjectId().toString();
        if (StringUtils.isNotNull((Object)productId)) {
            sceneValue.put("product_id", (Object)productId);
            sceneValue.put("log_share_id", (Object)log_share_id);
            query = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)productId));
            product = (Product)this.mongoTemplate.findOne(query, Product.class);
            if (StringUtils.isNull((Object)url)) {
                url = "Y".equals(product.getIs_group()) ? this.groupDetailPage : this.goodDetailPage;
            }
        }
        if (StringUtils.isNotNull((Object)activityId)) {
            sceneValue.put("activity_id", (Object)activityId);
            if (StringUtils.isNull((Object)url)) {
                url = this.appointmentDetailPage;
            }
        }
        if (StringUtils.isNotNull((Object)orderId)) {
            sceneValue.put("order_id", (Object)orderId);
            if (StringUtils.isNull((Object)url)) {
                url = this.orderDetailPage;
            }
        }
        if (StringUtils.isNotNull((Object)taskId)) {
            sceneValue.put("task_id", (Object)taskId);
            if (StringUtils.isNull((Object)url)) {
                url = this.taskDetailPage;
            }
        }
        if (StringUtils.isNotNull((Object)materialId)) {
            sceneValue.put("material_id", (Object)materialId);
            if (StringUtils.isNull((Object)url)) {
                url = this.goodDetailPage;
            }
        }
        if (url.startsWith(this.web_server_domain)) {
            param = new StringBuffer();
            for (String key : sceneValue.keySet()) {
                param.append(key + "=" + sceneValue.get((Object)key).toString() + "&");
            }
            String paramStr = param.toString();
            paramStr = paramStr.substring(0, paramStr.length() - 1);
            url = url.indexOf("?") >= 0 ? url + "&" + paramStr : url + "?" + paramStr;
            log.info("-authorize_url---" + url);
            JSONObject object = new JSONObject();
            object.put("url", (Object)url);
            object.put("log_share_id", (Object)log_share_id);
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(object);
        }
        if (StringUtils.isNull((Object)miniAppid) && StringUtils.isNotNull((Object)userId)) {
            JSONObject user = this.userRedisUtils.getUser(userId, false);
            String corp_code = user.getString("corp_code");
            BasicDBObject query2 = new BasicDBObject();
            query2.put((Object)"corp_code", (Object)corp_code);
            DBObject object = this.mongoTemplate.getCollection("def_corp").findOne((DBObject)query2);
            miniAppid = object.get("mini_appid").toString();
        }
        if (StringUtils.isNotNull((Object)productId)) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)productId));
            product = (Product)this.mongoTemplate.findOne(query, Product.class);
            String canMiniShow = StringUtils.isNotNull((Object)product.getCan_mini_show()) ? product.getCan_mini_show() : "Y";
            LogMpCode logMpCode = new LogMpCode();
            logMpCode.setCreated_time(TimeUtils.getCurrentTimeInString());
            logMpCode.setType("product");
            logMpCode.setIs_read("N");
            logMpCode.setIds(productId);
            JSONObject mpCodeParam = new JSONObject();
            for (String key : sceneValue.keySet()) {
                mpCodeParam.put(key, sceneValue.get((Object)key));
            }
            mpCodeParam.put("can_mini_show", (Object)canMiniShow);
            logMpCode.setParam(mpCodeParam);
            this.mongoTemplate.save((Object)logMpCode);
            if ("Y".equals(canMiniShow)) {
                String id = logMpCode.get_id().toString();
                JSONObject param2 = new JSONObject();
                param2.put("scene_param", (Object)id);
                param2.put("page", (Object)url);
                param2.put("mini_appid", (Object)miniAppid);
                try {
                    JSONObject result = this.wechatAgent.getData(param2, "/wechat/mini/getWXACodeUnlimitV2");
                    if (result.containsKey((Object)"qr_base64")) {
                        JSONObject dataObject = new JSONObject();
                        dataObject.put("qrcodeStream", (Object)result.getString("qr_base64"));
                        dataObject.put("log_share_id", (Object)log_share_id);
                        log.info("\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801=======\u300b\u300b\u300b\u300b\u300b" + dataObject);
                        return new DataResponse().setData(dataObject).setStatus(Status.SUCCESS).setCode("0");
                    }
                    result.put("log_share_id", (Object)log_share_id);
                    return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5c0f\u7a0b\u5e8f\u7801\u751f\u6210\u5931\u8d25");
                }
            }
        }
        log.info("----jumpUrl----" + sceneValue.toString());
        if (sceneValue.containsKey((Object)"product_price")) {
            sceneValue.remove((Object)"product_price");
        }
        if (sceneValue.containsKey((Object)"material_id")) {
            sceneValue.remove((Object)"material_id");
        }
        param = new JSONObject();
        param.put("scene_param", sceneValue);
        param.put("page", url);
        param.put("mini_appid", miniAppid);
        try {
            JSONObject result = this.wechatAgent.getData((JSONObject)param, "/wechat/mini/getWXACode");
            if (result.containsKey((Object)"qr_base64")) {
                JSONObject dataObject = new JSONObject();
                dataObject.put("qrcodeStream", (Object)result.getString("qr_base64"));
                dataObject.put("log_share_id", (Object)log_share_id);
                log.info("\u751f\u6210\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u53c2\u6570=========>>>>>>>>>" + dataObject);
                return new DataResponse().setData(dataObject).setStatus(Status.SUCCESS).setCode("0");
            }
            result.put("log_share_id", (Object)log_share_id);
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5c0f\u7a0b\u5e8f\u7801\u751f\u6210\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {<br>\"user_id\":\"18652083705\",\n<br>\"product_id\":\"\u5546\u54c1id\",\n<br>\"material_id\":\"\u7d20\u6750id\",\n<br>\"team_id\":\"\u56e2\u961fid\"\n<br>},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/getMpCode"}, method={RequestMethod.POST})
    public DataResponse getMpCode(@RequestBody DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        try {
            JSONObject result = this.wechatOpenAuthorizer.getMpCode(data);
            if (result.containsKey((Object)"url")) {
                JSONObject dataObject = new JSONObject();
                dataObject.put("url", (Object)result.getString("url"));
                return new DataResponse().setData(dataObject).setStatus(Status.SUCCESS).setCode("0");
            }
            return new DataResponse().setCode("0").setStatus(Status.SUCCESS).setData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5c0f\u7a0b\u5e8f\u7801\u751f\u6210\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getLogShareId"}, method={RequestMethod.POST})
    @ResponseBody
    public DataResponse getLogShareId(HttpServletRequest request) {
        ObjectId share_log_id = new ObjectId();
        JSONObject data = new JSONObject();
        data.put("log_share_id", (Object)share_log_id.toString());
        log.info("\u751f\u6210\u65b0\u7684\u5206\u4eabid======>>" + share_log_id.toString());
        return new DataResponse().setCode("0").setMsg("\u8bf7\u6c42\u6210\u529f").setData(data).setStatus(Status.SUCCESS);
    }
}

