/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.business.common.feignclient.WechatService;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.OrderService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u8ba2\u5355\u7ba1\u7406", description="\u8ba2\u5355\u7ba1\u7406", tags={"order"})
@RestController
@RefreshScope
@RequestMapping(value={"/order"})
public class OrderController {
    private static final Logger log = LogManager.getLogger(OrderController.class);
    @Autowired
    OrderService orderService;
    @Autowired
    WechatService wechatService;
    @Value(value="${weixin.server.pay.domain}")
    String server_doamin;

    @ApiOperation(value="\u65b0\u589e", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": { \n  \"user_id\" : \"18652083705\",\n    \"productList\" : [ \n        {\t\n            \"product_id\":\"\",\n            \"product_image_url\":\"\",\n            \"product_name\" : \"\u6d4b\u8bd5\u5546\u54c1\",\n            \"product_desc\":\"5000ml\u88c5\",\n            \"product_num\" : \"3\",\n            \"product_price\" : \"12312\"\n        }\n    ],\n    \"order_num\" : \"3\",\n    \"order_freight\" : \"112\",\n    \"order_reback_time\" : {\n         \"time\":\"2017-01-11 11:11:11\",\n         \"cycle\":\"\u6bcf\u5468\"\n       },\n    \"order_time\" : \"2017-01-11 11:11:11\",\n    \"order_price\" : 123,\n    \"order_vip\" : {\n        \"vip_name\" : \"\u5f20\u4e9a\u660e\",\n        \"vip_id\" : \"5a3c7b0143f091d145b93ec2\"\n    },\n    \"recurrence\" : {\n        \"type\" : \"Custom/Fixed\",\n        \"value\" : \"week/day/not/year/month/week,1\"\n    }\n    },\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public DataResponse create(@RequestBody DataRequest dataRequest) {
        return this.orderService.add(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"id\":\"123123123213\",\"user_id\":\"123213\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    public DataResponse remove(@RequestBody DataRequest dataRequest) {
        return this.orderService.del(dataRequest);
    }

    @ApiOperation(value="\u4fee\u6539", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": { \n  \"user_id\" : \"18652083705\",\n    \"id\" : \"5a3c7b0143f091d145b93ec2\",\n    \"productList\" : [ \n        {\t\n            \"product_id\":\"5a3c7b0143f091d145b\",\n            \"product_image_url\":\"goods_imgs/5a434d4cca2d3c2a3fa64f9d/5a434d4cca2d3c2a3fa64f9d-1514381912902.jpg\",\n            \"product_name\" : \"\u6d4b\u8bd5\u5546\u54c1\",\n            \"product_desc\":\"5000ml\u88c5\",\n            \"product_num\" : \"3\",\n            \"product_revisit_time\" : \"2017-01-11 11:11:11\",\n            \"product_price\" : \"12312\"\n        }\n    ],\n    \"order_num\" : \"3\",\n    \"order_freight\" : \"112\",\n    \"order_reback_time\" : {\n         \"time\":\"2017-01-11 11:11:11\",\n         \"cycle\":\"\u6bcf\u5468\"\n       },\n    \"order_time\" : \"2017-01-11 11:11:11\",\n    \"order_price\" : 123,\n    \"order_vip\" : {\n        \"vip_name\" : \"\u5f20\u4e9a\u660e\",\n        \"vip_id\" : \"5a3c7b0143f091d145b93ec2\"\n    },\n    \"recurrence\" : {\n        \"type\" : \"Custom/Fixed\",\n        \"value\" : \"week/day/not/year/month/week,1\"\n    }\n    },\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/mod"}, method={RequestMethod.POST})
    public DataResponse mod(@RequestBody DataRequest dataRequest) {
        return this.orderService.mod(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"00001\",\"query_type\":\"\u5168\u90e8\uff1a\u201c\u201d,\u5f85\u4ed8\u6b3e\uff1a-1 ,\u4ee3\u53d1\u8d27\uff1a0 ,\u5df2\u53d1\u8d27\uff1a1 ,\u9000\u8d27\uff1a3\n\",\"page_size\":\"10\",\"page_num\":\"0\",\"vip_id\":\"\",\"id\":\"00001\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    public DataResponse queryList(@RequestBody DataRequest dataRequest) {
        return this.orderService.queryList(dataRequest);
    }

    @ApiOperation(value="\u641c\u7d22", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"00001\",\"content\":\"\u641c\u7d22\u5185\u5bb9(\u6587\u672c\u7c7b\u578b \u5982\uff1a\u5f20/date\u7c7b\u578b \u5982\uff1a2017-10-04 00:00:00 ~ 2017-11-09 00:00:00)\",\"type\":\"text/date\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public DataResponse search(@RequestBody DataRequest dataRequest) {
        return this.orderService.search(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"order_id\":\"5ae30cb97582b80b0a16a06e\",\"user_id\":\"18652083705\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public DataResponse info(@RequestBody DataRequest dataRequest) {
        return this.orderService.info(dataRequest);
    }

    @RequestMapping(value={"/getUrl"}, method={RequestMethod.GET})
    public DataResponse getOrderUrl(HttpServletRequest request, HttpServletResponse response) {
        DataResponse response1 = new DataResponse();
        String userAgent = request.getHeader("user-agent").toLowerCase();
        boolean is_weixin = false;
        if (userAgent.contains("micromessenger")) {
            is_weixin = true;
        }
        String url = request.getParameter("url");
        String order_id = request.getParameter("order_id");
        log.info("----server_doamin--" + this.server_doamin);
        log.info("--request---" + url + "--order_id---" + order_id);
        log.info((Object)is_weixin);
        if (is_weixin) {
            JSONObject get_param = new JSONObject();
            JSONObject post_param = new JSONObject();
            post_param.put("method", (Object)"getOrderVipOpenidAuthorizeUrl");
            post_param.put("order_id", (Object)order_id);
            post_param.put("url", (Object)url);
            post_param.put("scope", (Object)"snsapi_userinfo");
            post_param.put("redirect_url", (Object)("/wechat/callback/getWebAuthorize?order_id=" + order_id + "&order_url=" + url));
            JSONObject param = new JSONObject();
            param.put("get_param", (Object)get_param);
            param.put("post_param", (Object)post_param);
            DataRequest data_request = new DataRequest();
            data_request.setData(param);
            DataResponse data_response = null;
            try {
                data_response = this.wechatService.getData("/wechat/public/authorize/getAuhtorizeUrl", data_request);
            }
            catch (CommonException e) {
                log.error("get weixin authorizhe error:" + e.getLocalizedMessage(), (Throwable)e);
                return response1.setStatus(Status.FAILED).setCode(e.getCode()).setMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("get weixin authorizhe error:" + e.getLocalizedMessage(), (Throwable)e);
            }
            if (data_response == null) {
                data_response = new DataResponse().setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            log.info("data_response-----" + data_response);
            if (!Status.SUCCESS.equals((Object)data_response.getStatus())) {
                return response1.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            JSONObject result_jo = data_response.getData();
            if (result_jo == null || !result_jo.containsKey((Object)"authorize_url")) {
                return response1.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            url = result_jo.getString("authorize_url");
            if (StringUtils.isNull((Object)url)) {
                return response1.setStatus(Status.FAILED).setCode("-1").setMsg("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            log.info(url);
            try {
                response.sendRedirect(url);
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            try {
                url = this.server_doamin + url + "?order_id=" + order_id;
                log.info(url);
                response.sendRedirect(url);
            }
            catch (Exception e) {
                log.error(" error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return response1.setStatus(Status.SUCCESS).setCode("0").setMsg("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f......");
    }

    @ApiOperation(value="\u67e5\u8be2VIP\u8ba2\u5355\u6570\u91cf", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"order_id\":\"5ae30cb97582b80b0a16a06e\",\"user_id\":\"18652083705\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/getOrderCount"}, method={RequestMethod.POST})
    public DataResponse getOrderCount(@RequestBody DataRequest dataRequest) {
        return this.orderService.getOrderCount(dataRequest);
    }
}

