/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.XML;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.redis.RedisClient;
import kr.weitao.weitaokr.network.NetWorkCommon;
import kr.weitao.weitaokr.service.MessageService;
import kr.weitao.weitaokr.service.WxService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4f1a\u8bdd\u7ba1\u7406", description="\u4f1a\u8bdd\u7ba1\u7406", tags={"message"})
@RestController
@RefreshScope
@RequestMapping(value={"/message"})
public class MessageController {
    private static final Logger log = LogManager.getLogger(MessageController.class);
    @Qualifier(value="messageServiceImplV1")
    @Autowired
    MessageService messageService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisClient redisClient;
    @Autowired
    WxService wxService;

    @ApiOperation(value="\u53d1\u9001\u7528\u6237", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"wx_id\":\"\u63a5\u6536\u8005\u5fae\u4fe1id\",\"nick_name\":\"\u6bdb\u4f1f\u680b\",\"head_img\":\"\u56fe\u7247\u5730\u5740\",\"message_content\":\"\u5185\u5bb9\",\"message_type\":\"text\",\"message_date\":\"2017-10-11 12:12:22\",\"id\":\"\u53d1\u9001\u8005\u5fae\u4fe1id\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatToUser"}, method={RequestMethod.POST})
    public DataResponse pushToUser(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatToUser(dataRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u53d1\u9001\u7528\u6237", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"wx_id\":\"\u63a5\u6536\u8005\u5fae\u4fe1id\",\"nick_name\":\"\u6bdb\u4f1f\u680b\",\"head_img\":\"\u56fe\u7247\u5730\u5740\",\"message_content\":\"\u5185\u5bb9\",\"message_type\":\"text\",\"message_date\":\"2017-10-11 12:12:22\",\"id\":\"\u53d1\u9001\u8005\u5fae\u4fe1id\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/miniChatToUser"}, method={RequestMethod.GET, RequestMethod.POST})
    public void miniChatToUser(HttpServletRequest request, HttpServletResponse response) {
        boolean isGet = request.getMethod().toLowerCase().equals("get");
        if (isGet) {
            String signature = request.getParameter("signature");
            String timestamp = request.getParameter("timestamp");
            String nonce = request.getParameter("nonce");
            String echostr = request.getParameter("echostr");
            log.info(signature + timestamp + nonce + echostr);
            try (PrintWriter out = null;){
                out = response.getWriter();
                out.print(echostr);
                out.flush();
            }
        } else {
            try {
                request.setCharacterEncoding("UTF-8");
                response.setCharacterEncoding("UTF-8");
                JSONObject object = this.getParam(request);
                String result = NetWorkCommon.common((JSONObject)object, (String)"/message/miniChatToUserV2");
                log.info("----" + result);
                PrintWriter out = response.getWriter();
                out.print("SUCCESS");
                out.close();
            }
            catch (Exception ex) {
                log.error("\u5fae\u4fe1\u5e10\u53f7\u63a5\u53e3\u914d\u7f6e\u5931\u8d25\uff01", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    @ApiOperation(value="\u53d1\u9001\u4f1a\u5458", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"111\",\"nick_name\":\"\u6bdb\u4f1f\u680b\",\"head_img\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_content\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_type\":\"Text\u3001Picture\u3001Sharing\",\"message_date\":\"2017-10-11 12:12:22\",\"vip_id\":\"01001\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/miniChatToUserV2"}, method={RequestMethod.POST})
    public String miniChatToUserV2(@RequestBody DataRequest dataRequest) {
        JSONObject object = dataRequest.getData();
        return this.wxService.acceptMessage(object);
    }

    @ApiOperation(value="\u53d1\u9001\u4f1a\u5458", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"111\",\"nick_name\":\"\u6bdb\u4f1f\u680b\",\"head_img\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_content\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_type\":\"Text\u3001Picture\u3001Sharing\",\"message_date\":\"2017-10-11 12:12:22\",\"vip_id\":\"01001\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatToVip"}, method={RequestMethod.POST})
    public DataResponse pushToVip(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatToVip(dataRequest);
    }

    @ApiOperation(value="\u53d1\u9001\u4f1a\u5458", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"111\",\"nick_name\":\"\u6bdb\u4f1f\u680b\",\"head_img\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_content\":\"\u4e8c\u7ef4\u7801\u7d20\u6750\u5730\u5740\",\"message_type\":\"Text\u3001Picture\u3001Sharing\",\"message_date\":\"2017-10-11 12:12:22\",\"vip_id\":\"01001\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatToVipV2"}, method={RequestMethod.POST})
    public DataResponse chatToVipV2(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatToVipV2(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u5185\u5bb9", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"vip_id\":\"111\",\"user_id\":\"\u6bdb\u4f1f\u680b\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatMessage"}, method={RequestMethod.POST})
    public DataResponse chatMessage(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatMessage(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u5185\u5bb9", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"vip_id\":\"111\",\"user_id\":\"\u6bdb\u4f1f\u680b\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatMessageV2"}, method={RequestMethod.POST})
    public DataResponse chatMessageV2(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatMessageV2(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664\u804a\u5929\u5185\u5bb9", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\n\"message_id\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/removeChatMessage"}, method={RequestMethod.POST})
    public DataResponse removeChatMessage(@RequestBody DataRequest dataRequest) {
        return this.messageService.removeChatMessage(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u5217\u8868", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatList"}, method={RequestMethod.POST})
    public DataResponse chatList(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatList(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u5217\u8868", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatListV2"}, method={RequestMethod.POST})
    public DataResponse chatListV2(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatListV2(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u5386\u53f2\u63a8\u9001\u5546\u54c1", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\",\"vip_id\":\"10\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/chatProductList"}, method={RequestMethod.POST})
    public DataResponse chatProductList(@RequestBody DataRequest dataRequest) {
        return this.messageService.chatProductList(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664\u804a\u5929\u5386\u53f2\u5546\u54c1", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\",\"vip_id\":\"10\",\"product_id\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/removeChatProduct"}, method={RequestMethod.POST})
    public DataResponse removeChatProductList(@RequestBody DataRequest dataRequest) {
        return this.messageService.removeChatProduct(dataRequest);
    }

    @ApiOperation(value="\u804a\u5929\u6d88\u606f\u641c\u7d22", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\",\"vip_id\":\"10\",\"message_content\":\"10\",\"page_size\":\"10\",\"page_num\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public DataResponse searchMessageContent(@RequestBody DataRequest dataRequest) {
        return this.messageService.searchMessageContent(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664\u804a\u5929\u6d88\u606f\u5217\u8868", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"1231312\",\"vip_id\":\"10\",\"wx_id\":\"fasdf10\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/removeChatList"}, method={RequestMethod.POST})
    public DataResponse removeChatList(@RequestBody DataRequest dataRequest) {
        return this.messageService.removeChatListItem(dataRequest);
    }

    @ApiOperation(value="\u5df2\u8bfb\u804a\u5929\u6d88\u606f", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/readAllChatList"}, method={RequestMethod.POST})
    public DataResponse readAllMessage(@RequestBody DataRequest dataRequest) {
        return this.messageService.readAllMessage(dataRequest);
    }

    @ApiOperation(value="\u5df2\u8bfb\u804a\u5929\u6d88\u606f", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/readAllChatListV2"}, method={RequestMethod.POST})
    public DataResponse readAllMessageV2(@RequestBody DataRequest dataRequest) {
        return this.messageService.readAllMessageV2(dataRequest);
    }

    @ApiOperation(value="\u662f\u5426\u5b58\u5728\u5df2\u8bfb\u6d88\u606f", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/isMessageRead"}, method={RequestMethod.POST})
    public DataResponse isMessageRead(@RequestBody DataRequest dataRequest) {
        return this.messageService.isMessageRead(dataRequest);
    }

    @ApiOperation(value="\u662f\u5426\u5b58\u5728\u5df2\u8bfb\u6d88\u606f", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"\u6bdb\u4f1f\u680b\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/isMessageReadV2"}, method={RequestMethod.POST})
    public DataResponse isMessageReadV2(@RequestBody DataRequest dataRequest) {
        return this.messageService.isMessageReadV2(dataRequest);
    }

    @RequestMapping(value={"/remarkName"}, method={RequestMethod.POST})
    public DataResponse remarkName(@RequestBody DataRequest dataRequest) {
        DBCollection collection = this.mongoTemplate.getCollection("def_user");
        DBCollection collection_vip = this.mongoTemplate.getCollection("def_vip");
        DBCursor dbCur = collection.find((DBObject)new BasicDBObject());
        while (dbCur.hasNext()) {
            DBObject object = dbCur.next();
            Map map = object.toMap();
            String uin = (String)map.get("uin");
            String user_id = (String)map.get("user_id");
            log.info(uin + user_id);
            if (org.apache.commons.lang.StringUtils.isBlank((String)uin)) break;
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"user_id", (Object)user_id);
            basicDBObject.put((Object)"u_uin", (Object)uin);
            DBCursor dbCur_ = collection_vip.find((DBObject)basicDBObject);
            log.info((Object)dbCur_.count());
            while (dbCur_.hasNext()) {
                DBObject object_ = dbCur_.next();
                Map map_ = object_.toMap();
                String wx_id = (String)map_.get("wx_id");
                String remark_name = (String)map_.get("remark_name");
                if (null == remark_name) continue;
                this.redisClient.getValueOps().setValueString(user_id + "-" + uin + "-" + wx_id, remark_name);
            }
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u8bbe\u7f6e\u6210\u529f");
    }

    private JSONObject getParam(HttpServletRequest request) {
        String post_str = null;
        ServletInputStream inputStream = null;
        String charset = request.getCharacterEncoding();
        charset = charset == null ? "iso8859-1" : charset;
        try {
            inputStream = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            byte[] buf = new byte[2048];
            bis = new BufferedInputStream((InputStream)inputStream);
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            inputStream.close();
            post_str = baos.toString(charset);
        }
        catch (IOException e) {
            log.error("error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("-1", "\u83b7\u53d6POST\u53c2\u6570\u5931\u8d25");
        }
        log.info("get_param:" + request.getQueryString());
        JSONObject param = new JSONObject();
        JSONObject post_param = null;
        if (StringUtils.isNotNull((Object)post_str)) {
            try {
                post_param = post_str.startsWith("<xml") ? XML.toJSONObject((String)post_str) : JSONObject.parseObject((String)post_str);
            }
            catch (Exception e) {
                log.error("xml to jsonobject error:" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (post_param == null) {
            post_param = new JSONObject();
        }
        param.put("post_param", (Object)post_param);
        JSONObject get_param_info = new JSONObject();
        Map get_param = request.getParameterMap();
        if (get_param != null && !get_param.isEmpty()) {
            Set entrys = get_param.entrySet();
            for (Map.Entry entry : entrys) {
                if (StringUtils.isNull(entry.getValue())) {
                    get_param_info.put((String)entry.getKey(), (Object)"");
                    continue;
                }
                if (((String[])entry.getValue()).length > 0) {
                    get_param_info.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                    continue;
                }
                get_param_info.put((String)entry.getKey(), (Object)"");
            }
        }
        param.put("get_param", (Object)get_param_info);
        return param;
    }
}

