/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.weitaokr.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import kr.weitao.common.util.JSONArraySortUtil;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.weitaokr.service.LogisticsService;
import kr.weitao.weitaokr.service.impl.KdniaoServiceImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7269\u6d41\u7ba1\u7406", description="\u7269\u6d41\u7ba1\u7406", tags={"logistics"})
@RestController
@RefreshScope
@RequestMapping(value={"/logistics"})
public class LogisticsController {
    private static final Logger log = LogManager.getLogger(LogisticsController.class);
    @Autowired
    LogisticsService logisticsService;
    @Autowired
    KdniaoServiceImpl kdniaoService;

    @ApiOperation(value="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"00001\",\"order_id\":\"10\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public DataResponse info(@RequestBody DataRequest dataRequest) {
        log.info((Object)dataRequest);
        return this.logisticsService.query(dataRequest);
    }

    @ApiOperation(value="\u5feb\u9012\u7269\u6d41\u67e5\u8be2\u63a5\u53e3", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"user_id\":\"00001\",\"shipper_code\":\"10\",\"logistic_code\":\"0\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/queryOrderTrace"}, method={RequestMethod.POST})
    public DataResponse queryOrderTrace(@RequestBody DataRequest request) throws Exception {
        log.info((Object)request);
        String shipperCode = request.getData().getString("shipper_code");
        String logisticCode = request.getData().getString("logistic_code");
        JSONArray traces = new JSONArray();
        JSONArray traces_ = new JSONArray();
        try {
            traces = this.kdniaoService.queryOrderTraces(shipperCode, logisticCode);
            if (traces.size() > 0) {
                traces_ = JSONArraySortUtil.sortDesc((JSONArray)traces, (String)"AcceptTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataResponse dataResponse = new DataResponse();
        dataResponse.setStatus(Status.SUCCESS);
        JSONObject respJSON = new JSONObject();
        respJSON.put("traces", (Object)traces_);
        dataResponse.setData(respJSON);
        return dataResponse;
    }

    @ApiOperation(value="\u5feb\u9012\u5355\u7269\u6d41\u8ba2\u9605\u63a5\u53e3")
    @RequestMapping(value={"/subOrderTrace"}, method={RequestMethod.POST})
    public DataResponse subOrderTrace(@RequestBody DataRequest request) {
        log.info((Object)request);
        DataResponse dataResponse = new DataResponse();
        dataResponse.setStatus(Status.SUCCESS);
        String shipperCode = request.getData().getString("shipper_code");
        String logisticCode = request.getData().getString("logistic_code");
        String orderCode = request.getData().getString("order_code");
        try {
            if (this.kdniaoService.subOrderTraces(shipperCode, logisticCode, orderCode)) {
                dataResponse.setStatus(Status.SUCCESS);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return dataResponse;
    }

    @ApiOperation(value="\u7269\u6d41\u57fa\u7840\u4fe1\u606f\u67e5\u8be2", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"page_size\":\"0\",\"page_num\":\"10\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/baseInfo"}, method={RequestMethod.POST})
    public DataResponse queryLogisticInfo(@RequestBody DataRequest request) {
        return this.kdniaoService.query(request);
    }

    @ApiOperation(value="\u7269\u6d41\u57fa\u7840\u4fe1\u606f\u641c\u7d22", notes="\u6d4b\u8bd5\u53c2\u6570<br>{ \n<br>\"access_key\": \"string\", \n<br>\"data\": {\"logistics_name\":\"\u987a\u4e30\"},\n<br>\"id\": \"string\", \n<br>\"method\": \"string\", \n<br>\"sign\": \"string\", \n<br>\"source\": \"WHALE\", \n<br>\"timestamp\": \"string\" \n<br>}")
    @RequestMapping(value={"/baseInfoSearch"}, method={RequestMethod.POST})
    public DataResponse queryLogisticInfoSearch(@RequestBody DataRequest request) {
        return this.kdniaoService.search(request);
    }
}

