/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.utils;

import com.google.common.base.MoreObjects;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeBucket {
    private static final ThreadLocal<DateFormat> FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private final Date start;
    private final Date end;

    public TimeBucket(Date start, Date end) {
        if (start.after(end)) {
            throw new IllegalArgumentException("\u65f6\u95f4\u6bb5\u65e0\u6548(\u5f00\u59cb\u65e5\u671f\u9700\u8981\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f)");
        }
        this.start = start;
        this.end = end;
    }

    public TimeBucket(String start, String end) {
        this(TimeBucket.parse((String)start), TimeBucket.parse((String)end));
    }

    public TimeBucket(long startTime, long endTime) {
        this(new Date(startTime), new Date(endTime));
    }

    public static TimeBucket union(TimeBucket ... buckets) {
        if (buckets == null || buckets.length <= 1) {
            return null;
        }
        for (int i = 0; i < buckets.length - 1; ++i) {
            long start = buckets[i].getStartTime();
            long end = buckets[i].getEndTime();
            for (int j = i + 1; j < buckets.length; ++j) {
                if (buckets[j].getStartTime() > start) {
                    start = buckets[j].getStartTime();
                }
                if (buckets[j].getEndTime() < end) {
                    end = buckets[j].getEndTime();
                }
                if (start >= end) continue;
                return new TimeBucket(start, end);
            }
        }
        return null;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public long getStartTime() {
        return this.start.getTime();
    }

    public long getEndTime() {
        return this.end.getTime();
    }

    private static Date parse(String str) {
        Date data = null;
        try {
            data = ((DateFormat)FORMATS.get()).parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private static String format(Date str) {
        return ((DateFormat)FORMATS.get()).format(str);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", (Object)TimeBucket.format((Date)this.start)).add("end", (Object)TimeBucket.format((Date)this.end)).toString();
    }
}

