/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.utils;

import java.util.Date;
import java.util.Set;
import kr.weitao.activity.config.quartz.AsyncJobFactory;
import kr.weitao.activity.entity.ScheduleJob;
import kr.weitao.activity.utils.TimeUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScheduleUtils {
    private static final Logger log = LoggerFactory.getLogger(ScheduleUtils.class);

    public static TriggerKey getTriggerKey(String jobName, String jobGroup) {
        return TriggerKey.triggerKey((String)jobName, (String)jobGroup);
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            return (CronTrigger)scheduler.getTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            log.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static Date createScheduleJob(Scheduler scheduler, ScheduleJob scheduleJob) {
        Date a = ScheduleUtils.createScheduleJob((Scheduler)scheduler, (String)scheduleJob.getJob_name(), (String)scheduleJob.getJob_group(), (String)scheduleJob.getCron_expression(), (ScheduleJob)scheduleJob, (String)scheduleJob.getFunc());
        return a;
    }

    public static Date createScheduleJob(Scheduler scheduler, String jobName, String jobGroup, String cronExpression, ScheduleJob scheduleJob, String func) {
        JobDetail jobDetail = JobBuilder.newJob(AsyncJobFactory.class).withIdentity(jobName, jobGroup).build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        String jobTrigger = trigger.getKey().getName();
        scheduleJob.setJob_trigger(jobTrigger);
        jobDetail.getJobDataMap().put("func", func);
        try {
            Date a = scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            return a;
        }
        catch (SchedulerException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            try {
                Date a = scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                return a;
            }
            catch (Exception e2) {
                try {
                    Date a = scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                    return a;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public static void runOnce(Scheduler scheduler, String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.triggerJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void pauseJob(Scheduler scheduler, String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static void resumeJob(Scheduler scheduler, String jobName, String jobGroup) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static JobKey getJobKey(String jobName, String jobGroup) {
        return JobKey.jobKey((String)jobName, (String)jobGroup);
    }

    public static void updateScheduleJob(Scheduler scheduler, ScheduleJob scheduleJob) {
        ScheduleUtils.updateScheduleJob((Scheduler)scheduler, (String)scheduleJob.getJob_name(), (String)scheduleJob.getJob_group(), (String)scheduleJob.getCron_expression(), (Object)scheduleJob);
    }

    public static void updateScheduleJob(Scheduler scheduler, String jobName, String jobGroup, String cronExpression, Object param) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey((String)jobName, (String)jobGroup);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
            if (!triggerState.name().equalsIgnoreCase("PAUSED")) {
                scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (SchedulerException e) {
            log.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            String cronExpression1 = TimeUtils.getCron((Date)TimeUtils.getLastMin((Date)new Date(), (int)2));
            CronScheduleBuilder scheduleBuilder1 = CronScheduleBuilder.cronSchedule((String)cronExpression1);
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey((String)jobName, (String)jobGroup);
            CronTrigger trigger1 = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder1).build();
            try {
                scheduler.rescheduleJob(triggerKey, (Trigger)trigger1);
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(ScheduleUtils.getJobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean checckJobExist(Scheduler scheduler, String jobName, String jobGroup) {
        try {
            Set jobKeySet = scheduler.getJobKeys(GroupMatcher.anyGroup());
            for (JobKey jobKey : jobKeySet) {
                if (!jobKey.getName().equals(jobName) || !jobKey.getGroup().equals(jobGroup)) continue;
                return true;
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return false;
    }
}

