/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.Order;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.associate.Associate;
import kr.weitao.business.entity.partner.PartnerGroup;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.util.oss.OssClient;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MongodbUtils {
    private static final Logger log = LoggerFactory.getLogger(MongodbUtils.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    OssClient ossClient;
    @Value(value="${oss.oss_domain}")
    String OSS_DOMAIN;

    public BasicDBObject changeConditionO(JSONArray array) {
        DBCollection collection_v = this.mongoTemplate.getCollection("def_vip");
        DBCollection collection_u = this.mongoTemplate.getCollection("def_user");
        DBCollection collection_t = this.mongoTemplate.getCollection("def_team");
        BasicDBObject queryCondition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        String user_name = "";
        String user_phone = "";
        BasicDBList store_ids = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            String info = array.get(i).toString();
            JSONObject json = JSONObject.parseObject((String)info);
            String screen_key = json.get((Object)"screen_key").toString();
            String screen_value = json.get((Object)"screen_value").toString();
            System.out.println(screen_value + "---\u7b5b\u9009\u6761\u4ef6----" + screen_key);
            if (!(screen_value.equals("") || screen_key.equals("created_date") || screen_key.equals("logistics_time") || screen_key.equals("pay_date") || screen_key.equals("order_time") || screen_key.equals("search_way") || screen_key.equals("is_contains_child"))) {
                BasicDBList dbList;
                DBCursor cursor;
                Pattern pattern;
                if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c") || screen_value.startsWith(" ")) {
                    screen_value = screen_value.substring(1);
                }
                if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c") || screen_value.startsWith(" ")) {
                    screen_value = screen_value.substring(0, screen_value.length() - 1);
                }
                screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|");
                screen_value = MongodbUtils.El2Str1((String)screen_value);
                if (screen_key.equals("vip_name")) {
                    BasicDBList dbList2 = new BasicDBList();
                    dbList2.add((Object)new BasicDBObject("remark_name", (Object)new BasicDBObject("$regex", (Object)screen_value)));
                    BasicDBList dbList1 = new BasicDBList();
                    dbList1.add((Object)new BasicDBObject("nick_name", (Object)new BasicDBObject("$regex", (Object)screen_value)));
                    dbList1.add((Object)new BasicDBObject("remark_name", (Object)""));
                    dbList2.add((Object)new BasicDBObject("$and", (Object)dbList1));
                    DBCursor cursor2 = collection_v.find((DBObject)new BasicDBObject("$or", (Object)dbList2));
                    BasicDBList dbList3 = new BasicDBList();
                    while (cursor2.hasNext()) {
                        dbList3.add((Object)cursor2.next().get("vip_id").toString());
                    }
                    values.add((Object)new BasicDBObject("order_vip.vip_id", (Object)new BasicDBObject("$in", (Object)dbList3)));
                } else if (screen_key.equals("order_product_name")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject("productList.product_name", (Object)new BasicDBObject("$regex", (Object)screen_value)));
                } else if (screen_key.equals("order_sku_code")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject("productList.sku_code", (Object)pattern));
                } else if (screen_key.equals("vip_phone")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    cursor = collection_v.find((DBObject)new BasicDBObject("vip_phone", (Object)pattern));
                    dbList = new BasicDBList();
                    while (cursor.hasNext()) {
                        dbList.add((Object)cursor.next().get("vip_id").toString());
                    }
                    values.add((Object)new BasicDBObject("order_vip.vip_id", (Object)new BasicDBObject("$in", (Object)dbList)));
                } else if (screen_key.equals("receiver_phone")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject("express_info.address.phone", (Object)pattern));
                } else if (screen_key.equals("logistics_code")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject("logisticsList.logistics_code", (Object)pattern));
                } else if (screen_key.equals("logistics_name")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject("logisticsList.logistics_name", (Object)pattern));
                } else if (screen_key.equals("user_name")) {
                    user_name = screen_value;
                } else if (screen_key.equals("user_phone")) {
                    user_phone = screen_value;
                } else if (screen_key.equals("store_id")) {
                    store_ids.add((Object)screen_value);
                } else if (!screen_key.equals("team_id")) {
                    if (screen_key.equals("product_name")) {
                        pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                        values.add((Object)new BasicDBObject("productList.product_name", (Object)new BasicDBObject("$regex", (Object)screen_value)));
                    } else if (screen_key.equals("pay_status") && "2".equals(screen_value)) {
                        values.add((Object)new BasicDBObject("pay_status", (Object)"0"));
                    } else if (!screen_key.equals("commission_status")) {
                        if (screen_key.equals("team_name")) {
                            pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                            cursor = collection_t.find((DBObject)new BasicDBObject("name", (Object)pattern));
                            dbList = new BasicDBList();
                            while (cursor.hasNext()) {
                                dbList.add((Object)cursor.next().get("_id").toString());
                            }
                            values.add((Object)new BasicDBObject("productList.team_id", (Object)new BasicDBObject("$in", (Object)dbList)));
                        } else if (screen_key.equals("receiver_type")) {
                            if ("KD".equals(screen_value)) {
                                values.add((Object)new BasicDBObject("receiver_type", (Object)new BasicDBObject("$ne", (Object)"ZT")));
                            } else {
                                values.add((Object)new BasicDBObject("receiver_type", (Object)screen_value));
                            }
                        } else {
                            pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                            values.add((Object)new BasicDBObject(screen_key, (Object)pattern));
                        }
                    }
                }
            }
            if (!screen_key.equals("created_date") && !screen_key.equals("logistics_time") && !screen_key.equals("pay_date") && !screen_key.equals("order_time")) continue;
            JSONObject date = JSON.parseObject((String)screen_value);
            String start = date.get((Object)"start").toString();
            String end = date.get((Object)"end").toString();
            if (!start.equals("") && start != null) {
                values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
            }
            if (end.equals("") || end == null) continue;
            values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lt", (Object)end)));
        }
        if (!user_name.equals("") || !user_phone.equals("") || store_ids.size() > 0) {
            BasicDBObject dbObject = new BasicDBObject();
            if (!user_name.equals("")) {
                dbObject.put((Object)"user_name", (Object)new BasicDBObject("$regex", (Object)user_name));
            }
            if (!user_phone.equals("")) {
                dbObject.put((Object)"phone", (Object)new BasicDBObject("$regex", (Object)user_phone));
            }
            if (store_ids.size() > 0) {
                dbObject.put((Object)"store_id", (Object)new BasicDBObject("$in", (Object)store_ids));
            }
            DBCursor cursor = collection_u.find((DBObject)dbObject);
            BasicDBList dbList = new BasicDBList();
            while (cursor.hasNext()) {
                dbList.add((Object)cursor.next().get("user_id").toString());
            }
            values.add((Object)new BasicDBObject("user_id", (Object)new BasicDBObject("$in", (Object)dbList)));
        }
        if (values.size() > 0) {
            queryCondition.put((Object)"$and", (Object)values);
        }
        return queryCondition;
    }

    public PartnerGroup getAssociate(String openId) {
        PartnerGroup partnerGroup = null;
        Associate associate = (Associate)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"open_id").is((Object)openId).and("is_active").is((Object)"Y")), Associate.class);
        if (null != associate) {
            String group_id = associate.getGroup_id();
            partnerGroup = (PartnerGroup)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"group_id").is((Object)group_id)), PartnerGroup.class);
        }
        return partnerGroup;
    }

    public PartnerGroup getAssociateIsActive(String openId) {
        PartnerGroup partnerGroup = null;
        Associate associate = (Associate)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"open_id").is((Object)openId)), Associate.class);
        if (null != associate) {
            String group_id = associate.getGroup_id();
            partnerGroup = (PartnerGroup)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"group_id").is((Object)group_id)), PartnerGroup.class);
        }
        return partnerGroup;
    }

    public String getCorpCode(String miniAppId) {
        String corp_code = "";
        Corp corp = (Corp)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"mini_appid").is((Object)miniAppId)), Corp.class);
        if (null != corp) {
            corp_code = corp.getCorp_code();
        }
        return corp_code;
    }

    public BasicDBObject changeConditionTMC(JSONArray array) {
        DBCollection collection_u = this.mongoTemplate.getCollection("def_user");
        DBCollection collection_t = this.mongoTemplate.getCollection("def_team");
        BasicDBObject queryCondition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            String end;
            String start;
            JSONObject date;
            String info = array.get(i).toString();
            JSONObject json = JSONObject.parseObject((String)info);
            String screen_key = json.get((Object)"screen_key").toString();
            String screen_value = json.get((Object)"screen_value").toString();
            if (!(screen_value.equals("") || screen_key.equals("created_date") || screen_key.equals("logistics_time") || screen_key.equals("pay_date") || screen_key.equals("order_time") || screen_key.equals("search_way") || screen_key.equals("is_contains_child") || screen_key.equals("activity_time"))) {
                Pattern pattern;
                BasicDBList dbList;
                DBCursor cursor;
                System.out.println(screen_value + "---\u7b5b\u9009\u6761\u4ef6----" + screen_key);
                if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                    screen_value = screen_value.substring(1);
                }
                if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                    screen_value = screen_value.substring(0, screen_value.length() - 1);
                }
                screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|");
                screen_value = MongodbUtils.El2Str1((String)screen_value);
                if (screen_key.equals("user_name")) {
                    BasicDBObject dbObject = new BasicDBObject();
                    dbObject.put((Object)"user_name", (Object)new BasicDBObject("$regex", (Object)screen_value));
                    cursor = collection_u.find((DBObject)dbObject);
                    dbList = new BasicDBList();
                    while (cursor.hasNext()) {
                        dbList.add((Object)cursor.next().get("user_id").toString());
                    }
                    values.add((Object)new BasicDBObject("user_id", (Object)new BasicDBObject("$in", (Object)dbList)));
                } else if (screen_key.equals("team_id")) {
                    values.add((Object)new BasicDBObject("team_id", (Object)screen_value));
                } else if (screen_key.equals("commission_status")) {
                    values.add((Object)new BasicDBObject("status", (Object)screen_value));
                } else if (screen_key.equals("team_name")) {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    cursor = collection_t.find((DBObject)new BasicDBObject("name", (Object)pattern));
                    dbList = new BasicDBList();
                    while (cursor.hasNext()) {
                        dbList.add((Object)cursor.next().get("_id").toString());
                    }
                    values.add((Object)new BasicDBObject("team_id", (Object)new BasicDBObject("$in", (Object)dbList)));
                } else {
                    pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    values.add((Object)new BasicDBObject(screen_key, (Object)pattern));
                }
            }
            if (screen_key.equals("created_date") || screen_key.equals("logistics_time") || screen_key.equals("pay_date") || screen_key.equals("order_time")) {
                if (screen_key.equals("order_time")) {
                    screen_key = "order_datetime";
                }
                date = JSON.parseObject((String)screen_value);
                start = date.get((Object)"start").toString();
                end = date.get((Object)"end").toString();
                if (!start.equals("") && start != null) {
                    values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
                }
                if (!end.equals("") && end != null) {
                    values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lt", (Object)end)));
                }
            }
            if (!screen_key.equals("activity_time")) continue;
            date = JSON.parseObject((String)screen_value);
            start = date.get((Object)"start").toString();
            end = date.get((Object)"end").toString();
            if (!start.equals("") && start != null) {
                values.add((Object)new BasicDBObject("start_time", (Object)new BasicDBObject("$gte", (Object)start)));
            }
            if (end.equals("") || end == null) continue;
            values.add((Object)new BasicDBObject("end_time", (Object)new BasicDBObject("$lt", (Object)end)));
        }
        if (values.size() > 0) {
            queryCondition.put((Object)"$and", (Object)values);
        }
        return queryCondition;
    }

    public BasicDBObject changeCondition(JSONArray array) {
        BasicDBObject queryCondition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            String end;
            String start;
            JSONObject date;
            Query queryStore;
            List stores;
            String info = array.get(i).toString();
            JSONObject json = JSONObject.parseObject((String)info);
            String screen_key = "";
            String screen_value = "";
            if (json.get((Object)"screen_key") != null) {
                screen_key = json.get((Object)"screen_key").toString();
            }
            if (json.get((Object)"screen_value") != null) {
                screen_value = !json.get((Object)"screen_key").toString().contains("date") && !json.get((Object)"screen_key").toString().contains("time") && !json.get((Object)"screen_key").toString().equals("amt_trade") && !json.get((Object)"screen_key").toString().equals("num_trade") && !"store_status".equals(screen_key) && !"store_name".equals(screen_key) && !"focus_public_account".equals(screen_key) && !"area_id".equals(screen_key) && !"name".equals(screen_key) ? StringUtils.handleStr((String)json.get((Object)"screen_value").toString()) : json.getString("screen_value");
            }
            log.info(screen_key + "--------" + screen_value);
            if (!(screen_value.equals("") || screen_key.endsWith("date") || screen_key.endsWith("time") || screen_key.endsWith("logistics_code") || "on_sale".equals(screen_key) || "is_bing".equals(screen_key) || "amt_trade".equals(screen_key) || "num_trade".equals(screen_key) || "store_status".equals(screen_key) || "store_name".equals(screen_key) || "focus_public_account".equals(screen_key) || "area_id".equals(screen_key) || "name".equals(screen_key))) {
                System.out.println(screen_value + "---\u7b5b\u9009\u6761\u4ef6----" + screen_key);
                if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                    screen_value = screen_value.substring(1);
                }
                if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                    screen_value = screen_value.substring(0, screen_value.length() - 1);
                }
                screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|").replaceAll("\n", "|").replaceAll(" ", "|");
                screen_value = MongodbUtils.El2Str1((String)screen_value);
                Pattern pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                values.add((Object)new BasicDBObject(screen_key, (Object)pattern));
            }
            if ("on_sale".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                values.add((Object)new BasicDBObject(screen_key, (Object)Integer.parseInt(screen_value)));
            }
            if ("name".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                String[] strings = screen_value.split(" ");
                values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$in", (Object)strings)));
            }
            if ("focus_public_account".equals(screen_key)) {
                if ("2".equals(screen_value)) {
                    values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$in", Arrays.asList("2", null, ""))));
                } else if ("1".equals(screen_value)) {
                    values.add((Object)new BasicDBObject(screen_key, (Object)"1"));
                }
            }
            if ("area_id".equals(screen_key) && StringUtils.isNotNull((Object)screen_value) && !ObjectUtils.isEmpty((Object)(stores = this.mongoTemplate.find(queryStore = new Query((CriteriaDefinition)Criteria.where((String)"area_id").is((Object)screen_value).and("is_active").is((Object)"Y")), Store.class)))) {
                ArrayList<String> ids = new ArrayList<String>();
                for (Store s : stores) {
                    ids.add(s.get_id().toString());
                }
                values.add((Object)new BasicDBObject("store_id", (Object)new BasicDBObject("$in", ids)));
            }
            if ("is_bing".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                if ("Y".equals(screen_value)) {
                    values.add((Object)new BasicDBObject("open_id", (Object)new BasicDBObject("$ne", null)));
                } else {
                    values.add((Object)new BasicDBObject("open_id", null));
                }
            }
            if (screen_key.equals("logistics_code") && StringUtils.isNotNull((Object)screen_value)) {
                values.add((Object)new BasicDBObject("logistics_info.logistics_code", (Object)new BasicDBObject("$regex", (Object)screen_value)));
            }
            if (screen_key.endsWith("date") || screen_key.endsWith("time")) {
                log.info(screen_key + "--------" + screen_value);
                if (StringUtils.isNotNull((Object)screen_value)) {
                    log.info(screen_key + "---isnotnull-----" + screen_value);
                    date = JSON.parseObject((String)screen_value);
                    start = date.get((Object)"start").toString();
                    end = date.get((Object)"end").toString();
                    if (!start.equals("") && start != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
                    }
                    if (!end.equals("") && end != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lt", (Object)end)));
                    }
                }
            }
            if ("amt_trade".equals(screen_key) || "num_trade".equals(screen_key)) {
                log.info(screen_key + "--------" + screen_value);
                if (StringUtils.isNotNull((Object)screen_value)) {
                    log.info(screen_key + "---isnotnull-----" + screen_value);
                    date = JSON.parseObject((String)screen_value);
                    start = date.get((Object)"start").toString();
                    end = date.get((Object)"end").toString();
                    if (!start.equals("") && start != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
                    }
                    if (!end.equals("") && end != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lte", (Object)end)));
                    }
                }
            }
            if ("store_status".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                values.add((Object)new BasicDBObject("store_id", (Object)new BasicDBObject("$in", (Object)screen_value.split(","))));
            }
            if (!"store_name".equals(screen_key) || !StringUtils.isNotNull((Object)screen_value)) continue;
            values.add((Object)new BasicDBObject("store_id", (Object)new BasicDBObject("$in", (Object)screen_value.split(","))));
        }
        if (values.size() > 0) {
            queryCondition.put((Object)"$and", (Object)values);
        }
        return queryCondition;
    }

    public BasicDBObject changeConditionV2(JSONArray array) {
        BasicDBObject queryCondition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            String end;
            String start;
            JSONObject date;
            String info = array.get(i).toString();
            JSONObject json = JSONObject.parseObject((String)info);
            String screen_key = "";
            String screen_value = "";
            if (json.get((Object)"screen_key") != null) {
                screen_key = json.get((Object)"screen_key").toString();
            }
            if (json.get((Object)"screen_value") != null) {
                screen_value = !json.get((Object)"screen_key").toString().contains("date") && !json.get((Object)"screen_key").toString().contains("time") && !json.get((Object)"screen_key").toString().equals("amt_trade") && !json.get((Object)"screen_key").toString().equals("num_trade") ? StringUtils.handleStr((String)json.get((Object)"screen_value").toString()) : json.getString("screen_value");
            }
            log.info(screen_key + "--------" + screen_value);
            if (!(screen_value.equals("") || screen_key.endsWith("date") || screen_key.endsWith("time") || screen_key.endsWith("logistics_code") || "on_sale".equals(screen_key) || "is_bing".equals(screen_key) || "amt_trade".equals(screen_key) || "num_trade".equals(screen_key))) {
                System.out.println(screen_value + "---\u7b5b\u9009\u6761\u4ef6----" + screen_key);
                if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                    screen_value = screen_value.substring(1);
                }
                if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                    screen_value = screen_value.substring(0, screen_value.length() - 1);
                }
                screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|").replaceAll("\n", "|").replaceAll(" ", "|");
                screen_value = MongodbUtils.El2Str1((String)screen_value);
                Pattern pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                values.add((Object)new BasicDBObject(screen_key, (Object)pattern));
            }
            if ("on_sale".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                values.add((Object)new BasicDBObject(screen_key, (Object)Integer.parseInt(screen_value)));
            }
            if ("is_bing".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                if ("Y".equals(screen_value)) {
                    values.add((Object)new BasicDBObject("open_id", (Object)new BasicDBObject("$ne", null)));
                } else {
                    values.add((Object)new BasicDBObject("open_id", null));
                }
            }
            if (screen_key.equals("logistics_code") && StringUtils.isNotNull((Object)screen_value)) {
                values.add((Object)new BasicDBObject("logistics_info.logistics_code", (Object)new BasicDBObject("$regex", (Object)screen_value)));
            }
            if (screen_key.endsWith("date") || screen_key.endsWith("time")) {
                log.info(screen_key + "--------" + screen_value);
                if (StringUtils.isNotNull((Object)screen_value)) {
                    log.info(screen_key + "---isnotnull-----" + screen_value);
                    date = JSON.parseObject((String)screen_value);
                    start = date.get((Object)"start").toString();
                    end = date.get((Object)"end").toString();
                    if (!start.equals("") && start != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
                    }
                    if (!end.equals("") && end != null) {
                        values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lt", (Object)end)));
                    }
                }
            }
            if (!"amt_trade".equals(screen_key) && !"num_trade".equals(screen_key)) continue;
            log.info(screen_key + "--------" + screen_value);
            if (!StringUtils.isNotNull((Object)screen_value)) continue;
            log.info(screen_key + "---isnotnull-----" + screen_value);
            date = JSON.parseObject((String)screen_value);
            start = date.get((Object)"start").toString();
            end = date.get((Object)"end").toString();
            if (!start.equals("") && start != null) {
                values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$gte", (Object)start)));
            }
            if (end.equals("") || end == null) continue;
            values.add((Object)new BasicDBObject(screen_key, (Object)new BasicDBObject("$lte", (Object)end)));
        }
        if (values.size() > 0) {
            queryCondition.put((Object)"$and", (Object)values);
        }
        return queryCondition;
    }

    public BasicDBObject changeConditionTargetVip(JSONArray array, String corp_code) {
        String order_no = "";
        String product_id = "";
        String user_name = "";
        JSONArray new_array = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            String screen_key = json.get((Object)"screen_key").toString();
            String screen_value = json.get((Object)"screen_value").toString();
            if (screen_value.equals("")) continue;
            if ("order_no".equals(screen_key)) {
                order_no = screen_value;
                continue;
            }
            if ("product_id".equals(screen_key)) {
                product_id = screen_value;
                continue;
            }
            if ("user_name".equals(screen_key) && StringUtils.isNotNull((Object)screen_value)) {
                user_name = screen_value;
                continue;
            }
            new_array.add((Object)json);
        }
        BasicDBObject queryCondition = this.changeCondition(new_array);
        queryCondition.put((Object)"is_active", (Object)"Y");
        if (StringUtils.isNotNull((Object)order_no) || StringUtils.isNotNull((Object)product_id)) {
            BasicDBObject query_order = new BasicDBObject();
            if (StringUtils.isNotNull((Object)order_no)) {
                query_order.put((Object)"order_no", (Object)order_no);
            }
            if (StringUtils.isNotNull((Object)product_id)) {
                product_id = product_id.replaceAll(",", "|").replaceAll("\uff0c", "|");
                product_id = MongodbUtils.El2Str1((String)product_id);
                Pattern pattern = Pattern.compile("^.*" + product_id + ".*$", 2);
                query_order.put((Object)"productList.product_id", (Object)pattern);
            }
            query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
            DBCursor cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
            BasicDBList dbList = new BasicDBList();
            while (cursor.hasNext()) {
                DBObject object = cursor.next();
                String vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                dbList.add((Object)vip_id);
            }
            queryCondition.put((Object)"vip_id", (Object)new BasicDBObject("$in", (Object)dbList));
        }
        BasicDBList list_u = new BasicDBList();
        BasicDBObject dbObject = new BasicDBObject();
        if (StringUtils.isNotNull((Object)user_name)) {
            dbObject.put((Object)"user_name", (Object)new BasicDBObject("$regex", (Object)user_name));
            DBCursor cursor_u = this.mongoTemplate.getCollection("def_user").find((DBObject)dbObject);
            while (cursor_u.hasNext()) {
                list_u.add((Object)cursor_u.next().get("user_id").toString());
            }
            queryCondition.put((Object)"user_id", (Object)new BasicDBObject("$in", (Object)list_u));
        }
        queryCondition.put((Object)"corp_code", (Object)corp_code);
        return queryCondition;
    }

    public static String El2Str1(String el) {
        String str = "";
        str = el.replace("$", "");
        str = str.replace("*", "\\*");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        str = str.replace("+", "\\+");
        str = str.replace("?", "\\?");
        return str;
    }

    public static ArrayList iteratorToArray(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public String exportFile(JSONArray array, Map<String, String> map, String name) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String key : map.keySet()) {
            sb.append("\"").append(key).append("\"").append(",");
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            sb.append("\n");
            for (String key : map.keySet()) {
                String value;
                String map_value = map.get(key);
                String string = value = object.getString(map_value) != null ? object.getString(map_value) : "";
                if (map_value.equals("trade_type")) {
                    if (value.equals("online")) {
                        value = "\u5728\u7ebf\u4ea4\u6613";
                    } else if (value.equals("offline_1")) {
                        value = "\u73b0\u8d27\u4ea4\u6613\uff08\u90ae\u5bc4\uff09";
                    } else if (value.equals("offline_2")) {
                        value = "\u73b0\u8d27\u4ea4\u6613\uff08\u81ea\u63d0\uff09";
                    } else if (value.equals("bankroll")) {
                        value = "\u62bc\u91d1\u4ee3\u53d1";
                    }
                }
                if (map_value.equals("order_status")) {
                    if (value.equals("0")) {
                        value = "\u672a\u53d1\u8d27";
                    } else if (value.equals("1")) {
                        value = "\u5df2\u53d1\u8d27";
                    } else if (value.equals("2")) {
                        value = "\u5df2\u6536\u8d27";
                    }
                }
                if (map_value.equals("pay_status")) {
                    if (value.equals("0")) {
                        value = "\u672a\u652f\u4ed8";
                    } else if (value.equals("0.5")) {
                        value = "\u5f85\u4ed8\u5c3e\u6b3e";
                    } else if (value.equals("1")) {
                        value = "\u5df2\u652f\u4ed8";
                    } else if (value.equals("2")) {
                        value = "\u652f\u4ed8\u8fc7\u671f";
                    } else if (value.equals("3")) {
                        value = "\u5df2\u9000\u6b3e";
                    }
                }
                if (map_value.equals("is_active")) {
                    value = value.equals("Y") ? "\u5426" : "\u662f";
                }
                if (map_value.equals("transaction_id") || map_value.equals("logistics_code") || map_value.equals("vip_name")) {
                    sb.append("\"").append(value + "\t").append("\"").append(",");
                    continue;
                }
                sb.append("\"").append(value).append("\"").append(",");
            }
        }
        long current_sys = System.currentTimeMillis();
        String file_name = new StringBuffer(name).append("_").append(TimeUtils.getTime((long)current_sys, (SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE_NO)).append("_").append(RandomStringUtils.randomAlphanumeric((int)5).toUpperCase()).append(".csv").toString();
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("gb18030"));
        this.ossClient.passFileStrem(file_name, "exports/" + name + "/", (InputStream)is);
        String url = this.OSS_DOMAIN + "/" + "exports/" + name + "/" + file_name;
        return url;
    }

    public BasicDBObject transCondition(JSONArray array, BasicDBObject fix_query, String collection_name) {
        BasicDBList list_and = new BasicDBList();
        BasicDBList list_or = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject condition = array.getJSONObject(i);
            String is_exclude = condition.getString("is_exclude");
            JSONArray condition_array = condition.getJSONArray("condition");
            BasicDBList values = new BasicDBList();
            for (int j = 0; j < condition_array.size(); ++j) {
                String key = condition_array.getJSONObject(j).getString("screen_key");
                String screen_value = condition_array.getJSONObject(j).getString("screen_value");
                BasicDBObject con = new BasicDBObject();
                if (!(screen_value.equals("") || key.endsWith("date") || key.endsWith("time"))) {
                    String vip_id;
                    DBObject object;
                    BasicDBList dbList;
                    DBCursor cursor;
                    BasicDBObject query_order;
                    if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                        screen_value = screen_value.substring(1);
                    }
                    if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                        screen_value = screen_value.substring(0, screen_value.length() - 1);
                    }
                    screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|").replaceAll("\n", "|").replaceAll(" ", "|");
                    screen_value = MongodbUtils.El2Str1((String)screen_value);
                    Pattern pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    if ("user_name".equals(key)) {
                        BasicDBList list_u = new BasicDBList();
                        BasicDBObject dbObject = new BasicDBObject();
                        dbObject.put((Object)key, (Object)pattern);
                        DBCursor cursor_u = this.mongoTemplate.getCollection("def_user").find((DBObject)dbObject);
                        while (cursor_u.hasNext()) {
                            list_u.add((Object)cursor_u.next().get("user_id").toString());
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("user_id", (Object)new BasicDBObject("$in", (Object)list_u)) : new BasicDBObject("user_id", (Object)new BasicDBObject("$nin", (Object)list_u));
                    } else if ("order_no".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"order_no", (Object)new BasicDBObject("$regex", (Object)screen_value));
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList)) : new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                    } else if ("product_name".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"productList.product_name", (Object)pattern);
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList)) : new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                    } else if ("N".equals(is_exclude)) {
                        con = new BasicDBObject(key, (Object)pattern);
                    } else {
                        BasicDBList dbList2 = new BasicDBList();
                        dbList2.add((Object)new BasicDBObject(key, (Object)pattern));
                        con = new BasicDBObject("$nor", (Object)dbList2);
                    }
                } else if (key.endsWith("date") || key.endsWith("time")) {
                    JSONObject date = JSONObject.parseObject((String)screen_value);
                    String start = date.get((Object)"start").toString();
                    String end = date.get((Object)"end").toString();
                    if (!start.equals("") && start != null) {
                        con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$gte", (Object)start)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$gte", (Object)start)));
                    }
                    if (!end.equals("") && end != null) {
                        con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$lt", (Object)end)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$lt", (Object)end)));
                    }
                }
                if (con.isEmpty()) continue;
                values.add((Object)con);
            }
            if ("N".equals(is_exclude)) {
                values.add((Object)fix_query);
                list_or.add((Object)new BasicDBObject("$and", (Object)values));
                continue;
            }
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)fix_query);
            values.add((Object)new BasicDBObject("$nor", (Object)dbList));
            list_and.add((Object)new BasicDBObject("$or", (Object)values));
        }
        BasicDBObject query = new BasicDBObject();
        if (list_or.size() > 0) {
            query.put((Object)"$or", (Object)list_or);
        }
        if (list_and.size() > 0) {
            query.put((Object)"$and", (Object)list_and);
        }
        return query;
    }

    public BasicDBObject transConditionV3(JSONArray array, BasicDBObject fix_query, String collection_name) {
        BasicDBList list_and = new BasicDBList();
        BasicDBList list_or = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject condition = array.getJSONObject(i);
            String is_exclude = condition.getString("is_exclude");
            JSONArray condition_array = condition.getJSONArray("condition");
            BasicDBList values = new BasicDBList();
            for (int j = 0; j < condition_array.size(); ++j) {
                String key = condition_array.getJSONObject(j).getString("screen_key");
                String screen_value = condition_array.getJSONObject(j).getString("screen_value");
                BasicDBObject con = new BasicDBObject();
                boolean trade = key.endsWith("trade");
                if (!(screen_value.equals("") || key.endsWith("date") || key.endsWith("time") || key.endsWith("trade"))) {
                    String vip_id;
                    DBObject object;
                    BasicDBList dbList;
                    DBCursor cursor;
                    BasicDBObject query_order;
                    if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                        screen_value = screen_value.substring(1);
                    }
                    if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                        screen_value = screen_value.substring(0, screen_value.length() - 1);
                    }
                    screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|").replaceAll("\n", "|").replaceAll(" ", "|");
                    screen_value = MongodbUtils.El2Str1((String)screen_value);
                    Pattern pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    if (("vip_sex".equals(key) || "user_id".equals(key) || "vip_phone".equals(key) || "vip_name".equals(key) || "store_id".equals(key) || "vip_id".equals(key)) && !(con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)pattern) : new BasicDBObject(key, (Object)new BasicDBObject("$ne", (Object)screen_value))).isEmpty()) {
                        values.add((Object)con);
                    }
                    if ("user_name".equals(key)) {
                        BasicDBList list_u = new BasicDBList();
                        BasicDBObject dbObject = new BasicDBObject();
                        dbObject.put((Object)key, (Object)pattern);
                        DBCursor cursor_u = this.mongoTemplate.getCollection("def_user").find((DBObject)dbObject);
                        while (cursor_u.hasNext()) {
                            list_u.add((Object)cursor_u.next().get("user_id").toString());
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("user_id", (Object)new BasicDBObject("$in", (Object)list_u)) : new BasicDBObject("user_id", (Object)new BasicDBObject("$nin", (Object)list_u));
                        if (con.isEmpty()) continue;
                        values.add((Object)con);
                        continue;
                    }
                    if ("order_no".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"order_no", (Object)new BasicDBObject("$regex", (Object)screen_value));
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList)) : new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                        if (con.isEmpty()) continue;
                        values.add((Object)con);
                        continue;
                    }
                    if ("product_name".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"productList.product_name", (Object)pattern);
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        if ("N".equals(is_exclude)) {
                            con = new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList));
                            continue;
                        }
                        con = new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                        continue;
                    }
                    if ("N".equals(is_exclude)) {
                        con = new BasicDBObject(key, (Object)pattern);
                        continue;
                    }
                    BasicDBList dbList2 = new BasicDBList();
                    dbList2.add((Object)new BasicDBObject(key, (Object)pattern));
                    con = new BasicDBObject("$nor", (Object)dbList2);
                    continue;
                }
                if (!key.endsWith("date") && !key.endsWith("time") && !key.endsWith("trade")) continue;
                JSONObject date = JSONObject.parseObject((String)screen_value);
                String start = date.get((Object)"start").toString();
                String end = date.get((Object)"end").toString();
                if (!start.equals("") && start != null && !(con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$gte", (Object)start)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$gte", (Object)start)))).isEmpty()) {
                    values.add((Object)con);
                }
                if (end.equals("") || end == null || (con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$lt", (Object)end)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$lt", (Object)end)))).isEmpty()) continue;
                values.add((Object)con);
            }
            if ("N".equals(is_exclude)) {
                values.add((Object)fix_query);
                list_or.add((Object)new BasicDBObject("$and", (Object)values));
                continue;
            }
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)fix_query);
            values.add((Object)new BasicDBObject("$nor", (Object)dbList));
            list_and.add((Object)new BasicDBObject("$or", (Object)values));
        }
        BasicDBObject query = new BasicDBObject();
        if (list_or.size() > 0) {
            query.put((Object)"$or", (Object)list_or);
        }
        if (list_and.size() > 0) {
            query.put((Object)"$and", (Object)list_and);
        }
        return query;
    }

    public JSONObject queryByPage(int page_size, int page_num, BasicDBObject query, BasicDBObject sort, String collection_name) {
        DBCursor cursor = this.mongoTemplate.getCollection(collection_name).find((DBObject)query).sort((DBObject)sort).skip(page_num * page_size).limit(page_size);
        int count = cursor.count();
        int pages = 0;
        pages = count % page_size == 0 ? count / page_size : count / page_size + 1;
        JSONArray array = new JSONArray();
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            String id = object.get("_id").toString();
            object.removeField("_id");
            object.put("id", (Object)id);
            array.add((Object)object);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("page_num", (Object)(page_num + ""));
        jsonObject.put("page_size", (Object)(page_size + ""));
        jsonObject.put("pages", (Object)(pages + ""));
        jsonObject.put("count", (Object)(count + ""));
        jsonObject.put("list", (Object)array);
        return jsonObject;
    }

    public BasicDBObject transConditionV2(JSONArray array, BasicDBObject fix_query, String collection_name) {
        BasicDBList list_and = new BasicDBList();
        BasicDBList list_or = new BasicDBList();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject condition = array.getJSONObject(i);
            String is_exclude = condition.getString("is_exclude");
            JSONArray condition_array = condition.getJSONArray("condition");
            BasicDBList values = new BasicDBList();
            for (int j = 0; j < condition_array.size(); ++j) {
                String key = condition_array.getJSONObject(j).getString("screen_key");
                String screen_value = condition_array.getJSONObject(j).getString("screen_value");
                screen_value = StringUtils.isNotNull((Object)screen_value) ? screen_value : "";
                BasicDBObject con = new BasicDBObject();
                if (!(screen_value.equals("") || key.endsWith("date") || key.endsWith("time"))) {
                    String vip_id;
                    DBObject object;
                    BasicDBList dbList;
                    DBCursor cursor;
                    BasicDBObject query_order;
                    if (screen_value.startsWith("|") || screen_value.startsWith(",") || screen_value.startsWith("\uff0c")) {
                        screen_value = screen_value.substring(1);
                    }
                    if (screen_value.endsWith("|") || screen_value.endsWith(",") || screen_value.endsWith("\uff0c")) {
                        screen_value = screen_value.substring(0, screen_value.length() - 1);
                    }
                    screen_value = screen_value.replaceAll(",", "|").replaceAll("\uff0c", "|").replaceAll("\n", "|").replaceAll(" ", "|");
                    screen_value = MongodbUtils.El2Str1((String)screen_value);
                    Pattern pattern = Pattern.compile("^.*" + screen_value + ".*$", 2);
                    if ("user_name".equals(key)) {
                        BasicDBList list_u = new BasicDBList();
                        BasicDBObject dbObject = new BasicDBObject();
                        dbObject.put((Object)key, (Object)pattern);
                        DBCursor cursor_u = this.mongoTemplate.getCollection("def_user").find((DBObject)dbObject);
                        while (cursor_u.hasNext()) {
                            list_u.add((Object)cursor_u.next().get("user_id").toString());
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("user_id", (Object)new BasicDBObject("$in", (Object)list_u)) : new BasicDBObject("user_id", (Object)new BasicDBObject("$nin", (Object)list_u));
                    } else if ("order_no".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"order_no", (Object)new BasicDBObject("$regex", (Object)screen_value));
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList)) : new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                    } else if ("product_name".equals(key) && collection_name.equals("def_vip")) {
                        query_order = new BasicDBObject();
                        query_order.put((Object)"productList.product_name", (Object)pattern);
                        query_order.put((Object)"order_vip", (Object)new BasicDBObject("$ne", null));
                        cursor = this.mongoTemplate.getCollection("def_order").find((DBObject)query_order);
                        dbList = new BasicDBList();
                        while (cursor.hasNext()) {
                            object = cursor.next();
                            vip_id = JSONObject.parseObject((String)object.get("order_vip").toString()).getString("vip_id");
                            dbList.add((Object)vip_id);
                        }
                        con = "N".equals(is_exclude) ? new BasicDBObject("vip_id", (Object)new BasicDBObject("$in", (Object)dbList)) : new BasicDBObject("vip_id", (Object)new BasicDBObject("$nin", (Object)dbList));
                    } else if ("store_id".equals(key)) {
                        String[] ids = screen_value.split("\\|");
                        con = "N".equals(is_exclude) ? new BasicDBObject("store_id", (Object)new BasicDBObject("$in", (Object)ids)) : new BasicDBObject("store_id", (Object)new BasicDBObject("$nin", (Object)ids));
                    } else if ("on_sale".equals(key) && collection_name.equals("def_product")) {
                        Integer onSale = Integer.parseInt(screen_value);
                        if ("N".equals(is_exclude)) {
                            con = new BasicDBObject(key, (Object)onSale);
                        } else {
                            BasicDBList dbList2 = new BasicDBList();
                            dbList2.add((Object)new BasicDBObject(key, (Object)onSale));
                            con = new BasicDBObject("$nor", (Object)dbList2);
                        }
                    } else if ("N".equals(is_exclude)) {
                        con = new BasicDBObject(key, (Object)pattern);
                    } else {
                        BasicDBList dbList3 = new BasicDBList();
                        dbList3.add((Object)new BasicDBObject(key, (Object)pattern));
                        con = new BasicDBObject("$nor", (Object)dbList3);
                    }
                } else if (key.endsWith("date") || key.endsWith("time")) {
                    JSONObject date = JSONObject.parseObject((String)screen_value);
                    String start = date.get((Object)"start").toString();
                    String end = date.get((Object)"end").toString();
                    if (StringUtils.isNotNull((Object)start)) {
                        con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$gte", (Object)start)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$gte", (Object)start)));
                    }
                    if (StringUtils.isNotNull((Object)end)) {
                        con = "N".equals(is_exclude) ? new BasicDBObject(key, (Object)new BasicDBObject("$lt", (Object)end)) : new BasicDBObject(key, (Object)new BasicDBObject("$not", (Object)new BasicDBObject("$lt", (Object)end)));
                    }
                }
                if (con.isEmpty()) continue;
                values.add((Object)con);
            }
            if ("N".equals(is_exclude)) {
                values.add((Object)fix_query);
                list_or.add((Object)new BasicDBObject("$and", (Object)values));
                continue;
            }
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)fix_query);
            values.add((Object)new BasicDBObject("$nor", (Object)dbList));
            list_and.add((Object)new BasicDBObject("$or", (Object)values));
        }
        BasicDBObject query = new BasicDBObject();
        if (list_or.size() > 0) {
            query.put((Object)"$or", (Object)list_or);
        }
        if (list_and.size() > 0) {
            query.put((Object)"$and", (Object)list_and);
        }
        return query;
    }

    public String getNewOrderStatus(Order order) {
        String order_status = order.getOrder_status();
        String pay_status = order.getPay_status();
        JSONObject pay_info = order.getPay_info();
        String pay_info_pay_status = (String)pay_info.get("pay_status");
        String status = "0";
        if ("0".equals(order_status) && "2".equals(pay_status)) {
            status = "7";
        }
        if ("1".equals(pay_info_pay_status)) {
            status = "1";
        }
        if ("1".equals(order_status) && "1".equals(pay_info_pay_status)) {
            status = "2";
        }
        if ("3".equals(order_status) && "1".equals(pay_info_pay_status)) {
            status = "3";
        }
        if ("2".equals(order_status) && "1".equals(pay_info_pay_status)) {
            status = "5";
        }
        if ("0".equals(pay_info_pay_status)) {
            status = "0";
        }
        if ("0".equals(order_status) && "4".equals(pay_status)) {
            status = "6";
        }
        if ("3".equals(pay_status)) {
            status = "8";
        }
        return status;
    }
}

