/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kr.weitao.activity.entity.ScheduleJob;
import kr.weitao.activity.service.SeckillActivityService;
import kr.weitao.activity.service.impl.ActivityServiceImpl;
import kr.weitao.activity.utils.ListUtil;
import kr.weitao.activity.utils.ScheduleUtils;
import kr.weitao.activity.utils.StringTool;
import kr.weitao.activity.utils.TimeUtils;
import kr.weitao.business.entity.Order;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.activity.RelSeckillActivity;
import kr.weitao.business.entity.activity.RelSeckillActivityVip;
import kr.weitao.business.entity.activity.SeckillActivity;
import kr.weitao.business.entity.product.ProductStock;
import kr.weitao.business.entity.product.Spec;
import kr.weitao.business.entity.product.SpecItem;
import kr.weitao.common.exception.ServiceException;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.bson.types.ObjectId;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class SeckillActivityServiceImpl
extends ActivityServiceImpl
implements SeckillActivityService {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityServiceImpl.class);
    private static ConcurrentHashMap paramMap = new ConcurrentHashMap(16);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;

    public DataResponse addActivity(DataRequest dataRequest) {
        String endTime;
        JSONObject requestData = dataRequest.getData();
        String status = "0";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String currentDate = simpleDateFormat.format(date);
        String beginTime = requestData.getString("begin_time");
        if (beginTime.compareTo(endTime = requestData.getString("end_time")) >= 0) {
            throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        if (beginTime.compareTo(currentDate) <= 0) {
            beginTime = currentDate;
            status = "1";
        }
        JSONObject productInfo = requestData.getJSONObject("productInfo");
        JSONObject operationObj = new JSONObject();
        operationObj.put("activity_type", (Object)"SA");
        operationObj.put("product_id", (Object)productInfo.getString("product_id"));
        this.operationalActivitiesByAdd(this.mongoTemplate, operationObj);
        String activityId = "SA" + System.currentTimeMillis();
        SeckillActivity seckillActivity = SeckillActivity.builder()._id(activityId).name(requestData.getString("name")).status(status).begin_time(requestData.getString("begin_time")).end_time(requestData.getString("end_time")).lable(requestData.getString("lable")).limitBuy(requestData.getJSONObject("limit_buy")).cancleOrderTime(requestData.getInteger("cancle_order_time").intValue()).remark(requestData.getString("remark")).product_id(productInfo.getString("product_id")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNull((Object)requestData.getString("is_active")) ? "Y" : requestData.getString("is_active")).creater_id(requestData.getString("user_id")).created_date(currentDate).modifier_id(requestData.getString("user_id")).modified_date(currentDate).store_name("\u5c0f\u7a0b\u5e8f").store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).build();
        this.mongoTemplate.save((Object)seckillActivity);
        JSONArray skuArray = productInfo.getJSONArray("skuArray");
        for (int i = 0; i < skuArray.size(); ++i) {
            JSONObject skuObj = skuArray.getJSONObject(i);
            RelSeckillActivity relSeckillActivity = RelSeckillActivity.builder().activity_id(activityId).product_id(productInfo.getString("product_id")).sku_id(skuObj.getString("sku_id")).original_stock(skuObj.getDouble("original_stock")).surplus_stock(skuObj.getDouble("original_stock")).seckill_price(skuObj.getDouble("seckill_price")).modified_date(currentDate).build();
            this.mongoTemplate.save((Object)relSeckillActivity);
        }
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u65b0\u589e\u79d2\u6740\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse modifyActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        DBObject dbObject = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        if (dbObject == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        String status = dbObject.get("status").toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String beginTime = requestData.getString("begin_time");
        String endTime = requestData.getString("end_time");
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        this.judgeActivityStatus(status);
        if (status.equals("0")) {
            if (beginTime.compareTo(endTime) >= 0) {
                throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (beginTime.compareTo(currentDate) <= 0) {
                beginTime = currentDate;
                status = "1";
            }
        } else if (status.equals("2")) {
            beginTime = dbObject.get("begin_time").toString();
            endTime = dbObject.get("end_time").toString();
        }
        JSONObject productInfo = requestData.getJSONObject("productInfo");
        JSONObject operationObj = new JSONObject();
        operationObj.put("activity_type", (Object)"SA");
        operationObj.put("activity_id", (Object)activityId);
        operationObj.put("product_id", (Object)productInfo.getString("product_id"));
        this.operationalActivitiesByModify(this.mongoTemplate, operationObj);
        SeckillActivity seckillActivity = SeckillActivity.builder().name(requestData.getString("name")).status(status).begin_time(requestData.getString("begin_time")).end_time(requestData.getString("end_time")).lable(requestData.getString("lable")).limitBuy(requestData.getJSONObject("limit_buy")).cancleOrderTime(requestData.getInteger("cancle_order_time").intValue()).remark(requestData.getString("remark")).product_id(productInfo.getString("product_id")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNull((Object)requestData.getString("is_active")) ? "Y" : requestData.getString("is_active")).modifier_id(requestData.getString("user_id")).modified_date(currentDate).store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).build();
        DBCollection activityDbCollection = this.mongoTemplate.getCollection("def_seckill_activity");
        DBObject activityUpdateObj = (DBObject)JSON.parse((String)JSONObject.toJSONString((Object)seckillActivity));
        BasicDBObject activityDbObject = new BasicDBObject();
        activityDbObject.put((Object)"$set", (Object)activityUpdateObj);
        activityDbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)activityDbObject, false, false);
        this.mongoTemplate.getCollection("rel_seckill_activity").remove((DBObject)new BasicDBObject("activity_id", (Object)activityId));
        JSONArray skuArray = productInfo.getJSONArray("skuArray");
        for (int i = 0; i < skuArray.size(); ++i) {
            JSONObject skuObj = skuArray.getJSONObject(i);
            RelSeckillActivity relSeckillActivity = RelSeckillActivity.builder().activity_id(activityId).product_id(productInfo.getString("product_id")).sku_id(skuObj.getString("sku_id")).original_stock(skuObj.getDouble("original_stock")).surplus_stock(skuObj.getDouble("original_stock")).seckill_price(skuObj.getDouble("seckill_price")).modified_date(currentDate).build();
            this.mongoTemplate.save((Object)relSeckillActivity);
        }
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u4fee\u6539\u79d2\u6740\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse deleteActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBCollection dbCollection = this.mongoTemplate.getCollection("def_seckill_activity");
        DBObject dbObject = dbCollection.findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            String status = obj.get("status").toString();
            if ("3".equals(status) || "0".equals(status)) {
                BasicDBObject updateActivity = new BasicDBObject();
                updateActivity.put((Object)"$set", (Object)new BasicDBObject("is_active", (Object)"N"));
                dbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)updateActivity, false, false);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u79d2\u6740\u6d3b\u52a8\u6210\u529f!");
            }
            throw new ServiceException("\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664!");
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728!"));
    }

    public DataResponse listActivity(DataRequest dataRequest) {
        return this.baseListActivitys(dataRequest, this.mongoTemplate, "def_seckill_activity", "def_user");
    }

    public DataResponse getActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBObject dbObject = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            DBObject modifyUserInfo;
            DBObject createUserInfo;
            String id = obj.get("_id").toString();
            obj.put("id", (Object)id);
            obj.removeField("_id");
            Map map = obj.toMap();
            if (StringUtils.isNotNull(map.get("creater_id")) && (createUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("creater_id").toString())))) != null) {
                map.put("creater_name", createUserInfo.get("user_name"));
            }
            if (StringUtils.isNotNull(map.get("modifier_id")) && (modifyUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("modifier_id").toString())))) != null) {
                map.put("modifier_name", modifyUserInfo.get("user_name"));
            }
            BasicDBList store_ids = (BasicDBList)obj.get("store_ids");
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"store_id").in((Collection)store_ids));
            List stores = this.mongoTemplate.find(query, Store.class);
            map.put("store_list", stores);
            JSONObject productInfo = new JSONObject();
            DBCursor skuInfoArray = this.mongoTemplate.getCollection("rel_seckill_activity").find((DBObject)new BasicDBObject("activity_id", (Object)id));
            List skuList = this.handleDbCursor(skuInfoArray);
            productInfo.put("product_id", map.get("product_id"));
            productInfo.put("skuArray", (Object)skuList);
            productInfo = this.handleProductInfo(productInfo);
            map.put("productInfo", productInfo);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityInfo", (Object)map);
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01"));
    }

    public DataResponse pauseActivity(DataRequest dataRequest) {
        return this.basePauseActivity(dataRequest, this.mongoTemplate, "def_seckill_activity");
    }

    public DataResponse recoveryActivity(DataRequest dataRequest) {
        return this.baseRecoveryActivity(dataRequest, this.mongoTemplate, "def_seckill_activity");
    }

    public DataResponse endActivity(DataRequest dataRequest) {
        this.baseEndActivity(dataRequest, this.scheduler, this.mongoTemplate, "def_seckill_activity");
        this.unLockParamWithEndActivity(dataRequest.getData().getString("id"));
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u6267\u884c\u6210\u529f!");
    }

    public void updateActivityStatus(JobKey jobKey) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String groupName = jobKey.getGroup();
        String jobName = jobKey.getName();
        DBObject dbObject = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject("_id", (Object)groupName));
        if (dbObject != null) {
            BasicDBObject basicDBObject = new BasicDBObject();
            if (jobName.startsWith("START")) {
                log.info("------------STARTJOB------------");
                if ("0".equals(dbObject.get("status"))) {
                    basicDBObject.put((Object)"$set", (Object)new BasicDBObject("status", (Object)"1").append("modified_date", (Object)currentDate));
                    this.mongoTemplate.getCollection("def_seckill_activity").update((DBObject)new BasicDBObject("_id", (Object)groupName), (DBObject)basicDBObject, false, false);
                }
            } else if (jobName.startsWith("END")) {
                log.info("------------ENDJOB------------");
                basicDBObject.put((Object)"$set", (Object)new BasicDBObject("status", (Object)"3").append("modified_date", (Object)currentDate));
                this.mongoTemplate.getCollection("def_seckill_activity").update((DBObject)new BasicDBObject("_id", (Object)groupName), (DBObject)basicDBObject, false, false);
                this.unLockParamWithEndActivity(groupName);
            }
        }
    }

    public DataResponse listProductFromExecActivity(DataRequest dataRequest) {
        boolean flag;
        JSONObject requestData = dataRequest.getData();
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_seckill_activity").find((DBObject)new BasicDBObject().append("status", (Object)"1").append("is_active", (Object)"Y")).sort((DBObject)new BasicDBObject("begin_time", (Object)1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        JSONArray jsonArray = new JSONArray();
        List mapList = this.handleDbCursor(dbCursor);
        for (int i = 0; i < mapList.size(); ++i) {
            Map map = (Map)mapList.get(i);
            JSONObject productInfo = new JSONObject();
            DBCursor skuInfoArray = this.mongoTemplate.getCollection("rel_seckill_activity").find((DBObject)new BasicDBObject("activity_id", map.get("id")));
            List skuList = this.handleDbCursor(skuInfoArray);
            productInfo.put("product_id", map.get("product_id"));
            productInfo.put("skuArray", (Object)skuList);
            productInfo = this.handleProductInfo(productInfo);
            Double totalOriginalStock = 0.0;
            Double totalSurplusStock = 0.0;
            JSONArray skus = productInfo.getJSONArray("skuArray");
            for (int j = 0; j < skus.size(); ++j) {
                totalOriginalStock = totalOriginalStock + skus.getJSONObject(j).getDouble("original_stock");
                totalSurplusStock = totalSurplusStock + skus.getJSONObject(j).getDouble("surplus_stock");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll((Map)productInfo.getJSONObject("productInfo"));
            jsonObject.put("skuArray", (Object)ListUtil.sortArrayByAsc((JSONArray)productInfo.getJSONArray("skuArray"), (String)"seckill_price"));
            jsonObject.put("activityInfo", (Object)map);
            jsonObject.put("original_total_stock", (Object)totalOriginalStock);
            jsonObject.put("purchased_total_stock", (Object)(totalOriginalStock - totalSurplusStock));
            jsonObject.put("purchased_rate", (Object)new DecimalFormat("#.##%").format((totalOriginalStock - totalSurplusStock) / totalOriginalStock));
            jsonArray.add((Object)jsonObject);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", (Object)jsonArray);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse checkVipByLimitBuy(DataRequest dataRequest) {
        JSONObject jsonObject = dataRequest.getData();
        String vipId = jsonObject.getString("vip_id");
        JSONArray skuArray = jsonObject.getJSONArray("productInfo");
        this.handleProductInfoArray(this.mongoTemplate, skuArray, null, null);
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < skuArray.size(); ++i) {
            boolean flag;
            JSONObject skuInfo = skuArray.getJSONObject(i);
            boolean bl = flag = skuInfo.containsKey((Object)"join_activity_code") && skuInfo.getString("join_activity_code").startsWith("SA");
            if (!flag) continue;
            newArray.add((Object)skuInfo);
        }
        if (newArray.size() > 0) {
            this.judgeExceedPurchaseLimit(newArray, vipId);
            this.judgeAndReduceStock(newArray);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u64cd\u4f5c\u6210\u529f!");
    }

    public DataResponse checkVipByLimitBuyCallBack(DataRequest dataRequest) {
        JSONObject jsonObject = dataRequest.getData();
        String orderId = jsonObject.getString("order_id");
        String vipId = jsonObject.getString("vip_id");
        JSONArray skuArray = jsonObject.getJSONArray("productInfo");
        this.handleProductInfoArray(this.mongoTemplate, skuArray, null, null);
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < skuArray.size(); ++i) {
            boolean flag;
            JSONObject skuInfo = skuArray.getJSONObject(i);
            boolean bl = flag = skuInfo.containsKey((Object)"join_activity_code") && skuInfo.getString("join_activity_code").startsWith("SA");
            if (!flag) continue;
            newArray.add((Object)skuInfo);
        }
        if (newArray.size() > 0) {
            this.insertBuyInfoFromVip(newArray, orderId, vipId);
            this.createScheduleJobByOrder(newArray, vipId, orderId);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u64cd\u4f5c\u6210\u529f!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataResponse handleSeckillStock(DataRequest dataRequest) {
        JSONObject skuInfo;
        int i;
        JSONObject jsonObject = dataRequest.getData();
        String type = jsonObject.getString("type");
        JSONArray skuArray = jsonObject.getJSONArray("productInfo");
        this.handleProductInfoArray(this.mongoTemplate, skuArray, null, null);
        JSONArray newArray = new JSONArray();
        for (i = 0; i < skuArray.size(); ++i) {
            boolean flag;
            skuInfo = skuArray.getJSONObject(i);
            boolean bl = flag = skuInfo.containsKey((Object)"join_activity_code") && skuInfo.getString("join_activity_code").startsWith("SA");
            if (!flag) continue;
            newArray.add((Object)skuInfo);
        }
        for (i = 0; i < newArray.size(); ++i) {
            skuInfo = newArray.getJSONObject(i);
            String productId = skuInfo.getString("product_id");
            String skuId = skuInfo.getString("sku_id");
            Double productNum = skuInfo.getDouble("num");
            String activityId = skuInfo.getString("join_activity_code");
            String lockParam = activityId + skuId;
            this.lockUpParam(lockParam);
            Object v = paramMap.get(lockParam);
            synchronized (v) {
                Double num = null;
                if ("ADD".equals(type)) {
                    num = productNum;
                } else if ("REDUCE".equals(type)) {
                    num = -productNum.doubleValue();
                }
                this.mongoTemplate.getCollection("rel_seckill_activity").update((DBObject)new BasicDBObject("activity_id", (Object)activityId).append("product_id", (Object)productId).append("sku_id", (Object)skuId), (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject("surplus_stock", (Object)num)), false, false);
                continue;
            }
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u64cd\u4f5c\u6210\u529f!");
    }

    public void handleSeckillStockByOrder(String vipId, String orderId, JSONArray jsonArray) {
        DBObject dbObject = this.mongoTemplate.getCollection("def_order").findOne((DBObject)new BasicDBObject("order_id", (Object)orderId));
        Optional.ofNullable(dbObject).map(obj -> {
            boolean flag;
            boolean bl = flag = "0".equals(obj.get("pay_status").toString()) && "Y".equals(obj.get("is_active").toString());
            if (flag) {
                this.mongoTemplate.getCollection("def_order").update((DBObject)new BasicDBObject("order_id", (Object)orderId), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("is_active", (Object)"N").append("pay_status", (Object)"4")), false, false);
                Order order = (Order)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"order_id").is((Object)orderId)), Order.class);
                if (null != order) {
                    this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"order_no").is((Object)order.getOrder_no())), Update.update((String)"is_active", (Object)"N"), ProductStock.class);
                }
                DataRequest request = new DataRequest();
                JSONObject reqObj = new JSONObject();
                reqObj.put("type", (Object)"ADD");
                reqObj.put("productInfo", (Object)jsonArray);
                request.setData(reqObj);
                this.handleSeckillStock(request);
                this.mongoTemplate.getCollection("rel_seckill_activity_vip").remove((DBObject)new BasicDBObject("vip_id", (Object)vipId).append("order_id", (Object)orderId));
            }
            return true;
        }).orElseThrow(() -> new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728"));
    }

    public DataResponse getActivityInfoByProductId(DataRequest dataRequest) {
        DBObject activityObj;
        JSONObject result = new JSONObject();
        JSONObject requestData = dataRequest.getData();
        String productId = requestData.getString("product_id");
        DBObject productObj = this.mongoTemplate.getCollection("def_product").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(productId)));
        result.put("productInfo", (Object)productObj);
        String joinActivityCode = "";
        String joinActivityType = "";
        if (StringUtils.isNotNull((Object)productObj.get("promotion_activity_id"))) {
            String pActId = productObj.get("promotion_activity_id").toString();
            activityObj = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)pActId).append("status", (Object)"1").append("is_active", (Object)"Y"));
            if (activityObj != null) {
                joinActivityCode = pActId;
                joinActivityType = "PA";
            }
        } else {
            activityObj = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject().append("status", (Object)"1").append("is_active", (Object)"Y").append("product_id", (Object)productId));
            if (activityObj != null) {
                joinActivityCode = activityObj.get("_id").toString();
                joinActivityType = "SA";
            }
        }
        if (StringUtils.isNotNull((Object)joinActivityCode)) {
            result.put("join_activity_code", (Object)joinActivityCode);
            result.put("join_activity_type", (Object)joinActivityType);
            result.put("activityInfo", (Object)activityObj);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(result);
    }

    private JSONObject handleProductInfo(JSONObject productInfo) {
        String productId = productInfo.getString("product_id");
        DBObject productObj = this.mongoTemplate.getCollection("def_product").findOne((DBObject)new BasicDBObject("product_id", (Object)productId));
        if (productObj != null) {
            productObj.put("id", (Object)productObj.get("_id").toString());
            productObj.removeField("_id");
            if (StringUtils.isNotNull((Object)productObj.get("first_image_url"))) {
                productObj.put("first_image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(productObj.get("first_image_url").toString()));
            }
            productInfo.put("productInfo", (Object)productObj);
            JSONArray skuArray = this.getSkuListByProductId(this.mongoTemplate, productId);
            productInfo.put("skuInfo", (Object)skuArray);
        }
        JSONArray skuJsonArray = new JSONArray();
        JSONArray skuArray = productInfo.getJSONArray("skuArray");
        for (int i = 0; i < skuArray.size(); ++i) {
            JSONObject skuObj = skuArray.getJSONObject(i);
            DBObject skuDbObj = this.mongoTemplate.getCollection("def_sku").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(skuObj.getString("sku_id"))));
            if (skuDbObj != null) {
                String skuId = skuDbObj.get("_id").toString();
                skuDbObj.put("id", (Object)skuId);
                skuDbObj.removeField("_id");
                JSONArray specArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)skuDbObj.get("spec_array")));
                for (int l = 0; l < specArray.size(); ++l) {
                    JSONObject specOne = specArray.getJSONObject(l);
                    String spec_id = specOne.getString("spec_id");
                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                    if (null != spec) {
                        specOne.put("spec_name", (Object)spec.getName());
                    }
                    String spec_item_id = specOne.getString("spec_item_id");
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                    if (null == specItem) continue;
                    specOne.put("spec_item_name", (Object)specItem.getName());
                }
                skuDbObj.put("spec_array", (Object)specArray);
                skuObj.put("skuInfo", (Object)skuDbObj);
                skuObj.put("lastStock", (Object)Integer.parseInt(this.getSkuLastStock(this.mongoTemplate, skuId, productId)));
            }
            skuJsonArray.add((Object)skuObj);
        }
        productInfo.put("skuArray", (Object)skuJsonArray);
        return productInfo;
    }

    private void judgeExceedPurchaseLimit(JSONArray newArray, String vipId) {
        Map productsGroup = ListUtil.listGroup((JSONArray)newArray, (String)"join_activity_code");
        Set activitySet = productsGroup.keySet();
        for (String activityId : activitySet) {
            DBObject actObj = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
            JSONObject limitBuy = JSONObject.parseObject((String)JSONObject.toJSONString((Object)actObj.get("limitBuy")));
            if (!"Y".equals(limitBuy.getString("is_limit"))) continue;
            Double limitNum = limitBuy.getDouble("num");
            Double buyNum = 0.0;
            List productGroup = (List)productsGroup.get(activityId);
            for (int i = 0; i < productGroup.size(); ++i) {
                JSONObject productObj = (JSONObject)productGroup.get(i);
                String productNum = productObj.getString("num");
                buyNum = buyNum + Double.parseDouble(productNum);
            }
            if (buyNum > limitNum) {
                throw new ServiceException("\u8d85\u8fc7\u8d2d\u4e70\u9650\u5236!");
            }
            BasicDBObject query = new BasicDBObject().append("activity_id", (Object)activityId).append("vip_id", (Object)vipId);
            BasicDBObject match = new BasicDBObject("$match", (Object)query);
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("activity_id", (Object)"$activity_id").append("vip_id", (Object)"$vip_id"));
            basicDBObject.put((Object)"count", (Object)new BasicDBObject("$sum", (Object)"$product_num"));
            BasicDBObject group = new BasicDBObject("$group", (Object)basicDBObject);
            AggregationOutput aggregationOutput = this.mongoTemplate.getCollection("rel_seckill_activity_vip").aggregate((DBObject)match, new DBObject[]{group});
            Iterable iterable = aggregationOutput.results();
            Iterator iterator = iterable.iterator();
            Double alreadyNum = 0.0;
            while (iterator.hasNext()) {
                DBObject dbObject = (DBObject)iterator.next();
                alreadyNum = Double.parseDouble(dbObject.get("count").toString());
            }
            if (!(buyNum + alreadyNum > limitNum)) continue;
            throw new ServiceException("\u8d85\u8fc7\u8d2d\u4e70\u9650\u5236!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void judgeAndReduceStock(JSONArray newArray) {
        Class<SeckillActivityServiceImpl> clazz = SeckillActivityServiceImpl.class;
        synchronized (SeckillActivityServiceImpl.class) {
            for (int i = 0; i < newArray.size(); ++i) {
                JSONObject skuInfo = newArray.getJSONObject(i);
                String productId = skuInfo.getString("product_id");
                String skuId = skuInfo.getString("sku_id");
                Double productNum = skuInfo.getDouble("num");
                String activityId = skuInfo.getString("join_activity_code");
                DBObject skuObj = this.mongoTemplate.getCollection("rel_seckill_activity").findOne((DBObject)new BasicDBObject("activity_id", (Object)activityId).append("product_id", (Object)productId).append("sku_id", (Object)skuId));
                if (!(Double.parseDouble(skuObj.get("surplus_stock").toString()) - productNum < 0.0)) continue;
                throw new ServiceException("\u5e93\u5b58\u4e0d\u8db3!");
            }
            DataRequest request = new DataRequest();
            JSONObject reqObj = new JSONObject();
            reqObj.put("type", (Object)"REDUCE");
            reqObj.put("productInfo", (Object)newArray);
            request.setData(reqObj);
            this.handleSeckillStock(request);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void insertBuyInfoFromVip(JSONArray newArray, String orderId, String vipId) {
        for (int i = 0; i < newArray.size(); ++i) {
            JSONObject skuInfo = newArray.getJSONObject(i);
            String productId = skuInfo.getString("product_id");
            String skuId = skuInfo.getString("sku_id");
            Double productNum = skuInfo.getDouble("num");
            String activityId = skuInfo.getString("join_activity_code");
            DBObject actObj = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
            JSONObject limitBuy = JSONObject.parseObject((String)JSONObject.toJSONString((Object)actObj.get("limitBuy")));
            if (!"Y".equals(limitBuy.getString("is_limit"))) continue;
            RelSeckillActivityVip relSeckillActivityVip = RelSeckillActivityVip.builder().activity_id(activityId).product_id(productId).sku_id(skuId).product_num(productNum).order_id(orderId).vip_id(vipId).build();
            this.mongoTemplate.save((Object)relSeckillActivityVip);
        }
    }

    private void createScheduleJobByOrder(JSONArray newArray, String vipId, String orderId) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DBObject orderObj = this.mongoTemplate.getCollection("def_order").findOne((DBObject)new BasicDBObject("order_id", (Object)orderId));
        Date orderCreateTime = new Date();
        try {
            orderCreateTime = simpleDateFormat.parse(orderObj.get("created_date").toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List seckillCancleoOrderTimeList = ListUtil.sortArrayByAsc((JSONArray)newArray, (String)"seckill_cancle_order_time");
        log.info("{}", (Object)seckillCancleoOrderTimeList);
        Integer seckillCancleoOrderTime = ((JSONObject)seckillCancleoOrderTimeList.get(0)).getInteger("seckill_cancle_order_time");
        Date cancleDate = TimeUtils.getLastMin((Date)orderCreateTime, (int)seckillCancleoOrderTime);
        JSONObject jobObj = new JSONObject();
        jobObj.put("module_code", (Object)"ACTIVITY_SECKILL_STOCK");
        jobObj.put("skuArray", (Object)newArray);
        ScheduleJob scheduleJob = ScheduleJob.builder().job_name(vipId).job_group(orderId).cron_expression(TimeUtils.getCron((Date)cancleDate)).func(jobObj.toJSONString()).build();
        ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJob)scheduleJob);
    }

    private void unLockParamWithEndActivity(String activityId) {
        DBCursor dbCursor = this.mongoTemplate.getCollection("rel_seckill_activity").find((DBObject)new BasicDBObject("activity_id", (Object)activityId));
        while (dbCursor.hasNext()) {
            DBObject dbObject = dbCursor.next();
            paramMap.remove(activityId + dbObject.get("sku_id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockUpParam(String param) {
        Class<ActivityServiceImpl> clazz = ActivityServiceImpl.class;
        synchronized (ActivityServiceImpl.class) {
            if (!paramMap.containsKey(param)) {
                paramMap.put(param, new byte[0]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

