/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kr.weitao.activity.service.PromotionActivityService;
import kr.weitao.activity.service.impl.ActivityServiceImpl;
import kr.weitao.activity.service.impl.PromotionActivityServiceImpl;
import kr.weitao.activity.utils.ListUtil;
import kr.weitao.activity.utils.ScheduleUtils;
import kr.weitao.activity.utils.StringTool;
import kr.weitao.activity.utils.TimeBucket;
import kr.weitao.business.entity.StoreArea;
import kr.weitao.business.entity.activity.PromotionActivity;
import kr.weitao.business.entity.coupon.CouponType;
import kr.weitao.business.entity.data.Product;
import kr.weitao.business.entity.product.Sku;
import kr.weitao.business.entity.product.Spec;
import kr.weitao.business.entity.product.SpecItem;
import kr.weitao.common.exception.ServiceException;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.mongodb.BathUpdateOptions;
import kr.weitao.starter.util.mongodb.UpdateMongoDBUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.bson.types.ObjectId;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class PromotionActivityServiceImpl
extends ActivityServiceImpl
implements PromotionActivityService {
    private static final Logger log = LoggerFactory.getLogger(PromotionActivityServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;

    public DataResponse addActivity(DataRequest dataRequest) {
        String endTime;
        JSONObject requestData = dataRequest.getData();
        String status = "0";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String currentDate = simpleDateFormat.format(date);
        String beginTime = requestData.getString("begin_time");
        if (beginTime.compareTo(endTime = requestData.getString("end_time")) >= 0) {
            throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        if (beginTime.compareTo(currentDate) <= 0) {
            beginTime = currentDate;
            status = "1";
        }
        JSONObject operationObj = new JSONObject();
        JSONObject productCondition = requestData.getJSONObject("product_condition");
        operationObj.put("activity_type", (Object)"PA");
        operationObj.put("product_id", (Object)productCondition.getString("condition"));
        operationObj.put("is_all", (Object)productCondition.getString("is_all"));
        this.operationalActivitiesByAdd(this.mongoTemplate, operationObj);
        String activityId = "PA" + System.currentTimeMillis();
        PromotionActivity promotionActivity = PromotionActivity.builder()._id(activityId).name(requestData.getString("name")).store_name("\u5c0f\u7a0b\u5e8f").status(status).type(requestData.getString("type")).begin_time(beginTime).end_time(endTime).product_condition(requestData.getJSONObject("product_condition")).remark(requestData.getString("remark")).rules(requestData.getJSONArray("rules")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNotNull((Object)requestData.getString("is_active")) ? requestData.getString("is_active") : "Y").creater_id(requestData.getString("user_id")).created_date(currentDate).modifier_id(requestData.getString("user_id")).modified_date(currentDate).build();
        this.mongoTemplate.save((Object)promotionActivity);
        this.updateActivityIdFromProduct(requestData.getString("corp_code"), promotionActivity.getProduct_condition(), activityId);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse addActivityV2(DataRequest dataRequest) {
        String endTime;
        JSONObject requestData = dataRequest.getData();
        String corp_code = requestData.getString("corp_code");
        String status = "0";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String currentDate = simpleDateFormat.format(date);
        String beginTime = requestData.getString("begin_time");
        if (beginTime.compareTo(endTime = requestData.getString("end_time")) >= 0) {
            throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        if (beginTime.compareTo(currentDate) <= 0) {
            beginTime = currentDate;
            status = "1";
        }
        JSONObject operationObj = new JSONObject();
        JSONObject productCondition = requestData.getJSONObject("product_condition");
        operationObj.put("activity_type", (Object)"PA");
        operationObj.put("activity_id", (Object)"23333");
        operationObj.put("product_id", (Object)productCondition.getString("condition"));
        operationObj.put("is_all", (Object)productCondition.getString("is_all"));
        operationObj.put("rules", (Object)requestData.getJSONArray("rules"));
        operationObj.put("store_ids", (Object)requestData.getJSONArray("store_ids"));
        operationObj.put("store_flag", (Object)requestData.getString("store_flag"));
        operationObj.put("beginTime", (Object)beginTime);
        operationObj.put("endTime", (Object)endTime);
        if (StringUtils.isNotNull((Object)corp_code)) {
            operationObj.put("corp_code", (Object)corp_code);
            log.info("\u6ee1\u51cf\u6ee1\u8d60\u65b0\u589e\u65f6\u5224\u65adcorp_code\uff1a" + corp_code);
        }
        this.operationalByModifyActivities(this.mongoTemplate, operationObj);
        String activityId = "PA" + System.currentTimeMillis();
        PromotionActivity promotionActivity = PromotionActivity.builder()._id(activityId).name(requestData.getString("name")).store_name("\u5c0f\u7a0b\u5e8f").status(status).type(requestData.getString("type")).begin_time(beginTime).end_time(endTime).product_condition(requestData.getJSONObject("product_condition")).remark(requestData.getString("remark")).rules(requestData.getJSONArray("rules")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNotNull((Object)requestData.getString("is_active")) ? requestData.getString("is_active") : "Y").creater_id(requestData.getString("user_id")).created_date(currentDate).modifier_id(requestData.getString("user_id")).modified_date(currentDate).store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).build();
        this.mongoTemplate.save((Object)promotionActivity);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse modifyActivityV2(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String corp_code = requestData.getString("corp_code");
        String activityId = requestData.getString("id");
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        if (dbObject == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        String status = dbObject.get("status").toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String beginTime = requestData.getString("begin_time");
        String endTime = requestData.getString("end_time");
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        this.judgeActivityStatus(status);
        if (status.equals("0")) {
            if (beginTime.compareTo(endTime) >= 0) {
                throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (beginTime.compareTo(currentDate) <= 0) {
                beginTime = currentDate;
                status = "1";
            }
        } else if (status.equals("2")) {
            beginTime = dbObject.get("begin_time").toString();
            endTime = dbObject.get("end_time").toString();
        }
        JSONObject operationObj = new JSONObject();
        JSONObject productCondition = requestData.getJSONObject("product_condition");
        operationObj.put("activity_type", (Object)"PA");
        operationObj.put("activity_id", (Object)activityId);
        operationObj.put("product_id", (Object)productCondition.getString("condition"));
        operationObj.put("is_all", (Object)productCondition.getString("is_all"));
        operationObj.put("rules", (Object)requestData.getJSONArray("rules"));
        operationObj.put("store_ids", (Object)requestData.getJSONArray("store_ids"));
        operationObj.put("store_flag", (Object)requestData.getString("store_flag"));
        operationObj.put("beginTime", (Object)beginTime);
        operationObj.put("endTime", (Object)endTime);
        if (StringUtils.isNotNull((Object)corp_code)) {
            operationObj.put("corp_code", (Object)corp_code);
            log.info("\u6ee1\u51cf\u6ee1\u8d60\u65b0\u589e\u65f6\u5224\u65adcorp_code\uff1a" + corp_code);
        }
        this.operationalByModifyActivities(this.mongoTemplate, operationObj);
        log.info("\u4fee\u6539\u5224\u65adEND");
        PromotionActivity promotionActivity = PromotionActivity.builder().name(requestData.getString("name")).status(status).type(requestData.getString("type")).begin_time(beginTime).end_time(endTime).product_condition(requestData.getJSONObject("product_condition")).remark(requestData.getString("remark")).rules(requestData.getJSONArray("rules")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNotNull((Object)requestData.getString("is_active")) ? requestData.getString("is_active") : "Y").modifier_id(requestData.getString("user_id")).store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).build();
        DBCollection activityDbCollection = this.mongoTemplate.getCollection("def_promotion_activity");
        DBObject activityUpdateObj = (DBObject)JSON.parse((String)JSONObject.toJSONString((Object)promotionActivity));
        BasicDBObject activityDbObject = new BasicDBObject();
        activityDbObject.put((Object)"$set", (Object)activityUpdateObj);
        activityDbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)activityDbObject, false, false);
        log.info("\u4fee\u6539over");
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse modifyActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        if (dbObject == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        String status = dbObject.get("status").toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String beginTime = requestData.getString("begin_time");
        String endTime = requestData.getString("end_time");
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        this.judgeActivityStatus(status);
        if (status.equals("0")) {
            if (beginTime.compareTo(endTime) >= 0) {
                throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (beginTime.compareTo(currentDate) <= 0) {
                beginTime = currentDate;
                status = "1";
            }
        } else if (status.equals("2")) {
            beginTime = dbObject.get("begin_time").toString();
            endTime = dbObject.get("end_time").toString();
        }
        JSONObject operationObj = new JSONObject();
        JSONObject productCondition = requestData.getJSONObject("product_condition");
        operationObj.put("activity_type", (Object)"PA");
        operationObj.put("activity_id", (Object)activityId);
        operationObj.put("product_id", (Object)productCondition.getString("condition"));
        operationObj.put("is_all", (Object)productCondition.getString("is_all"));
        this.operationalActivitiesByModify(this.mongoTemplate, operationObj);
        this.removeActivityIdFromProduct(activityId);
        PromotionActivity promotionActivity = PromotionActivity.builder().name(requestData.getString("name")).status(status).type(requestData.getString("type")).begin_time(beginTime).end_time(endTime).product_condition(requestData.getJSONObject("product_condition")).remark(requestData.getString("remark")).rules(requestData.getJSONArray("rules")).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNotNull((Object)requestData.getString("is_active")) ? requestData.getString("is_active") : "Y").modifier_id(requestData.getString("user_id")).build();
        DBCollection activityDbCollection = this.mongoTemplate.getCollection("def_promotion_activity");
        DBObject activityUpdateObj = (DBObject)JSON.parse((String)JSONObject.toJSONString((Object)promotionActivity));
        BasicDBObject activityDbObject = new BasicDBObject();
        activityDbObject.put((Object)"$set", (Object)activityUpdateObj);
        activityDbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)activityDbObject, false, false);
        this.updateActivityIdFromProduct(requestData.getString("corp_code"), promotionActivity.getProduct_condition(), activityId);
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse deleteActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBCollection dbCollection = this.mongoTemplate.getCollection("def_promotion_activity");
        DBObject dbObject = dbCollection.findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            String status = obj.get("status").toString();
            if ("3".equals(status) || "0".equals(status)) {
                BasicDBObject updateActivity = new BasicDBObject();
                updateActivity.put((Object)"$set", (Object)new BasicDBObject("is_active", (Object)"N"));
                dbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)updateActivity, false, false);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
                this.removeActivityIdFromProduct(activityId);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8\u6210\u529f!");
            }
            throw new ServiceException("\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664!");
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728!"));
    }

    public DataResponse listActivity(DataRequest dataRequest) {
        return this.baseListActivitys(dataRequest, this.mongoTemplate, "def_promotion_activity", "def_user");
    }

    public DataResponse getActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            JSONObject pObj;
            DBObject modifyUserInfo;
            DBObject createUserInfo;
            String id = obj.get("_id").toString();
            obj.put("id", (Object)id);
            obj.removeField("_id");
            Map map = obj.toMap();
            JSONArray rules = JSONArray.parseArray((String)map.get("rules").toString());
            JSONArray rulesNew = new JSONArray();
            for (int i = 0; i < rules.size(); ++i) {
                int k;
                JSONArray array;
                JSONObject object;
                int j;
                JSONArray acRuleItemNew;
                JSONArray acRuleItem;
                JSONObject ruleItem = rules.getJSONObject(i);
                if (ruleItem.containsValue((Object)"coupon")) {
                    acRuleItem = ruleItem.getJSONArray("ruleItem");
                    acRuleItemNew = new JSONArray();
                    for (j = 0; j < acRuleItem.size(); ++j) {
                        object = acRuleItem.getJSONObject(j);
                        String couponTypeIds = object.getString("couponTypeIds");
                        array = new JSONArray();
                        String[] couponIds = couponTypeIds.split(",");
                        for (k = 0; k < couponIds.length; ++k) {
                            CouponType couponType = (CouponType)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"coupon_type_id").is((Object)couponIds[k])), CouponType.class);
                            if (null == couponType) continue;
                            JSONObject coupon = JSONObject.parseObject((String)couponType.toString());
                            coupon.put("id", (Object)couponType.getCoupon_type_id());
                            array.add((Object)coupon);
                        }
                        object.put("coupons", (Object)array);
                        acRuleItemNew.add((Object)object);
                    }
                    ruleItem.put("ruleItem", (Object)acRuleItemNew);
                }
                if (ruleItem.containsValue((Object)"gift")) {
                    acRuleItem = ruleItem.getJSONArray("ruleItem");
                    acRuleItemNew = new JSONArray();
                    for (j = 0; j < acRuleItem.size(); ++j) {
                        object = acRuleItem.getJSONObject(j);
                        String skuIds = object.getString("skuIds");
                        array = new JSONArray();
                        if (StringUtils.isNotNull((Object)skuIds)) {
                            String[] productSkuIds = skuIds.split(",");
                            for (k = 0; k < productSkuIds.length; ++k) {
                                Sku sku = (Sku)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(productSkuIds[k]))), Sku.class);
                                if (null == sku) continue;
                                JSONArray specArray = sku.getSpec_array();
                                JSONArray jsonArray = new JSONArray();
                                for (int l = 0; l < specArray.size(); ++l) {
                                    JSONObject specOne = specArray.getJSONObject(l);
                                    String spec_id = specOne.getString("spec_id");
                                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                                    if (null != spec) {
                                        specOne.put("spec_name", (Object)spec.getName());
                                    }
                                    String spec_item_id = specOne.getString("spec_item_id");
                                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                                    if (null != specItem) {
                                        specOne.put("spec_item_name", (Object)specItem.getName());
                                    }
                                    jsonArray.add((Object)specOne);
                                }
                                sku.setSpec_array(jsonArray);
                                JSONObject productInfo = new JSONObject();
                                String product_id = sku.getProduct_id();
                                Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                                productInfo.put("sku_id", (Object)sku.get_id().toString());
                                productInfo.put("last_stock", (Object)this.getSkuLastStock(this.mongoTemplate, sku.get_id().toString(), sku.getProduct_id()));
                                productInfo.put("spec_array", (Object)jsonArray);
                                productInfo.put("sku", (Object)sku);
                                if (null != product) {
                                    JSONObject productOne = JSONObject.parseObject((String)product.toString());
                                    if (productOne.containsKey((Object)"first_image_url")) {
                                        productOne.put("first_image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(productOne.getString("first_image_url")));
                                    }
                                    productInfo.putAll((Map)productOne);
                                }
                                array.add((Object)productInfo);
                            }
                        }
                        object.put("product", (Object)array);
                        acRuleItemNew.add((Object)object);
                    }
                    ruleItem.put("ruleItem", (Object)acRuleItemNew);
                }
                rulesNew.add((Object)ruleItem);
            }
            map.put("rules", rulesNew);
            if (StringUtils.isNotNull(map.get("creater_id")) && (createUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("creater_id").toString())))) != null) {
                map.put("creater_name", createUserInfo.get("user_name"));
            }
            if (StringUtils.isNotNull(map.get("modifier_id")) && (modifyUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("modifier_id").toString())))) != null) {
                map.put("modifier_name", modifyUserInfo.get("user_name"));
            }
            if ("N".equals((pObj = JSONObject.parseObject((String)obj.get("product_condition").toString())).getString("is_all"))) {
                DBCursor dbObjects = this.mongoTemplate.getCollection("def_product").find((DBObject)new BasicDBObject("promotion_activity_id", (Object)activityId));
                map.put("productInfo", this.handleDbCursor(dbObjects));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityInfo", (Object)map);
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01"));
    }

    public DataResponse getActivityV2(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        String corp_code = requestData.getString("corp_code");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            BasicDBList store_ids;
            String store_flag;
            DBObject modifyUserInfo;
            DBObject createUserInfo;
            String id = obj.get("_id").toString();
            obj.put("id", (Object)id);
            obj.removeField("_id");
            Map map = obj.toMap();
            JSONArray rules = JSONArray.parseArray((String)map.get("rules").toString());
            JSONArray rulesNew = new JSONArray();
            for (int i = 0; i < rules.size(); ++i) {
                int k;
                JSONArray array;
                JSONObject object;
                int j;
                JSONArray acRuleItemNew;
                JSONArray acRuleItem;
                JSONObject ruleItem = rules.getJSONObject(i);
                if (ruleItem.containsValue((Object)"coupon")) {
                    acRuleItem = ruleItem.getJSONArray("ruleItem");
                    acRuleItemNew = new JSONArray();
                    for (j = 0; j < acRuleItem.size(); ++j) {
                        object = acRuleItem.getJSONObject(j);
                        String couponTypeIds = object.getString("couponTypeIds");
                        array = new JSONArray();
                        String[] couponIds = couponTypeIds.split(",");
                        for (k = 0; k < couponIds.length; ++k) {
                            CouponType couponType = (CouponType)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"coupon_type_id").is((Object)couponIds[k])), CouponType.class);
                            if (null == couponType) continue;
                            JSONObject coupon = JSONObject.parseObject((String)couponType.toString());
                            coupon.put("id", (Object)couponType.getCoupon_type_id());
                            array.add((Object)coupon);
                        }
                        object.put("coupons", (Object)array);
                        acRuleItemNew.add((Object)object);
                    }
                    ruleItem.put("ruleItem", (Object)acRuleItemNew);
                }
                if (ruleItem.containsValue((Object)"gift")) {
                    acRuleItem = ruleItem.getJSONArray("ruleItem");
                    acRuleItemNew = new JSONArray();
                    for (j = 0; j < acRuleItem.size(); ++j) {
                        object = acRuleItem.getJSONObject(j);
                        String skuIds = object.getString("skuIds");
                        array = new JSONArray();
                        if (StringUtils.isNotNull((Object)skuIds)) {
                            String[] productSkuIds = skuIds.split(",");
                            for (k = 0; k < productSkuIds.length; ++k) {
                                Sku sku = (Sku)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(productSkuIds[k]))), Sku.class);
                                if (null == sku) continue;
                                JSONArray specArray = sku.getSpec_array();
                                JSONArray jsonArray = new JSONArray();
                                for (int l = 0; l < specArray.size(); ++l) {
                                    JSONObject specOne = specArray.getJSONObject(l);
                                    String spec_id = specOne.getString("spec_id");
                                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                                    if (null != spec) {
                                        specOne.put("spec_name", (Object)spec.getName());
                                    }
                                    String spec_item_id = specOne.getString("spec_item_id");
                                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                                    if (null != specItem) {
                                        specOne.put("spec_item_name", (Object)specItem.getName());
                                    }
                                    jsonArray.add((Object)specOne);
                                }
                                sku.setSpec_array(jsonArray);
                                JSONObject productInfo = new JSONObject();
                                String product_id = sku.getProduct_id();
                                Product product = (Product)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id)), Product.class);
                                productInfo.put("sku_id", (Object)sku.get_id().toString());
                                productInfo.put("last_stock", (Object)this.getSkuLastStock(this.mongoTemplate, sku.get_id().toString(), sku.getProduct_id()));
                                productInfo.put("spec_array", (Object)jsonArray);
                                productInfo.put("sku", (Object)sku);
                                if (null != product) {
                                    JSONObject productOne = JSONObject.parseObject((String)product.toString());
                                    if (productOne.containsKey((Object)"first_image_url")) {
                                        productOne.put("first_image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(productOne.getString("first_image_url")));
                                    }
                                    productInfo.putAll((Map)productOne);
                                }
                                array.add((Object)productInfo);
                            }
                        }
                        object.put("product", (Object)array);
                        acRuleItemNew.add((Object)object);
                    }
                    ruleItem.put("ruleItem", (Object)acRuleItemNew);
                }
                rulesNew.add((Object)ruleItem);
            }
            map.put("rules", rulesNew);
            if (StringUtils.isNotNull(map.get("creater_id")) && (createUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("creater_id").toString())))) != null) {
                map.put("creater_name", createUserInfo.get("user_name"));
            }
            if (StringUtils.isNotNull(map.get("modifier_id")) && (modifyUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("modifier_id").toString())))) != null) {
                map.put("modifier_name", modifyUserInfo.get("user_name"));
            }
            JSONObject pObj = JSONObject.parseObject((String)obj.get("product_condition").toString());
            String pro_ids = pObj.getString("condition");
            if ("N".equals(pObj.getString("is_all"))) {
                DBCursor dbObjects = this.mongoTemplate.getCollection("def_product").find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("product_id", (Object)new BasicDBObject("$in", Arrays.asList(pro_ids.split(",")))));
                map.put("productInfo", this.handleDbCursor(dbObjects));
            }
            if (StringUtils.isNotNull((Object)(store_flag = (String)dbObject.get("store_flag"))) && "C10022".equals(corp_code) && "1".equals(store_flag) && (store_ids = (BasicDBList)dbObject.get("store_ids")) != null) {
                String store_ids_str = "";
                for (int i = 0; i < store_ids.size(); ++i) {
                    String store_id_str = (String)store_ids.get(i);
                    store_ids_str = i == 0 ? store_id_str : store_ids_str + "," + store_id_str;
                }
                if (!"".equals(store_ids_str)) {
                    DBCursor dbObjects = this.mongoTemplate.getCollection("def_store").find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(",")))));
                    List storeInfos = this.handleDbCursor(dbObjects);
                    for (int i = 0; i < storeInfos.size(); ++i) {
                        Map store = (Map)storeInfos.get(i);
                        store.put("name", store.get("store_name"));
                        store.put("check", false);
                        String area_id = (String)store.get("area_id");
                        StoreArea storeArea = (StoreArea)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)new Criteria("_id").is((Object)new ObjectId(area_id))), StoreArea.class);
                        if (storeArea == null) continue;
                        store.put("area_name", storeArea.getArea_name());
                    }
                    map.put("storeInfo", storeInfos);
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityInfo", (Object)map);
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01"));
    }

    public DataResponse pauseActivity(DataRequest dataRequest) {
        return this.basePauseActivity(dataRequest, this.mongoTemplate, "def_promotion_activity");
    }

    public DataResponse recoveryActivity(DataRequest dataRequest) {
        return this.baseRecoveryActivity(dataRequest, this.mongoTemplate, "def_promotion_activity");
    }

    public DataResponse endActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        this.baseEndActivity(dataRequest, this.scheduler, this.mongoTemplate, "def_promotion_activity");
        this.removeActivityIdFromProduct(activityId);
        1 removeActivityId = new /* Unavailable Anonymous Inner Class!! */;
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u6267\u884c\u6210\u529f!");
    }

    public void removeActivityIdForStoreProduct(String activityId, String corp_code) {
        DBCollection sp_dbCollection = this.mongoTemplate.getCollection("def_store_product");
        DBCursor temp_other_act_pro = sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("promotion_activity_ids", (Object)new BasicDBObject("$eq", (Object)activityId)));
        if (temp_other_act_pro.size() > 0) {
            List temp_other_act_pro_list = this.handleDbCursor(temp_other_act_pro);
            BasicDBObject temp_basicDBObject = new BasicDBObject();
            for (Map t : temp_other_act_pro_list) {
                ArrayList<String> temp_pro_act_ids = new ArrayList<String>();
                List promotion_activity_ids = (List)t.get("promotion_activity_ids");
                if (ObjectUtils.isNotEmpty((Object)promotion_activity_ids)) {
                    for (String s : promotion_activity_ids) {
                        if (activityId.equals(s)) continue;
                        temp_pro_act_ids.add(s);
                    }
                }
                temp_basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_ids", temp_pro_act_ids));
                sp_dbCollection.update((DBObject)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")).append("corp_code", (Object)corp_code), (DBObject)temp_basicDBObject, false, true);
            }
        }
    }

    public void updateActivityStatus(JobKey jobKey) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String groupName = jobKey.getGroup();
        String jobName = jobKey.getName();
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)groupName));
        if (dbObject != null) {
            BasicDBObject basicDBObject = new BasicDBObject();
            if (jobName.startsWith("START")) {
                log.info("------------STARTJOB------------");
                if ("0".equals(dbObject.get("status"))) {
                    basicDBObject.put((Object)"$set", (Object)new BasicDBObject("status", (Object)"1").append("modified_date", (Object)currentDate));
                    this.mongoTemplate.getCollection("def_promotion_activity").update((DBObject)new BasicDBObject("_id", (Object)groupName), (DBObject)basicDBObject, false, false);
                }
            } else if (jobName.startsWith("END")) {
                log.info("------------ENDJOB------------");
                basicDBObject.put((Object)"$set", (Object)new BasicDBObject("status", (Object)"3").append("modified_date", (Object)currentDate));
                this.mongoTemplate.getCollection("def_promotion_activity").update((DBObject)new BasicDBObject("_id", (Object)groupName), (DBObject)basicDBObject, false, false);
                this.removeActivityIdFromProduct(groupName);
            }
        }
    }

    public DataResponse listProductsByActivityId(DataRequest dataRequest) {
        boolean flag;
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        JSONArray filterArray = requestData.getJSONArray("filter");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DBObject dbObject = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        if (dbObject == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject productCondition = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dbObject.get("product_condition")));
        String isAll = productCondition.getString("is_all");
        String products = productCondition.getString("condition");
        BasicDBObject basicDBObject = new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y"));
        if ("N".equals(isAll)) {
            basicDBObject.put((Object)"product_id", (Object)new BasicDBObject("$in", Arrays.asList(products.split(","))));
        }
        BasicDBList basicDBList = new BasicDBList();
        basicDBList.add((Object)basicDBObject);
        basicDBList.add((Object)new BasicDBObject("corp_code", (Object)requestData.getString("corp_code")));
        basicDBList = this.handleProductFilter(filterArray, basicDBList);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$and", (Object)basicDBList);
        long count = this.mongoTemplate.getCollection("def_product").count((DBObject)query);
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_product").find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        List productList = this.handleDbCursor(dbCursor);
        for (int i = 0; i < productList.size(); ++i) {
            Map map = (Map)productList.get(i);
            JSONArray jsonArray = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(map.get("category_id")));
            map.put("categoryName", this.queryCategoryNameS(this.mongoTemplate, jsonArray));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", (Object)productList);
        jsonObject.put("count", (Object)count);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse listProductsV3(DataRequest dataRequest) {
        boolean flag;
        JSONObject requestData = dataRequest.getData();
        log.info("\u6392\u9664\u62fc\u56e2listProductsV3\u5165\u53c2:{}", (Object)requestData);
        String activityId = requestData.getString("activity_id");
        String corp_code = requestData.getString("corp_code");
        String isActivity = requestData.getString("is_activity");
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        JSONArray store_ids = requestData.getJSONArray("store_ids");
        String store_flag = "N";
        String beginTime = requestData.getString("beginTime");
        String endTime = requestData.getString("endTime");
        String store_ids_str = "";
        if (ObjectUtils.isNotEmpty((Object)store_ids)) {
            for (int i = 0; i < store_ids.size(); ++i) {
                String store_id_str = (String)store_ids.get(i);
                store_ids_str = i == 0 ? store_id_str : store_ids_str + "," + store_id_str;
            }
        }
        if ("".equals(store_ids_str) || "C10021".equals(corp_code)) {
            store_flag = "Y";
        }
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray filterArray = requestData.getJSONArray("filter");
        BasicDBList dbObjects = new BasicDBList();
        dbObjects.add((Object)new BasicDBObject("corp_code", (Object)requestData.getString("corp_code")));
        dbObjects = this.handleProductFilter(filterArray, dbObjects);
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basicDBObject = new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y"));
        basicDBList.add((Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$or", (Object)basicDBList);
        if (dbObjects.size() > 0) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put((Object)"$and", (Object)dbObjects);
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)dbObject);
            dbList.add((Object)query);
            query = new BasicDBObject("$and", (Object)dbList);
        }
        query.append("corp_code", (Object)corp_code);
        log.info("--\u67e5\u8be2\u5546\u54c1---" + query);
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_product").find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        List mapList = this.handleDbCursor(dbCursor);
        ArrayList<Map> productList = new ArrayList<Map>();
        ArrayList<Map> tempProductList = new ArrayList<Map>();
        log.info("\u67e5\u8be2\u5faa\u73af\u6240\u6709\u5546\u54c1\u6570\u636emapList" + new Date());
        for (int i = 0; i < mapList.size(); ++i) {
            List mapStoreProList;
            String is_check = "Y";
            String why_no_check = "";
            Map product = (Map)mapList.get(i);
            JSONArray categoryIds = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(product.get("category_id")));
            product.put("categoryName", this.queryCategoryNameS(this.mongoTemplate, categoryIds));
            String product_id = product.get("id").toString();
            List skuList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y")), Sku.class);
            JSONArray array = new JSONArray();
            skuList.forEach(sku -> {
                JSONArray spec_array = sku.getSpec_array();
                JSONArray jsonArray = new JSONArray();
                for (int l = 0; l < spec_array.size(); ++l) {
                    JSONObject specOne = spec_array.getJSONObject(l);
                    String spec_id = specOne.getString("spec_id");
                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                    if (null != spec) {
                        specOne.put("spec_name", (Object)spec.getName());
                    }
                    String spec_item_id = specOne.getString("spec_item_id");
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                    if (null != specItem) {
                        specOne.put("spec_item_name", (Object)specItem.getName());
                    }
                    jsonArray.add((Object)specOne);
                }
                sku.setSpec_array(jsonArray);
                JSONObject object = JSONObject.parseObject((String)sku.toString());
                object.put("id", (Object)object.getString("_id"));
                object.remove((Object)"_id");
                array.add((Object)object);
            });
            product.put("sku_list", array);
            DBCursor db_cursor = null;
            if ("C10022".equals(corp_code)) {
                db_cursor = "Y".equals(store_flag) ? this.mongoTemplate.getCollection("def_store_product").find((DBObject)new BasicDBObject("product_id", (Object)product_id).append("corp_code", (Object)corp_code).append("status", (Object)1)) : this.mongoTemplate.getCollection("def_store_product").find((DBObject)new BasicDBObject("product_id", (Object)product_id).append("status", (Object)1).append("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(",")))));
            }
            if ((mapStoreProList = this.handleDbCursor(db_cursor)).size() > 0 || "C10021".equals(corp_code)) {
                JSONObject operationObj;
                JSONObject temp_activity_info;
                if ("C10021".equals(corp_code)) {
                    log.info("\u5224\u65adYCJ\u6ee1\u51cf\u6d3b\u52a8\u5546\u54c1");
                    temp_activity_info = new JSONObject();
                    operationObj = new JSONObject();
                    operationObj.put("activity_type", (Object)"PA");
                    operationObj.put("activity_id", (Object)(activityId == null ? "23333" : activityId));
                    operationObj.put("product_id", (Object)product_id);
                    operationObj.put("is_all", (Object)"N");
                    operationObj.put("rules", null);
                    operationObj.put("store_ids", (Object)store_ids);
                    operationObj.put("store_flag", (Object)store_flag);
                    operationObj.put("beginTime", (Object)beginTime);
                    operationObj.put("endTime", (Object)endTime);
                    operationObj.put("product_no", product.get("product_no"));
                    if (StringUtils.isNotNull((Object)corp_code)) {
                        operationObj.put("corp_code", (Object)corp_code);
                        log.info("\u6ee1\u51cf\u6ee1\u8d60\u65b0\u589e\u65f6\u5224\u65adcorp_code\uff1a" + corp_code);
                    }
                    try {
                        this.operationalByModifyActivities(this.mongoTemplate, operationObj);
                    }
                    catch (ServiceException e) {
                        temp_activity_info.put("msg", (Object)"\u8be5\u65f6\u95f4\u6bb5\u5546\u54c1\u53c2\u52a0\u5176\u4ed6\u6d3b\u52a8\uff01");
                        is_check = "N";
                        why_no_check = temp_activity_info.getString("msg");
                    }
                }
                temp_activity_info = new JSONObject();
                operationObj = new JSONObject();
                operationObj.put("activity_type", (Object)"PA");
                operationObj.put("activity_id", (Object)(activityId == null ? "23333" : activityId));
                operationObj.put("product_id", (Object)product_id);
                operationObj.put("is_all", (Object)"N");
                operationObj.put("rules", null);
                operationObj.put("store_ids", (Object)store_ids);
                operationObj.put("store_flag", (Object)store_flag);
                operationObj.put("beginTime", (Object)beginTime);
                operationObj.put("endTime", (Object)endTime);
                operationObj.put("product_no", product.get("product_no"));
                if (StringUtils.isNotNull((Object)corp_code)) {
                    operationObj.put("corp_code", (Object)corp_code);
                    log.info("\u6ee1\u51cf\u6ee1\u8d60\u65b0\u589e\u65f6\u5224\u65adcorp_code\uff1a" + corp_code);
                }
                try {
                    this.operationalByModifyActivities(this.mongoTemplate, operationObj);
                }
                catch (ServiceException e) {
                    temp_activity_info.put("msg", (Object)e.getMsg());
                    is_check = "N";
                    why_no_check = temp_activity_info.getString("msg");
                }
            } else {
                is_check = "N";
                why_no_check = "\u8be5\u5546\u54c1\u672a\u5b58\u5728\u6307\u5b9a\u95e8\u5e97";
            }
            product.put("is_check", is_check);
            product.put("why_no_check", why_no_check);
            tempProductList.add(product);
            productList.add(product);
        }
        log.info("listV2End = " + new Date());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", productList);
        jsonObject.put("count", (Object)dbCursor.count());
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse listProductsV2(DataRequest dataRequest) {
        boolean flag;
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("activity_id");
        String corp_code = requestData.getString("corp_code");
        String isActivity = requestData.getString("is_activity");
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        JSONArray store_ids = requestData.getJSONArray("store_ids");
        String store_flag = "N";
        String beginTime = requestData.getString("beginTime");
        String endTime = requestData.getString("endTime");
        String store_ids_str = "";
        String if_add_pro = "N";
        if (ObjectUtils.isNotEmpty((Object)store_ids)) {
            for (int i = 0; i < store_ids.size(); ++i) {
                String store_id_str = (String)store_ids.get(i);
                store_ids_str = i == 0 ? store_id_str : store_ids_str + "," + store_id_str;
            }
        }
        if ("".equals(store_ids_str)) {
            store_flag = "Y";
        }
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray filterArray = requestData.getJSONArray("filter");
        BasicDBList dbObjects = new BasicDBList();
        dbObjects.add((Object)new BasicDBObject("corp_code", (Object)requestData.getString("corp_code")));
        dbObjects = this.handleProductFilter(filterArray, dbObjects);
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basicDBObject = new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y"));
        basicDBList.add((Object)basicDBObject);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$or", (Object)basicDBList);
        if (dbObjects.size() > 0) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put((Object)"$and", (Object)dbObjects);
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)dbObject);
            dbList.add((Object)query);
            query = new BasicDBObject("$and", (Object)dbList);
        }
        query.append("corp_code", (Object)corp_code);
        log.info("--\u67e5\u8be2\u5546\u54c1---" + query);
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_product").find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        List mapList = this.handleDbCursor(dbCursor);
        ArrayList<Map> productList = new ArrayList<Map>();
        ArrayList<Map> tempProductList = new ArrayList<Map>();
        log.info("\u67e5\u8be2\u5faa\u73af\u6240\u6709\u5546\u54c1\u6570\u636emapList" + new Date());
        for (int i = 0; i < mapList.size(); ++i) {
            if_add_pro = "N";
            String is_check = "Y";
            String why_no_check = "";
            Map product = (Map)mapList.get(i);
            JSONArray categoryIds = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(product.get("category_id")));
            product.put("categoryName", this.queryCategoryNameS(this.mongoTemplate, categoryIds));
            String product_id = product.get("id").toString();
            List skuList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y")), Sku.class);
            JSONArray array = new JSONArray();
            skuList.forEach(sku -> {
                JSONArray spec_array = sku.getSpec_array();
                JSONArray jsonArray = new JSONArray();
                for (int l = 0; l < spec_array.size(); ++l) {
                    JSONObject specOne = spec_array.getJSONObject(l);
                    String spec_id = specOne.getString("spec_id");
                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                    if (null != spec) {
                        specOne.put("spec_name", (Object)spec.getName());
                    }
                    String spec_item_id = specOne.getString("spec_item_id");
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                    if (null != specItem) {
                        specOne.put("spec_item_name", (Object)specItem.getName());
                    }
                    jsonArray.add((Object)specOne);
                }
                sku.setSpec_array(jsonArray);
                JSONObject object = JSONObject.parseObject((String)sku.toString());
                object.put("id", (Object)object.getString("_id"));
                object.remove((Object)"_id");
                array.add((Object)object);
            });
            product.put("sku_list", array);
            DBCursor db_cursor = null;
            db_cursor = "Y".equals(store_flag) ? this.mongoTemplate.getCollection("def_store_product").find((DBObject)new BasicDBObject("product_id", (Object)product_id).append("corp_code", (Object)corp_code)) : this.mongoTemplate.getCollection("def_store_product").find((DBObject)new BasicDBObject("product_id", (Object)product_id).append("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(",")))));
            JSONArray product_store_info = new JSONArray();
            List mapStoreProList = this.handleDbCursor(db_cursor);
            if (mapStoreProList.size() > 0) {
                for (int j = 0; j < mapStoreProList.size(); ++j) {
                    JSONArray product_activity_info = new JSONArray();
                    JSONObject product_info = new JSONObject();
                    Map db_object = (Map)mapStoreProList.get(j);
                    List store_pro_act_ids = (List)db_object.get("promotion_activity_ids");
                    if (ObjectUtils.isNotEmpty((Object)store_pro_act_ids)) {
                        DBObject find_activityObj = null;
                        JSONObject temp_activity_info = null;
                        for (int k = 0; k < store_pro_act_ids.size(); ++k) {
                            String act_end_time;
                            String s = (String)store_pro_act_ids.get(k);
                            temp_activity_info = new JSONObject();
                            String activity_find_status = "0,1,2";
                            find_activityObj = this.mongoTemplate.getCollection("def_promotion_activity").findOne((DBObject)new BasicDBObject("_id", (Object)s).append("status", (Object)new BasicDBObject("$in", Arrays.asList(activity_find_status.split(",")))));
                            if (find_activityObj == null) continue;
                            String act_begin_time = (String)find_activityObj.get("begin_time");
                            TimeBucket[] buckets = new TimeBucket[]{new TimeBucket(beginTime, endTime), new TimeBucket(act_begin_time, act_end_time = (String)find_activityObj.get("end_time"))};
                            TimeBucket union = TimeBucket.union((TimeBucket[])buckets);
                            if (null != union && ObjectUtils.isNotEmpty((Object)find_activityObj)) {
                                BasicDBList rules = (BasicDBList)find_activityObj.get("rules");
                                if (ObjectUtil.isNotEmpty((Object)rules)) {
                                    BasicDBObject if_postage = (BasicDBObject)rules.get(0);
                                    if (!"postage".equals(if_postage.getString("rule_name"))) {
                                        temp_activity_info.put("msg", (Object)("\u8be5\u65f6\u95f4\u6bb5" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(union.getStart()) + "-" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(union.getEndTime()) + "\u5546\u54c1\u53c2\u52a0\u5176\u4ed6\u6d3b\u52a8\uff01"));
                                        is_check = "N";
                                        why_no_check = temp_activity_info.getString("msg");
                                    }
                                } else {
                                    throw new ServiceException("\u672a\u83b7\u53d6\u5230\u6d3b\u52a8\u89c4\u5219\u4fe1\u606f");
                                }
                            }
                            temp_activity_info.put("name", find_activityObj.get("name"));
                            temp_activity_info.put("status", find_activityObj.get("status"));
                            temp_activity_info.put("type", find_activityObj.get("type"));
                            temp_activity_info.put("remark", find_activityObj.get("remark"));
                            temp_activity_info.put("product_condition", find_activityObj.get("product_condition"));
                            temp_activity_info.put("store_ids", find_activityObj.get("store_ids"));
                            temp_activity_info.put("rules", find_activityObj.get("rules"));
                            temp_activity_info.put("begin_time", find_activityObj.get("begin_time"));
                            temp_activity_info.put("end_time", find_activityObj.get("end_time"));
                            product_activity_info.add((Object)temp_activity_info);
                        }
                    }
                    product_info.put("store_product_id", db_object.get("store_product_id"));
                    product_info.put("store_id", db_object.get("store_id"));
                    product_info.put("status", db_object.get("status"));
                    product_info.put("is_active", db_object.get("is_active"));
                    product_info.put("category_ids", db_object.get("category_ids"));
                    product_info.put("promotion_activity_ids", db_object.get("promotion_activity_ids"));
                    product_info.put("product_activity_info", (Object)product_activity_info);
                    product_store_info.add((Object)product_info);
                }
            } else if ("N".equals(store_flag)) {
                is_check = "N";
                why_no_check = "\u8be5\u5546\u54c1\u672a\u5b58\u5728\u6307\u5b9a\u95e8\u5e97";
            }
            product.put("product_store_info", product_store_info);
            product.put("is_check", is_check);
            product.put("why_no_check", why_no_check);
            tempProductList.add(product);
            productList.add(product);
        }
        log.info("listV2End = " + new Date());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", productList);
        jsonObject.put("count", (Object)dbCursor.count());
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse listProducts(DataRequest dataRequest) {
        boolean flag;
        String joinActivity = "Y";
        String inactivity = "N";
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("activity_id");
        String corp_code = requestData.getString("corp_code");
        String isActivity = requestData.getString("is_activity");
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray filterArray = requestData.getJSONArray("filter");
        BasicDBList dbObjects = new BasicDBList();
        dbObjects.add((Object)new BasicDBObject("corp_code", (Object)requestData.getString("corp_code")));
        dbObjects = this.handleProductFilter(filterArray, dbObjects);
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basicDBObject = new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y"));
        if (inactivity.equals(isActivity)) {
            basicDBObject.put((Object)"promotion_activity_id", null);
        } else if (joinActivity.equals(isActivity)) {
            basicDBObject.put((Object)"promotion_activity_id", (Object)new BasicDBObject("$ne", null));
        }
        basicDBList.add((Object)basicDBObject);
        if (StringUtils.isNotNull((Object)activityId)) {
            basicDBList.add((Object)new BasicDBObject("promotion_activity_id", (Object)new BasicDBObject("$in", Arrays.asList(activityId.split(",")))));
        }
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$or", (Object)basicDBList);
        if (dbObjects.size() > 0) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put((Object)"$and", (Object)dbObjects);
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)dbObject);
            dbList.add((Object)query);
            query = new BasicDBObject("$and", (Object)dbList);
        }
        query.append("corp_code", (Object)corp_code);
        log.info("--\u67e5\u8be2\u5546\u54c1---" + query);
        long count = this.mongoTemplate.getCollection("def_product").count((DBObject)query);
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_product").find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        List mapList = this.handleDbCursor(dbCursor);
        ArrayList<Map> productList = new ArrayList<Map>();
        for (int i = 0; i < mapList.size(); ++i) {
            Map product = (Map)mapList.get(i);
            JSONArray categoryIds = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(product.get("category_id")));
            product.put("categoryName", this.queryCategoryNameS(this.mongoTemplate, categoryIds));
            if ("N".equals(isActivity)) {
                product.put("is_check", "Y");
            }
            String product_id = product.get("id").toString();
            List skuList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y")), Sku.class);
            JSONArray array = new JSONArray();
            skuList.forEach(sku -> {
                JSONArray spec_array = sku.getSpec_array();
                JSONArray jsonArray = new JSONArray();
                for (int l = 0; l < spec_array.size(); ++l) {
                    JSONObject specOne = spec_array.getJSONObject(l);
                    String spec_id = specOne.getString("spec_id");
                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                    if (null != spec) {
                        specOne.put("spec_name", (Object)spec.getName());
                    }
                    String spec_item_id = specOne.getString("spec_item_id");
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                    if (null != specItem) {
                        specOne.put("spec_item_name", (Object)specItem.getName());
                    }
                    jsonArray.add((Object)specOne);
                }
                sku.setSpec_array(jsonArray);
                JSONObject object = JSONObject.parseObject((String)sku.toString());
                object.put("id", (Object)object.getString("_id"));
                object.remove((Object)"_id");
                array.add((Object)object);
            });
            product.put("sku_list", array);
            productList.add(product);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", productList);
        jsonObject.put("count", (Object)count);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse listProductsLinkActivity(DataRequest dataRequest) {
        boolean flag;
        JSONObject requestData = dataRequest.getData();
        Integer pageNum = requestData.getInteger("page_num");
        Integer pageSize = requestData.getInteger("page_size");
        boolean bl = flag = pageNum == null || pageSize == null;
        if (flag) {
            throw new ServiceException("\u8d77\u59cb\u9875\u6216\u6bcf\u9875\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray filterArray = requestData.getJSONArray("filter");
        BasicDBList dbObjects = new BasicDBList();
        dbObjects.add((Object)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")));
        dbObjects.add((Object)new BasicDBObject("corp_code", (Object)requestData.getString("corp_code")));
        dbObjects = this.handleProductFilter(filterArray, dbObjects);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"$and", (Object)dbObjects);
        long count = this.mongoTemplate.getCollection("def_product").count((DBObject)query);
        DBCursor dbCursor = this.mongoTemplate.getCollection("def_product").find((DBObject)query).sort((DBObject)new BasicDBObject("created_date", (Object)-1)).skip(StringTool.calculatePage((Integer)pageNum, (Integer)pageSize).intValue()).limit(pageSize.intValue());
        List mapList = this.handleDbCursor(dbCursor);
        for (int i = 0; i < mapList.size(); ++i) {
            Map product = (Map)mapList.get(i);
            if (product.containsKey("first_image_url")) {
                product.put("first_image_url", this.aliCDNUrlAuth.getAuthURLA(product.get("first_image_url").toString()));
            }
            JSONArray categoryIds = com.alibaba.fastjson.JSON.parseArray((String)com.alibaba.fastjson.JSON.toJSONString(product.get("category_id")));
            product.put("categoryName", this.queryCategoryNameS(this.mongoTemplate, categoryIds));
            JSONArray skuArray = this.getSkuListByProductId(this.mongoTemplate, product.get("product_id").toString());
            product.put("skuInfo", skuArray);
            String joinActivityCode = "";
            String joinActivityType = "";
            if (StringUtils.isNotNull(product.get("promotion_activity_id"))) {
                joinActivityCode = product.get("promotion_activity_id").toString();
                joinActivityType = "PA";
            } else {
                DBObject seckillActivityDbObj = this.mongoTemplate.getCollection("def_seckill_activity").findOne((DBObject)new BasicDBObject().append("status", (Object)new BasicDBObject("$ne", (Object)"3")).append("is_active", (Object)"Y").append("product_id", (Object)product.get("product_id").toString()));
                if (seckillActivityDbObj != null) {
                    joinActivityCode = seckillActivityDbObj.get("_id").toString();
                    joinActivityType = "SA";
                }
            }
            if (!StringUtils.isNotNull((Object)joinActivityCode)) continue;
            product.put("join_activity_code", joinActivityCode);
            product.put("join_activity_type", joinActivityType);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("productInfo", (Object)mapList);
        jsonObject.put("count", (Object)count);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
    }

    public DataResponse calculateProducts(DataRequest dataRequest) {
        return this.calculateProducts(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    public DataResponse calculateProductsV2(DataRequest dataRequest) {
        return this.calculateProductsV3(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    public DataResponse calculateProductsV3(DataRequest dataRequest) {
        return this.calculateProductsV3(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    public DataResponse calculatePostage(DataRequest dataRequest) {
        return this.calculatePostage(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    public DataResponse calculatePostageV2(DataRequest dataRequest) {
        return this.calculatePostageV3(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    public DataResponse calculatePostageV3(DataRequest dataRequest) {
        return this.calculatePostageV3(this.aliCDNUrlAuth, this.mongoTemplate, dataRequest);
    }

    private void removeActivityIdFromProduct(String activityId) {
        DBCollection productDbCollection = this.mongoTemplate.getCollection("def_product");
        BasicDBObject productBasicDBObject = new BasicDBObject();
        productBasicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_id", null));
        productDbCollection.update((DBObject)new BasicDBObject("promotion_activity_id", (Object)activityId), (DBObject)productBasicDBObject, false, true);
    }

    private void updateActivityIdFromProduct(String corp_code, JSONObject productCondition, String activityId) {
        if (productCondition == null) {
            return;
        }
        String allProduct = "Y";
        String isAll = productCondition.getString("is_all");
        if (allProduct.equals(isAll)) {
            DBCollection dbCollection = this.mongoTemplate.getCollection("def_product");
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_id", (Object)activityId));
            dbCollection.update((DBObject)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")).append("corp_code", (Object)corp_code), (DBObject)basicDBObject, false, true);
        } else {
            String productIds = productCondition.getString("condition");
            String[] productIdArray = productIds.split(",");
            ArrayList<BathUpdateOptions> bathUpdateOptionsList = new ArrayList<BathUpdateOptions>();
            for (int i = 0; i < productIdArray.length; ++i) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(productIdArray[i])));
                Update update = new Update();
                update.set("promotion_activity_id", (Object)activityId);
                bathUpdateOptionsList.add(new BathUpdateOptions(query, update, false, false));
            }
            if (bathUpdateOptionsList.size() > 0) {
                List lists = ListUtil.cutListByArray(bathUpdateOptionsList, (int)1000);
                for (int i = 0; i < lists.size(); ++i) {
                    UpdateMongoDBUtils.bathUpdate((MongoTemplate)this.mongoTemplate, (String)"def_product", (List)((List)lists.get(i)));
                }
            }
        }
    }

    private void updateActivityIdFromProductV2(JSONObject productCondition, String activityId, String corp_code, String store_flag, JSONArray store_ids, String addMod) {
        String s3;
        Map sp_map;
        if (productCondition == null) {
            return;
        }
        String allProduct = "Y";
        String isAll = productCondition.getString("is_all");
        String store_ids_str = "";
        for (int i = 0; i < store_ids.size(); ++i) {
            String store_id_str = (String)store_ids.get(i);
            store_ids_str = i == 0 ? store_id_str : store_ids_str + "," + store_id_str;
        }
        DBCollection sp_dbCollection = this.mongoTemplate.getCollection("def_store_product");
        if ("MOD".equals(addMod)) {
            DBCursor temp_other_act_pro = null;
            temp_other_act_pro = sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("promotion_activity_ids", (Object)new BasicDBObject("$eq", (Object)activityId)));
            List temp_other_act_pro_list = this.handleDbCursor(temp_other_act_pro);
            BasicDBObject temp_basicDBObject = new BasicDBObject();
            String pro_product_id = "";
            String pro_store_id = "";
            ArrayList<String> temp_pro_act_ids = new ArrayList<String>();
            List promotion_activity_ids = null;
            for (Map t : temp_other_act_pro_list) {
                pro_product_id = (String)t.get("product_id");
                pro_store_id = (String)t.get("store_id");
                temp_pro_act_ids = new ArrayList();
                promotion_activity_ids = (List)t.get("promotion_activity_ids");
                if (ObjectUtils.isNotEmpty((Object)promotion_activity_ids)) {
                    for (String s2 : promotion_activity_ids) {
                        if (activityId.equals(s2)) continue;
                        temp_pro_act_ids.add(s2);
                    }
                }
                temp_basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_ids", temp_pro_act_ids));
                sp_dbCollection.update((DBObject)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")).append("corp_code", (Object)corp_code).append("store_id", (Object)pro_store_id).append("product_id", (Object)pro_product_id), (DBObject)temp_basicDBObject, false, true);
            }
        }
        if (allProduct.equals(isAll)) {
            DBCollection dbCollection = this.mongoTemplate.getCollection("def_product");
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_id", (Object)activityId));
            ArrayList<String> pro_act_ids = new ArrayList<String>();
            DBCursor dbObjects = null;
            log.info("############ \u662f\u5426\u6307\u5b9a\u95e8\u5e97 store_ids_str = " + store_ids_str);
            log.info("############ \u662f\u5426\u6307\u5b9a\u95e8\u5e97 store_flag = " + store_flag);
            dbObjects = "1".equals(store_flag) ? sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(","))))) : sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code));
            List das = this.handleDbCursor(dbObjects);
            List promotion_activity_ids = null;
            String now_product_id = "";
            String now_store_id = "";
            sp_map = null;
            s3 = "";
            BasicDBObject query = new BasicDBObject();
            BasicDBObject update = new BasicDBObject();
            for (int i = 0; i < das.size(); ++i) {
                sp_map = (Map)das.get(i);
                pro_act_ids.add(activityId);
                promotion_activity_ids = (List)sp_map.get("promotion_activity_ids");
                now_product_id = (String)sp_map.get("product_id");
                now_store_id = (String)sp_map.get("store_id");
                if (ObjectUtils.isNotEmpty((Object)promotion_activity_ids)) {
                    for (String s3 : promotion_activity_ids) {
                        if (activityId.equals(s3)) continue;
                        pro_act_ids.add(s3);
                    }
                }
                basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_ids", pro_act_ids));
                sp_dbCollection.update((DBObject)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")).append("corp_code", (Object)corp_code).append("product_id", (Object)now_product_id).append("store_id", (Object)now_store_id), (DBObject)basicDBObject, false, true);
                pro_act_ids.clear();
            }
        } else {
            BasicDBObject basicDBObject = new BasicDBObject();
            String productIds = productCondition.getString("condition");
            String[] productIdArray = productIds.split(",");
            ArrayList<BathUpdateOptions> bathUpdateOptionsList = new ArrayList<BathUpdateOptions>();
            for (int i = 0; i < productIdArray.length; ++i) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(productIdArray[i])));
                Update update = new Update();
                update.set("promotion_activity_id", (Object)activityId);
                bathUpdateOptionsList.add(new BathUpdateOptions(query, update, false, false));
            }
            if (bathUpdateOptionsList.size() > 0) {
                List lists = ListUtil.cutListByArray(bathUpdateOptionsList, (int)1000);
                for (int i = 0; i < lists.size(); ++i) {
                }
            }
            ArrayList<String> pro_act_ids = new ArrayList<String>();
            DBCursor dbObjects = null;
            dbObjects = "1".equals(store_flag) ? sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(",")))).append("product_id", (Object)new BasicDBObject("$in", Arrays.asList(productIds.split(","))))) : sp_dbCollection.find((DBObject)new BasicDBObject("corp_code", (Object)corp_code).append("product_id", (Object)new BasicDBObject("$in", Arrays.asList(productIds.split(",")))));
            List das = this.handleDbCursor(dbObjects);
            List promotion_activity_ids = null;
            sp_map = null;
            s3 = "";
            for (int i = 0; i < das.size(); ++i) {
                sp_map = (Map)das.get(i);
                pro_act_ids.add(activityId);
                promotion_activity_ids = (List)sp_map.get("promotion_activity_ids");
                if (ObjectUtils.isNotEmpty((Object)promotion_activity_ids)) {
                    for (String s3 : promotion_activity_ids) {
                        if (activityId.equals(s3)) continue;
                        pro_act_ids.add(s3);
                    }
                }
                basicDBObject.put((Object)"$set", (Object)new BasicDBObject("promotion_activity_ids", pro_act_ids));
                sp_dbCollection.update((DBObject)new BasicDBObject("is_group", (Object)new BasicDBObject("$ne", (Object)"Y")).append("corp_code", (Object)corp_code).append("store_id", (Object)new BasicDBObject("$in", Arrays.asList(store_ids_str.split(",")))).append("product_id", (Object)new BasicDBObject("$in", Arrays.asList(productIds.split(",")))), (DBObject)basicDBObject, false, true);
                pro_act_ids = new ArrayList();
            }
        }
    }
}

