/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kr.weitao.activity.service.LotteryService;
import kr.weitao.activity.utils.DrawLotteryUtil;
import kr.weitao.activity.utils.MongodbUtils;
import kr.weitao.business.common.agent.CouponAgent;
import kr.weitao.business.common.agent.UiAgent;
import kr.weitao.business.common.agent.WingMixAgent;
import kr.weitao.business.entity.Vip;
import kr.weitao.business.entity.activity.AwardActivity;
import kr.weitao.business.entity.activity.Index_award;
import kr.weitao.business.entity.activity.LogAward;
import kr.weitao.business.entity.coupon.CouponType;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryServiceImpl
implements LotteryService {
    private static final Logger log = LoggerFactory.getLogger(LotteryServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongodbUtils mongodbUtils;
    @Autowired
    CouponAgent couponAgent;
    @Autowired
    UiAgent uiAgent;
    @Autowired
    WingMixAgent wingMixAgent;

    public DataResponse findAllAward(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String mini_appid = data.getString("mini_appid");
        String vip_id = data.getString("vip_id");
        String award_activity_id = data.getString("award_activity_id");
        if (StringUtils.isNull((Object)vip_id)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u8bf7\u5148\u767b\u5f55\uff01");
        }
        String store_id = data.getString("store_id");
        if (StringUtils.isNull((Object)store_id)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u6682\u65e0\u95e8\u5e97\u4fe1\u606f\uff01");
        }
        String corp_code = this.mongodbUtils.getCorpCode(mini_appid);
        String currentTimeInString = TimeUtils.getCurrentTimeInString();
        BasicDBObject include_query = new BasicDBObject();
        if (StringUtils.isNull((Object)award_activity_id)) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put((Object)"corp_code", (Object)corp_code);
            dbObject.put((Object)"is_finish", (Object)new BasicDBObject("$ne", (Object)"Y"));
            dbObject.put((Object)"start_time", (Object)new BasicDBObject("$lte", (Object)currentTimeInString));
            dbObject.put((Object)"end_time", (Object)new BasicDBObject("$gte", (Object)currentTimeInString));
            BasicDBList list = new BasicDBList();
            list.add((Object)new BasicDBObject("store_array", (Object)new BasicDBObject("$eq", (Object)new Object[0])));
            list.add((Object)new BasicDBObject("store_array", (Object)new BasicDBObject("$eq", (Object)store_id)));
            BasicDBList dbList = new BasicDBList();
            dbList.add((Object)dbObject);
            dbList.add((Object)new BasicDBObject("$or", (Object)list));
            include_query = new BasicDBObject("$and", (Object)dbList);
        } else {
            include_query.put((Object)"award_activity_id", (Object)award_activity_id);
        }
        DBObject object1 = this.mongoTemplate.getCollection("def_award_activity").findOne((DBObject)include_query);
        Vip vip = (Vip)this.mongoTemplate.findById((Object)vip_id, Vip.class);
        if (vip == null) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728\uff01");
        }
        Double[] points = new Double[]{0.0};
        if (corp_code.equals("C10022")) {
            JSONObject request = new JSONObject();
            if (StringUtils.isNotNull((Object)vip.getVip_phone())) {
                JSONObject vipTemp;
                JSONArray vips;
                request.put("phone", (Object)vip.getVip_phone());
                DataResponse response = this.wingMixAgent.callRest(new DataRequest().setData(request), "/vip/queryVipInfo");
                log.info("========\u83b7\u53d6\u7ebf\u4e0b\u4f1a\u5458\u79ef\u5206\uff1a" + response.toString());
                if (response != null && response.getData() != null && !CollectionUtils.isEmpty((Collection)(vips = response.getData().getJSONArray("vips"))) && (vipTemp = vips.getJSONObject(0)).containsKey((Object)"INTEGRAL") && StringUtils.isNotNull((Object)vipTemp.get((Object)"INTEGRAL"))) {
                    points[0] = vipTemp.getDouble("INTEGRAL");
                }
            }
            log.info("=============\u4f1a\u5458\u7ebf\u4e0b\u79ef\u5206\u503c\uff1a" + points[0]);
        } else if (corp_code.equals("C10021")) {
            points[0] = vip.getPoints();
        }
        long award_count = 0L;
        if (object1 != null) {
            Map map = object1.toMap();
            Query query_award = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is(map.get("activity_id")).and("corp_code").is((Object)corp_code).and("is_active").is((Object)"Y"));
            log.info("\u6d3b\u52a8\u5956\u54c1\u67e5\u8be2\u6761\u4ef6\uff1a" + query_award);
            List index_awards_list = this.mongoTemplate.find(query_award, Index_award.class);
            award_count = this.getAward_count(vip_id, corp_code, map);
            JSONObject object = new JSONObject();
            object.put("list", (Object)index_awards_list);
            object.put("award_count", (Object)award_count);
            object.put("awardActivity", (Object)map);
            object.put("points", (Object)points[0]);
            return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object);
        }
        JSONObject object = new JSONObject();
        object.put("award_count", (Object)award_count);
        object.put("points", (Object)points[0]);
        return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6682\u65e0\u5f00\u59cb\u7684\u6d3b\u52a8\uff01").setData(object);
    }

    public long getAward_count(String vip_id, String corp_code, Map<String, Object> map) {
        long award_count = 0L;
        if (map.get("attend_count").equals("1")) {
            String timeAfterDay = TimeUtils.getTimeAfterDay((int)0);
            Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id).and("corp_code").is((Object)corp_code).and("created_date").regex(timeAfterDay).and("award_activity_id").is((Object)String.valueOf(map.get("award_activity_id"))));
            log.info("\u6bcf\u65e5\u5269\u4f59\u62bd\u5956\u6b21\u6570\u6761\u4ef6\uff1a" + query1);
            long count = this.mongoTemplate.count(query1, LogAward.class);
            award_count = (long)Integer.valueOf(String.valueOf(map.get("award_count"))).intValue() - count;
        } else {
            Query query2 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id).and("corp_code").is((Object)corp_code).and("award_activity_id").is(map.get("award_activity_id")));
            log.info("\u6d3b\u52a8\u671f\u95f4\u5269\u4f59\u62bd\u5956\u6b21\u6570\u6761\u4ef6\uff1a" + query2);
            long count = this.mongoTemplate.count(query2, LogAward.class);
            award_count = (long)Integer.valueOf(String.valueOf(map.get("award_count"))).intValue() - count;
        }
        return award_count;
    }

    public DataResponse findLogAward(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String mini_appid = data.getString("mini_appid");
        String award_activity_id = data.getString("award_activity_id");
        if (StringUtils.isNull((Object)mini_appid)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("mini_appid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String corpCode = this.mongodbUtils.getCorpCode(mini_appid);
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corpCode).and("award_activity_id").is((Object)award_activity_id).and("is_active").is((Object)"Y").and("active").is((Object)"Y")).with(new Sort(Sort.Direction.DESC, new String[]{"created_date"}));
        List logAwards = this.mongoTemplate.find(query, LogAward.class);
        String award_name = "";
        for (LogAward logAward : logAwards) {
            String vip_id = logAward.getVip_id();
            String name = null;
            Vip vip = (Vip)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"vip_id").is((Object)vip_id)), Vip.class);
            String vip_phone = vip.getVip_phone();
            if (StringUtils.isNull((Object)vip_phone)) {
                name = vip.getNick_name().substring(0, 1) + "****";
                log.info("\u4f1a\u5458\u6635\u79f0\uff1a" + name);
            } else {
                name = vip_phone.substring(0, 3) + "****" + vip_phone.substring(7, vip_phone.length());
                log.info("\u4f1a\u5458\u624b\u673a\u53f7\uff1a" + name);
            }
            if (StringUtils.isNull((Object)logAward.getAward_type())) {
                Index_award indexAward = (Index_award)this.mongoTemplate.findById((Object)logAward.getAward_id(), Index_award.class);
                if (indexAward.getAward_type().equals("1")) {
                    CouponType couponType = (CouponType)this.mongoTemplate.findById((Object)indexAward.getCoupon_id(), CouponType.class);
                    if (couponType.getCoupon_type().equals("1")) {
                        award_name = "\u83b7\u5f97" + new BigDecimal(couponType.getMin_amount()) + "-" + new BigDecimal(couponType.getCoupon_value()) + "\u4f18\u60e0\u5238\u4e00\u5f20";
                    } else if (couponType.getCoupon_type().equals("2")) {
                        award_name = "\u83b7\u5f97" + new BigDecimal(couponType.getCoupon_value() * 10.0) + "\u6298\u4f18\u60e0\u5238\u4e00\u5f20";
                    } else if (couponType.getCoupon_type().equals("3")) {
                        award_name = "\u83b7\u5f97\u5a03\u5a03\u673a\u4f18\u60e0\u5238\u4e00\u5f20";
                    }
                } else if (indexAward.getAward_type().equals("2")) {
                    award_name = "\u83b7\u5f97" + indexAward.getIntegral() + "\u79ef\u5206";
                }
            } else if (logAward.getAward_type().equals("1")) {
                CouponType couponType = (CouponType)this.mongoTemplate.findById((Object)logAward.getCoupon_id(), CouponType.class);
                if (couponType.getCoupon_type().equals("1")) {
                    award_name = "\u83b7\u5f97" + new BigDecimal(couponType.getMin_amount()) + "-" + new BigDecimal(couponType.getCoupon_value()) + "\u4f18\u60e0\u5238\u4e00\u5f20";
                } else if (couponType.getCoupon_type().equals("2")) {
                    award_name = "\u83b7\u5f97" + new BigDecimal(couponType.getCoupon_value() * 10.0) + "\u6298\u4f18\u60e0\u5238\u4e00\u5f20";
                } else if (couponType.getCoupon_type().equals("3")) {
                    award_name = "\u83b7\u5f97\u5a03\u5a03\u673a\u4f18\u60e0\u5238\u4e00\u5f20";
                }
            } else if (logAward.getAward_type().equals("2")) {
                award_name = "\u83b7\u5f97" + logAward.getIntegral() + "\u79ef\u5206";
            }
            logAward.setName(name);
            logAward.setAward_name(award_name);
        }
        JSONObject object = new JSONObject();
        object.put("logAward", (Object)logAwards);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
    }

    public DataResponse findOneLogAward(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String mini_appid = data.getString("mini_appid");
        String vip_id = data.getString("vip_id");
        if (StringUtils.isNull((Object)vip_id)) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("vip_id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String corpCode = this.mongodbUtils.getCorpCode(mini_appid);
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corpCode).and("vip_id").is((Object)vip_id).and("is_active").is((Object)"Y")).with(new Sort(Sort.Direction.DESC, new String[]{"created_date"}));
        List logAwards = this.mongoTemplate.find(query, LogAward.class);
        for (LogAward logAward : logAwards) {
            Index_award indexAward = (Index_award)this.mongoTemplate.findById((Object)logAward.getAward_id(), Index_award.class);
            logAward.setAward_name(indexAward.getAward_name());
            logAward.setAward_img(indexAward.getAward_img());
        }
        JSONObject object = new JSONObject();
        object.put("logAward", (Object)logAwards);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
    }

    public DataResponse performAward(DataRequest dataRequest) {
        Map map;
        long award_count;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String vip_id = data.getString("vip_id");
        String mini_appid = data.getString("mini_appid");
        String award_activity_id = data.getString("award_activity_id");
        if (StringUtils.isNull((Object)vip_id)) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u8bf7\u5148\u767b\u5f55\uff01");
        }
        if (StringUtils.isNull((Object)mini_appid)) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("mini_appid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String corpCode = this.mongodbUtils.getCorpCode(mini_appid);
        Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)award_activity_id));
        AwardActivity awardActivity = (AwardActivity)this.mongoTemplate.findOne(query1, AwardActivity.class);
        if (awardActivity == null) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        if (awardActivity.getIs_finish().equals("Y")) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff01");
        }
        if (awardActivity.getIs_finish().equals("N")) {
            String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String start_time = awardActivity.getStart_time();
                String end_time = awardActivity.getEnd_time();
                Date start_time1 = simpleDateFormat.parse(start_time);
                Date end_time1 = simpleDateFormat.parse(end_time);
                Date now1 = simpleDateFormat.parse(now);
                if (start_time1.after(now1)) {
                    return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6d3b\u52a8\u672a\u5f00\u59cb\uff01");
                }
                if (start_time1.before(now1) && now1.before(end_time1) && awardActivity.getIs_suspend().equals("Y")) {
                    return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6d3b\u52a8\u5df2\u6682\u505c\uff01");
                }
                if (end_time1.before(now1)) {
                    return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff01");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((award_count = this.getAward_count(vip_id, corpCode, map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)awardActivity), Map.class))) <= 0L) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u62bd\u5956\u6b21\u6570\u4e0d\u8db3\uff01");
        }
        Vip vip = (Vip)this.mongoTemplate.findById((Object)vip_id, Vip.class);
        if (!CollectionUtils.isEmpty((Collection)awardActivity.getVip_array()) && !awardActivity.getVip_array().contains((Object)vip.getVip_grade_id())) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u60a8\u7684\u7b49\u7ea7\u6682\u65e0\u6cd5\u53c2\u4e0e\u6b64\u6d3b\u52a8\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)awardActivity.getStore_array()) && !awardActivity.getStore_array().contains((Object)vip.getStore_id())) {
            return dataResponse.setCode("-1").setStatus(Status.FAILED).setMsg("\u60a8\u6240\u5728\u95e8\u5e97\u6682\u65e0\u6cd5\u53c2\u4e0e\u6b64\u6d3b\u52a8\uff01");
        }
        if (awardActivity.getActivity_type().equals("2")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("corp_code", (Object)corpCode);
            jsonObject.put("user_id", (Object)awardActivity.getCreator_id());
            jsonObject.put("vip_id", (Object)vip_id);
            jsonObject.put("integral_value", (Object)("-" + awardActivity.getAward_points()));
            jsonObject.put("integral_source", (Object)"\u5927\u8f6c\u76d8\u62bd\u5956");
            jsonObject.put("integral_remark", (Object)("\u62bd\u5956\u6d88\u8017" + awardActivity.getAward_points() + "\u79ef\u5206"));
            DataRequest editVipIntegral = new DataRequest();
            editVipIntegral.setData(jsonObject);
            log.info("\u7528\u6237\u62bd\u5956 \u6263\u9664\u79ef\u5206 ru can = " + editVipIntegral.toString());
            DataResponse dataResponse1 = this.uiAgent.callRest(editVipIntegral, "/management/vipIntegral/editVipIntegral");
            if (dataResponse1.getStatus().equals((Object)Status.FAILED)) {
                return dataResponse1;
            }
            log.info("\u7528\u6237\u62bd\u5956 \u6263\u9664\u79ef\u5206 dataResponse = " + dataResponse1.toString());
        }
        List index_awards = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)awardActivity.getActivity_id()).and("corp_code").is((Object)corpCode).and("count").ne((Object)"0").and("is_active").is((Object)"Y")).with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "power_num")})), Index_award.class);
        Index_award index_award = null;
        LogAward logAward = new LogAward();
        Double sumRate = 0.0;
        for (Index_award indexAward : index_awards) {
            sumRate = sumRate + indexAward.getPower_num();
        }
        String is_active = "N";
        String is_actives = "N";
        double random = Math.random();
        if (random <= sumRate && index_awards.size() > 0) {
            int index = DrawLotteryUtil.drawGift((List)index_awards, (double)random);
            index_award = (Index_award)index_awards.get(index);
            is_active = "Y";
            is_actives = "Y";
            logAward.setAward_type(index_award.getAward_type());
            if (index_award.getAward_type().equals("1")) {
                logAward.setCoupon_id(index_award.getCoupon_id());
            } else if (index_award.getAward_type().equals("2")) {
                logAward.setIntegral(index_award.getIntegral());
            }
            log.info("=========\u62bd\u53d6\u5230\u7684\u5956\u54c1\uff1a" + index_award.getAward_name());
            this.drawLottery(index_award, vip_id, awardActivity);
            long count = Integer.valueOf(index_award.getCount()) - 1;
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"index_award_id").is((Object)index_award.getIndex_award_id()).and("corp_code").is((Object)corpCode));
            Update update = new Update();
            update.set("count", (Object)String.valueOf(count));
            this.mongoTemplate.updateFirst(query, update, Index_award.class);
        }
        logAward.setCorp_code(corpCode);
        logAward.setVip_id(vip_id);
        if (index_award != null) {
            logAward.setAward_id(index_award.getIndex_award_id());
        } else {
            logAward.setAward_id(null);
        }
        logAward.setIs_active(is_actives);
        logAward.setActive("Y");
        logAward.setAward_activity_id(awardActivity.getAward_activity_id());
        logAward.setCreated_date(TimeUtils.getCurrentTimeInString());
        this.mongoTemplate.save((Object)logAward);
        JSONObject object = new JSONObject();
        object.put("index_award", (Object)index_award);
        object.put("is_active", (Object)is_active);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object);
    }

    public void drawLottery(Index_award index_award, String vip_id, AwardActivity awardActivity) {
        if (index_award.getAward_type().equals("1")) {
            DataRequest dataCoupon = new DataRequest();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)vip_id);
            JSONObject send_info = new JSONObject();
            send_info.put("user_id", (Object)"5f1175bde523c0620cc1f071");
            send_info.put("vip_array", (Object)jsonArray);
            send_info.put("channel_code", (Object)"drawLotterySendCoupon");
            send_info.put("remarks", (Object)"\u62bd\u5956\u9001\u5238");
            send_info.put("activity_id", (Object)awardActivity.getAward_activity_id());
            JSONArray coupon_type_array_new = new JSONArray();
            String coupon_id = index_award.getCoupon_id();
            JSONObject couponInfo = new JSONObject();
            couponInfo.put("id", (Object)coupon_id);
            couponInfo.put("count", (Object)"1");
            log.info("\u751f\u65e5\u9001\u5238\u6d3b\u52a8\u7684\u4f18\u60e0\u5238\u96c6\u5408\uff1a" + couponInfo);
            coupon_type_array_new.add((Object)couponInfo);
            JSONObject param = new JSONObject();
            param.put("send_info", (Object)send_info);
            param.put("coupon_type_array", (Object)coupon_type_array_new);
            log.info("+++++++++++++\u4f1a\u5458vip\uff1a" + jsonArray);
            log.info("+++++++++++++\u5238coupon\uff1a" + coupon_type_array_new);
            dataCoupon.setData(param);
            dataCoupon.setSign("string");
            dataCoupon.setId(System.currentTimeMillis() + "");
            dataCoupon.setAccess_key("string");
            try {
                this.couponAgent.callRest(dataCoupon, "/coupon/batchSendCoupon");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (index_award.getAward_type().equals("2")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("corp_code", (Object)awardActivity.getCorp_code());
            jsonObject.put("user_id", (Object)awardActivity.getCreator_id());
            jsonObject.put("vip_id", (Object)vip_id);
            jsonObject.put("integral_value", (Object)index_award.getIntegral());
            jsonObject.put("integral_source", (Object)"\u5927\u8f6c\u76d8\u62bd\u5956");
            jsonObject.put("integral_remark", (Object)("\u62bd\u5956\u83b7\u5f97" + index_award.getIntegral() + "\u79ef\u5206"));
            DataRequest editVipIntegral = new DataRequest();
            editVipIntegral.setData(jsonObject);
            log.info("\u7528\u6237\u62bd\u5956  ru can = " + editVipIntegral.toString());
            DataResponse dataResponse = this.uiAgent.callRest(editVipIntegral, "/management/vipIntegral/editVipIntegral");
            log.info("\u7528\u6237\u62bd\u5956  dataResponse = " + dataResponse.toString());
        }
    }
}

