/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.SendResult;
import com.mongodb.BasicDBObject;
import com.mongodb.WriteResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kr.weitao.activity.service.GroupActivityService;
import kr.weitao.activity.service.PromotionActivityService;
import kr.weitao.activity.service.impl.GroupActivityServiceImpl;
import kr.weitao.activity.utils.GroupActivityProducer;
import kr.weitao.activity.utils.MongodbUtilsGroup;
import kr.weitao.business.common.agent.WechatAgent;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.activity.GroupActivity;
import kr.weitao.business.entity.activity.GroupActivityBody;
import kr.weitao.business.entity.activity.GroupActivityGoods;
import kr.weitao.business.entity.activity.GroupActivityGoodsSku;
import kr.weitao.business.entity.activity.GroupActivityMember;
import kr.weitao.business.entity.data.Product;
import kr.weitao.business.entity.product.Sku;
import kr.weitao.business.entity.product.Spec;
import kr.weitao.business.entity.product.SpecItem;
import kr.weitao.common.exception.ServiceException;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import kr.weitao.starter.util.ons.constants.MessageType;
import kr.weitao.starter.util.ons.message.MessageBase;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class GroupActivityServiceImpl
implements GroupActivityService {
    private static final Logger log = LoggerFactory.getLogger(GroupActivityServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongodbUtilsGroup mongodbUtils;
    @Autowired
    AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    GroupActivityProducer groupActivityProducer;
    @Autowired
    MongodbUtilsGroup mongodbUtilsGroup;
    @Autowired
    WechatAgent wechatAgent;
    private int top_product_num = 50;
    @Autowired
    PromotionActivityService promotionActivityService;

    public DataResponse addOneActivity(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        log.info("\u62fc\u56e2\u6dfb\u52a0\u5165\u53c2:{}", (Object)data);
        JSONArray product_data_array = data.getJSONObject("main_data").getJSONArray("product_data");
        if (product_data_array.size() > this.top_product_num) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u53c2\u4e0e\u6d3b\u52a8\u5546\u54c1\u4e0d\u53ef\u5927\u4e8e" + this.top_product_num);
        }
        GroupActivity groupActivity = (GroupActivity)JSONObject.parseObject((String)data.getJSONObject("main_data").toString(), GroupActivity.class);
        log.info("\u62fc\u56e2\u6dfb\u52a0\u8f6c\u5316\u4e3aGroupActivity:{}", (Object)groupActivity);
        DataResponse dataResponse1 = this.checkPromotion("add", product_data_array, groupActivity, "23333");
        if ("-1".equals(dataResponse1.getCode())) {
            return dataResponse1;
        }
        DataResponse dataResponse2 = this.judgeEndTimeAndCurrent(groupActivity.getBegin_time(), groupActivity.getEnd_time());
        if ("-1".equals(dataResponse2.getCode())) {
            return dataResponse2;
        }
        String group_type = groupActivity.getGroup_type();
        long code = System.currentTimeMillis();
        groupActivity.setCode(String.valueOf(code));
        String begin_time = groupActivity.getBegin_time();
        String pre_heat_length = groupActivity.getPre_heat_length();
        String beforeByHourTime = null;
        if (StringUtils.isNotNull((Object)pre_heat_length)) {
            beforeByHourTime = this.getBeforeByHourTime(Integer.valueOf(pre_heat_length).intValue(), begin_time);
        }
        groupActivity.setPre_heat_time(beforeByHourTime);
        JSONArray store_ids = groupActivity.getStore_ids();
        if (StringUtils.isNotNull((Object)groupActivity.getStore_flag()) && "all".equals(groupActivity.getStore_flag())) {
            Query queryStore = new Query((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y").and("corp_code").is((Object)data.getString("corp_code")));
            List stores = this.mongoTemplate.find(queryStore, Store.class);
            if (!ObjectUtils.isEmpty((Object)stores)) {
                store_ids = stores.stream().map(o -> o.get_id().toString()).collect(Collectors.toCollection(JSONArray::new));
            }
            groupActivity.setStore_ids(store_ids);
        }
        String group_activity_id = "Activity" + code;
        groupActivity.setGroup_activity_id(group_activity_id);
        groupActivity.setGoods_num(Integer.valueOf(product_data_array == null ? 0 : product_data_array.size()));
        String current = TimeUtils.getCurrentTimeInString();
        groupActivity.setCreator_id(data.getString("user_id"));
        groupActivity.setCreated_date(current);
        groupActivity.setModifier_id(data.getString("user_id"));
        groupActivity.setModified_date(current);
        groupActivity.setCorp_code(data.getString("corp_code"));
        this.mongoTemplate.save((Object)groupActivity);
        if (!ObjectUtils.isEmpty((Object)product_data_array)) {
            for (int i = 0; i < product_data_array.size(); ++i) {
                String group_activity_goods_id = "Goods" + System.currentTimeMillis();
                GroupActivityGoods oneGood = (GroupActivityGoods)JSONObject.parseObject((String)product_data_array.getJSONObject(i).toString(), GroupActivityGoods.class);
                if (oneGood.getPerson_in_group_num() != null && 0 < oneGood.getPerson_in_group_num()) {
                    oneGood.setPerson_in_group_num_flag("yes");
                }
                if (oneGood.getPerson_buy_num() != null && 0 < oneGood.getPerson_buy_num()) {
                    oneGood.setPerson_buy_num_flag("yes");
                }
                oneGood.setGroup_type(group_type);
                oneGood.setRel_group_activity_id(group_activity_id);
                oneGood.setGroup_activity_goods_id(group_activity_goods_id);
                oneGood.setStore_ids(store_ids);
                oneGood.setStore_flag(groupActivity.getStore_flag());
                oneGood.setBegin_time(groupActivity.getBegin_time());
                oneGood.setEnd_time(groupActivity.getEnd_time());
                oneGood.setPre_heat_time(groupActivity.getPre_heat_time());
                oneGood.setGroup_type(groupActivity.getGroup_type());
                oneGood.setCreator_id(data.getString("user_id"));
                oneGood.setCreated_date(current);
                oneGood.setModifier_id(data.getString("user_id"));
                oneGood.setModified_date(current);
                oneGood.setCorp_code(data.getString("corp_code"));
                this.mongoTemplate.save((Object)oneGood);
                JSONArray skuArray = product_data_array.getJSONObject(i).getJSONArray("sku_data");
                if (ObjectUtils.isEmpty((Object)skuArray)) continue;
                for (int j = 0; j < skuArray.size(); ++j) {
                    GroupActivityGoodsSku oneSku = (GroupActivityGoodsSku)JSONObject.parseObject((String)skuArray.getJSONObject(j).toJSONString(), GroupActivityGoodsSku.class);
                    String group_activity_goods_sku_id = "Skus" + System.currentTimeMillis();
                    oneSku.setRel_activity_id(group_activity_id);
                    oneSku.setRel_group_activity_goods_id(group_activity_goods_id);
                    oneSku.setStore_flag(groupActivity.getStore_flag());
                    oneSku.setStore_ids(store_ids);
                    oneSku.setBegin_time(groupActivity.getBegin_time());
                    oneSku.setPre_heat_time(groupActivity.getPre_heat_time());
                    oneSku.setEnd_time(groupActivity.getEnd_time());
                    oneSku.setCreator_id(data.getString("user_id"));
                    oneSku.setCreated_date(current);
                    oneSku.setModifier_id(data.getString("user_id"));
                    oneSku.setModified_date(current);
                    oneSku.setCorp_code(data.getString("corp_code"));
                    oneSku.setGroup_activity_goods_sku_id(group_activity_goods_sku_id);
                    oneSku.setGroup_type(group_type);
                    this.mongoTemplate.save((Object)oneSku);
                }
            }
            this.sendActivityMq(group_activity_id, groupActivity.getEnd_time(), "\u65b0\u589e\u6d3b\u52a8");
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setMsg("\u65b0\u589e\u6210\u529f");
    }

    public DataResponse checkPromotion(String flag, JSONArray product_data_array, GroupActivity groupActivity, String group_activity_id) {
        log.info(flag + "\u65b0\u589e\u4fee\u6539\u8c03\u6ee1\u51cf\u6821\u9a8c\u4e92\u65a5");
        DataResponse dataResponse = new DataResponse();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < product_data_array.size(); ++i) {
            String product_id = product_data_array.getJSONObject(i).getString("product_id");
            stringBuilder.append(product_id + ",");
        }
        DataRequest requestPromotion = new DataRequest();
        JSONObject dataPromotion = new JSONObject();
        dataPromotion.put("activity_type", (Object)"PA");
        dataPromotion.put("activity_id", (Object)group_activity_id);
        dataPromotion.put("product_id", (Object)stringBuilder.toString());
        dataPromotion.put("is_all", (Object)"N");
        dataPromotion.put("rules", null);
        if ("all".equals(groupActivity.getStore_flag())) {
            dataPromotion.put("store_ids", null);
            dataPromotion.put("store_flag", (Object)"0");
        } else {
            dataPromotion.put("store_ids", (Object)groupActivity.getStore_ids());
            dataPromotion.put("store_flag", (Object)"1");
        }
        dataPromotion.put("beginTime", (Object)groupActivity.getBegin_time());
        dataPromotion.put("endTime", (Object)groupActivity.getEnd_time());
        requestPromotion.setData(dataPromotion);
        log.info("\u6821\u9a8c\u6d3b\u52a8\u4e92\u65a5" + flag + "\u8c03\u6ee1\u51cfoperationalByActivities\u5165\u53c2dataPromotion:{}", (Object)dataPromotion);
        try {
            this.promotionActivityService.operationalByActivities(requestPromotion);
        }
        catch (ServiceException e) {
            log.error("\u6821\u9a8c\u6d3b\u52a8\u4e92\u65a5" + flag + "\u8c03\u6ee1\u51cf\u8fdb\u5165\u5f02\u5e38:{}", (Throwable)e);
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg(e.getMsg());
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0");
    }

    public void groupActivityCheckAddOrModify(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        String activity_id = data.getString("activity_id");
        String begin_time = data.getString("begin_time");
        String end_time = data.getString("end_time");
        String store_flag = data.getString("store_flag");
        JSONArray store_ids = data.getJSONArray("store_ids");
        String product_flag = data.getString("product_flag");
        JSONArray product_ids = data.getJSONArray("product_ids");
    }

    public DataResponse editOneActivity(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        log.info("\u7f16\u8f91\u62fc\u56e2\u5165\u53c2:{}", (Object)data);
        JSONArray product_data_array = data.getJSONObject("main_data").getJSONArray("product_data");
        if (product_data_array.size() > this.top_product_num) {
            return dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u53c2\u4e0e\u6d3b\u52a8\u5546\u54c1\u4e0d\u53ef\u5927\u4e8e" + this.top_product_num);
        }
        String group_activity_id = data.getString("group_activity_id");
        Query query_activity = new Query((CriteriaDefinition)Criteria.where((String)"group_activity_id").is((Object)group_activity_id));
        GroupActivity groupActivity = (GroupActivity)JSONObject.parseObject((String)data.getJSONObject("main_data").toString(), GroupActivity.class);
        log.info("\u62fc\u56e2\u4fee\u6539\u8f6c\u5316\u4e3aGroupActivity:{}", (Object)groupActivity);
        DataResponse dataResponse1 = this.checkPromotion("update", product_data_array, groupActivity, group_activity_id);
        if ("-1".equals(dataResponse1.getCode())) {
            return dataResponse1;
        }
        DataResponse dataResponse2 = this.judgeEndTimeAndCurrent(groupActivity.getBegin_time(), groupActivity.getEnd_time());
        if ("-1".equals(dataResponse2.getCode())) {
            return dataResponse2;
        }
        String group_type = groupActivity.getGroup_type();
        int sendMq = 1;
        GroupActivity one = (GroupActivity)this.mongoTemplate.findOne(query_activity, GroupActivity.class);
        if (!one.getEnd_time().equals(groupActivity.getEnd_time())) {
            log.info("\u7f16\u8f91\u62fc\u56e2\u4fee\u6539\u4e86one.getEnd_time():{},groupActivity.getEnd_time():{}", (Object)one.getEnd_time(), (Object)groupActivity.getEnd_time());
            sendMq = 2;
        }
        String begin_time = groupActivity.getBegin_time();
        String pre_heat_length = groupActivity.getPre_heat_length();
        String beforeByHourTime = null;
        if (StringUtils.isNotNull((Object)pre_heat_length)) {
            beforeByHourTime = this.getBeforeByHourTime(Integer.valueOf(pre_heat_length).intValue(), begin_time);
        }
        groupActivity.setPre_heat_time(beforeByHourTime);
        JSONArray store_ids = groupActivity.getStore_ids();
        if (StringUtils.isNotNull((Object)groupActivity.getStore_flag()) && "all".equals(groupActivity.getStore_flag())) {
            Query queryStore = new Query((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y").and("corp_code").is((Object)data.getString("corp_code")));
            List stores = this.mongoTemplate.find(queryStore, Store.class);
            if (!ObjectUtils.isEmpty((Object)stores)) {
                store_ids = stores.stream().map(o -> o.get_id().toString()).collect(Collectors.toCollection(JSONArray::new));
            }
            groupActivity.setStore_ids(store_ids);
        }
        groupActivity.setGoods_num(Integer.valueOf(product_data_array == null ? 0 : product_data_array.size()));
        String current = TimeUtils.getCurrentTimeInString();
        Update activityUpdate = new Update().set("modifier_id", (Object)data.getString("user_id")).set("modified_date", (Object)current).set("name", (Object)groupActivity.getName()).set("image", (Object)groupActivity.getImage()).set("begin_time", (Object)groupActivity.getBegin_time()).set("end_time", (Object)groupActivity.getEnd_time()).set("pre_heat", (Object)groupActivity.getPre_heat()).set("pre_heat_length", (Object)groupActivity.getPre_heat_length()).set("group_buy_active_length", (Object)groupActivity.getGroup_buy_active_length()).set("order_favour", (Object)groupActivity.getOrder_favour()).set("remark", (Object)groupActivity.getRemark()).set("store_flag", (Object)groupActivity.getStore_flag()).set("store_ids", (Object)groupActivity.getStore_ids()).set("pre_heat_time", (Object)groupActivity.getPre_heat_time());
        WriteResult activity_result = this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"group_activity_id").is((Object)group_activity_id)), activityUpdate, GroupActivity.class);
        if (activity_result.getN() > 0 && !ObjectUtils.isEmpty((Object)product_data_array)) {
            WriteResult remove_goods = this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_id").is((Object)group_activity_id)), GroupActivityGoods.class);
            WriteResult remove_skus = this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"rel_activity_id").is((Object)group_activity_id)), GroupActivityGoodsSku.class);
            if (remove_goods.getN() > 0 & remove_skus.getN() > 0) {
                log.info("\u8fdb\u5165\u4fee\u6539goods sku,remove_goods:{},remove_skus:{}", (Object)remove_goods.getN(), (Object)remove_skus.getN());
                for (int i = 0; i < product_data_array.size(); ++i) {
                    String group_activity_goods_id = "Goods" + System.currentTimeMillis();
                    GroupActivityGoods oneGood = (GroupActivityGoods)JSONObject.parseObject((String)product_data_array.getJSONObject(i).toString(), GroupActivityGoods.class);
                    if (oneGood.getPerson_in_group_num() != null && 0 < oneGood.getPerson_in_group_num()) {
                        oneGood.setPerson_in_group_num_flag("yes");
                    }
                    if (oneGood.getPerson_buy_num() != null && 0 < oneGood.getPerson_buy_num()) {
                        oneGood.setPerson_buy_num_flag("yes");
                    }
                    oneGood.setGroup_type(group_type);
                    oneGood.setRel_group_activity_id(group_activity_id);
                    oneGood.setGroup_activity_goods_id(group_activity_goods_id);
                    oneGood.setStore_ids(store_ids);
                    oneGood.setStore_flag(groupActivity.getStore_flag());
                    oneGood.setBegin_time(groupActivity.getBegin_time());
                    oneGood.setEnd_time(groupActivity.getEnd_time());
                    oneGood.setPre_heat_time(groupActivity.getPre_heat_time());
                    oneGood.setGroup_type(groupActivity.getGroup_type());
                    oneGood.setCreator_id(data.getString("user_id"));
                    oneGood.setCreated_date(current);
                    oneGood.setModifier_id(data.getString("user_id"));
                    oneGood.setModified_date(current);
                    oneGood.setCorp_code(data.getString("corp_code"));
                    this.mongoTemplate.save((Object)oneGood);
                    JSONArray skuArray = product_data_array.getJSONObject(i).getJSONArray("sku_data");
                    if (ObjectUtils.isEmpty((Object)skuArray)) continue;
                    for (int j = 0; j < skuArray.size(); ++j) {
                        GroupActivityGoodsSku oneSku = (GroupActivityGoodsSku)JSONObject.parseObject((String)skuArray.getJSONObject(j).toJSONString(), GroupActivityGoodsSku.class);
                        String group_activity_goods_sku_id = "Skus" + System.currentTimeMillis();
                        oneSku.setRel_activity_id(group_activity_id);
                        oneSku.setRel_group_activity_goods_id(group_activity_goods_id);
                        oneSku.setStore_flag(groupActivity.getStore_flag());
                        oneSku.setStore_ids(store_ids);
                        oneSku.setBegin_time(groupActivity.getBegin_time());
                        oneSku.setPre_heat_time(groupActivity.getPre_heat_time());
                        oneSku.setEnd_time(groupActivity.getEnd_time());
                        oneSku.setCreator_id(data.getString("user_id"));
                        oneSku.setCreated_date(current);
                        oneSku.setModifier_id(data.getString("user_id"));
                        oneSku.setModified_date(current);
                        oneSku.setCorp_code(data.getString("corp_code"));
                        oneSku.setGroup_activity_goods_sku_id(group_activity_goods_sku_id);
                        oneSku.setGroup_type(group_type);
                        this.mongoTemplate.save((Object)oneSku);
                    }
                }
                if (sendMq == 2) {
                    this.sendActivityMq(group_activity_id, groupActivity.getEnd_time(), "\u7f16\u8f91\u6d3b\u52a8");
                }
            }
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setMsg("\u4fee\u6539\u6d3b\u52a8\u6210\u529f");
    }

    private String getBeforeByHourTime(int ihour, String time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(df.parse(time));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.set(11, calendar.get(11) - ihour);
        String timeBeforeHour = df.format(calendar.getTime());
        return timeBeforeHour;
    }

    private DataResponse judgeEndTimeAndCurrent(String beginTime, String endTime) {
        String current = TimeUtils.getCurrentTimeInString();
        DataResponse dataResponse = new DataResponse();
        if (beginTime.compareTo(endTime) >= 0) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (beginTime.compareTo(current) <= 0) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (endTime.compareTo(current) <= 0) {
            dataResponse.setStatus(Status.FAILED).setCode("-1").setMsg("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        return dataResponse.setCode("0").setStatus(Status.SUCCESS);
    }

    private void sendActivityMq(String activityId, String endTime, String flag) {
        log.info("\u8fdb\u5165\u65b0\u589e\u7f16\u8f91\u53d1\u9001MQ");
        log.info("\u65b0\u589e/\u7f16\u8f91\u53d1\u9001MQ-----\u5165\u53c2-----activityId:{},endTime:{},flag:{}", new Object[]{activityId, endTime, flag});
        if (StringUtils.isNotNull((Object)activityId) && StringUtils.isNotNull((Object)endTime) && StringUtils.isNotNull((Object)flag)) {
            long timeStamp = 0L;
            try {
                timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime).getTime();
            }
            catch (ParseException e) {
                log.error("\u65b0\u589e/\u7f16\u8f91\u53d1\u9001MQ" + e);
                e.printStackTrace();
            }
            if (timeStamp != 0L) {
                String consumerParam = activityId + "," + endTime;
                MessageBase messageBase = new MessageBase();
                messageBase.setKey("mq_group_activity");
                messageBase.setMessage((Object)consumerParam);
                messageBase.setMessageType(MessageType.TIMER);
                messageBase.setStartDeliverTime(Long.valueOf(timeStamp));
                log.info("\u65b0\u589e/\u7f16\u8f91\u53d1\u9001\u8c03\u7528MQ\u5165\u53c2messageBase:---" + messageBase);
                SendResult sendResult = this.groupActivityProducer.sendMessage(messageBase);
                log.info("\u65b0\u589e/\u7f16\u8f91\u53d1\u9001\u8c03\u7528MQ\u8fd4\u53c2sendResult:---" + sendResult);
                if (sendResult.getMessageId() != null) {
                    log.info("\u751f\u4ea7\u6210\u529fsendActivityMq success\uff0cmessageId\uff1a" + sendResult.getMessageId());
                }
            }
        }
    }

    public DataResponse queryActivityByPage(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String group_type = data.getString("group_type");
        Integer page_num = data.getInteger("page_num");
        Integer page_size = data.getInteger("page_size");
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        JSONArray filter = data.getJSONArray("filter");
        BasicDBObject query = new BasicDBObject();
        if (StringUtils.isNotNull((Object)filter)) {
            query = this.mongodbUtils.changeCondition(filter);
        }
        query.put((Object)"is_active", (Object)"Y");
        query.put((Object)"corp_code", (Object)corp_code);
        query.put((Object)"group_type", (Object)group_type);
        System.out.println(query + "******************************");
        BasicDBObject sort = new BasicDBObject("created_date", (Object)-1);
        JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, sort, "def_group_activity");
        JSONArray list = jsonObject.getJSONArray("list");
        List newArrayList = JSONObject.parseArray((String)list.toJSONString(), GroupActivity.class);
        String currert = TimeUtils.getCurrentTimeInString();
        if (!ObjectUtils.isEmpty((Object)newArrayList)) {
            for (GroupActivity a : newArrayList) {
                if (currert.compareTo(a.getPre_heat_time()) < 0) {
                    a.setStatus_show("\u672a\u5f00\u59cb");
                } else if (currert.compareTo(a.getPre_heat_time()) >= 0 && currert.compareTo(a.getBegin_time()) < 0) {
                    a.setStatus_show("\u9884\u70ed\u4e2d");
                } else if (currert.compareTo(a.getBegin_time()) > 0 && currert.compareTo(a.getEnd_time()) <= 0) {
                    a.setStatus_show("\u8fdb\u884c\u4e2d");
                } else if (currert.compareTo(a.getEnd_time()) > 0) {
                    a.setStatus_show("\u5df2\u7ed3\u675f");
                }
                String head_img = a.getImage();
                if (StringUtils.isNotNull((Object)head_img)) {
                    String authUrl = this.aliCDNUrlAuth.getAuthUrl(head_img);
                    a.setImage(authUrl);
                }
                String group_activity_id = a.getGroup_activity_id();
                Query queryCount = new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_id").is((Object)group_activity_id));
                long count = 0L;
                count = this.mongoTemplate.count(queryCount, GroupActivityGoods.class);
                a.setProduct_count(String.valueOf(count));
            }
        }
        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)newArrayList));
        jsonObject.put("list", (Object)array);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
    }

    public DataResponse queryActivityGoodsByPage(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        log.info("\u6d3b\u52a8\u5546\u54c1\u5206\u9875\u5165\u53c2:{}", (Object)data);
        String rel_group_activity_id = data.getString("rel_group_activity_id");
        Integer page_num = data.getInteger("page_num");
        Integer page_size = data.getInteger("page_size");
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        JSONArray filter = data.getJSONArray("filter");
        BasicDBObject query = new BasicDBObject();
        if (StringUtils.isNotNull((Object)filter)) {
            query = this.mongodbUtils.changeCondition(filter);
        }
        query.put((Object)"is_active", (Object)"Y");
        query.put((Object)"corp_code", (Object)corp_code);
        query.put((Object)"rel_group_activity_id", (Object)rel_group_activity_id);
        System.out.println(query + "******************************");
        BasicDBObject sort = new BasicDBObject("created_date", (Object)-1);
        JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, sort, "def_group_activity_goods");
        JSONArray list = jsonObject.getJSONArray("list");
        JSONArray newList = new JSONArray();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (int i = 0; i < list.size(); ++i) {
                JSONObject good = list.getJSONObject(i);
                String product_id = good.getString("product_id");
                Query queryOneProduct = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(product_id)).and("on_sale").is((Object)1).and("is_active").is((Object)"Y"));
                queryOneProduct.fields().include("first_image_url").include("product_name").include("original_price").include("product_price").include("product_id");
                Product one = (Product)this.mongoTemplate.findOne(queryOneProduct, Product.class);
                if (one != null) {
                    if (StringUtils.isNotNull((Object)one.getFirst_image_url())) {
                        String authUrl = this.aliCDNUrlAuth.getAuthUrl(one.getFirst_image_url());
                        good.put("first_image_url", (Object)authUrl);
                    }
                    good.put("product_name", (Object)one.getProduct_name());
                    good.put("original_price", (Object)one.getOriginal_price());
                    good.put("product_price", (Object)one.getProduct_price());
                }
                newList.add((Object)good);
            }
        }
        log.info("\u6d3b\u52a8\u5546\u54c1\u5206\u9875\u8fd4\u53c2:{}", (Object)list.size());
        jsonObject.put("list", (Object)newList);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
    }

    public DataResponse queryOneGoodSkuPrice(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        log.info("\u5546\u54c1\u89c4\u683c\u53ca\u4ef7\u683c\u67e5\u8be2\u5165\u53c2:{}", (Object)data);
        String rel_group_activity_goods_id = data.getString("rel_group_activity_goods_id");
        String product_id = data.getString("product_id");
        Query queryAllSkus = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y").and("corp_code").is((Object)corp_code));
        List skuList = this.mongoTemplate.find(queryAllSkus, Sku.class);
        if (!ObjectUtils.isEmpty((Object)skuList)) {
            for (Sku s : skuList) {
                s.setOriginal_price(null);
                s.setCost_price(null);
                s.setCode(s.get_id().toString());
                Double price = s.getPrice();
                JSONArray spec_array = s.getSpec_array();
                if (CollectionUtils.isEmpty((Collection)spec_array)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < spec_array.size(); ++j) {
                    JSONObject object = spec_array.getJSONObject(j);
                    String spec_id = object.getString("spec_id");
                    String spec_item_id = object.getString("spec_item_id");
                    Query query3 = new Query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                    Spec spec = (Spec)this.mongoTemplate.findOne(query3, Spec.class);
                    String specName = spec.getName();
                    Query query4 = new Query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(query4, SpecItem.class);
                    String specItemName = specItem.getName();
                    stringBuilder.append(specName);
                    stringBuilder.append(":");
                    stringBuilder.append(specItemName);
                    stringBuilder.append(",");
                }
                String substring = "";
                if (stringBuilder.length() > 0) {
                    substring = stringBuilder.substring(0, stringBuilder.length() - 1);
                }
                s.setDescription(substring);
            }
            List good_skus = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_goods_id").is((Object)rel_group_activity_goods_id)), GroupActivityGoodsSku.class);
            if (!ObjectUtils.isEmpty((Object)good_skus)) {
                for (Sku s : skuList) {
                    for (GroupActivityGoodsSku sku : good_skus) {
                        if (!s.get_id().toString().equals(sku.getSku_id())) continue;
                        s.setOriginal_price(sku.getGroup_price());
                        s.setCost_price(sku.getGroup_leader_price());
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)skuList);
        log.info("\u5546\u54c1\u89c4\u683c\u53ca\u4ef7\u683c\u67e5\u8be2\u4e2a\u6570:" + skuList.size());
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
    }

    public DataResponse queryOneGoodSkuPriceV2(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        log.info("\u5546\u54c1\u89c4\u683c\u53ca\u4ef7\u683c\u67e5\u8be2\u5165\u53c2:{}", (Object)data);
        JSONArray rel_group_activity_goods_ids = data.getJSONArray("rel_group_activity_goods_id");
        JSONArray product_ids = data.getJSONArray("product_id");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        if (!ObjectUtils.isEmpty((Object)product_ids)) {
            for (int i = 0; i < product_ids.size(); ++i) {
                String rel_group_activity_goods_id = rel_group_activity_goods_ids.getString(i);
                String product_id = product_ids.getString(i);
                Query queryAllSkus = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)product_id).and("is_active").is((Object)"Y").and("corp_code").is((Object)corp_code));
                List skuList = this.mongoTemplate.find(queryAllSkus, Sku.class);
                if (!ObjectUtils.isEmpty((Object)skuList)) {
                    for (Sku s : skuList) {
                        s.setOriginal_price(null);
                        s.setCost_price(null);
                        s.setCode(s.get_id().toString());
                        Double price = s.getPrice();
                        JSONArray spec_array = s.getSpec_array();
                        if (CollectionUtils.isEmpty((Collection)spec_array)) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int j = 0; j < spec_array.size(); ++j) {
                            JSONObject object = spec_array.getJSONObject(j);
                            String spec_id = object.getString("spec_id");
                            String spec_item_id = object.getString("spec_item_id");
                            Query query3 = new Query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                            Spec spec = (Spec)this.mongoTemplate.findOne(query3, Spec.class);
                            String specName = spec.getName();
                            Query query4 = new Query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
                            SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(query4, SpecItem.class);
                            String specItemName = specItem.getName();
                            stringBuilder.append(specName);
                            stringBuilder.append(":");
                            stringBuilder.append(specItemName);
                            stringBuilder.append(",");
                        }
                        String substring = "";
                        if (stringBuilder.length() > 0) {
                            substring = stringBuilder.substring(0, stringBuilder.length() - 1);
                        }
                        s.setDescription(substring);
                    }
                    List good_skus = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_goods_id").is((Object)rel_group_activity_goods_id)), GroupActivityGoodsSku.class);
                    if (!ObjectUtils.isEmpty((Object)good_skus)) {
                        for (Sku s : skuList) {
                            for (GroupActivityGoodsSku sku : good_skus) {
                                if (!s.get_id().toString().equals(sku.getSku_id())) continue;
                                s.setOriginal_price(sku.getGroup_price());
                                s.setCost_price(sku.getGroup_leader_price());
                            }
                        }
                    }
                    jsonObject = new JSONObject();
                    jsonObject.put("list", (Object)skuList);
                    jsonObject.put("product_id", (Object)product_id);
                }
                jsonArray.add(jsonObject);
            }
        }
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("resp", (Object)jsonArray);
        log.info("\u5546\u54c1\u89c4\u683c\u53ca\u4ef7\u683c\u67e5\u8be2jsonArray\u4e2a\u6570:" + jsonArray.size());
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject2);
    }

    public DataResponse endActivity(DataRequest dataRequest) {
        Query queryBody;
        List bodies;
        Query querySku;
        WriteResult skuResult;
        Query queryActivityGoods;
        WriteResult goodsResult;
        String faliEnable = this.mongodbUtils.queryActivityMessEnable("\u62fc\u56e2\u5931\u8d25\u901a\u77e5");
        String succEnable = this.mongodbUtils.queryActivityMessEnable("\u62fc\u56e2\u6210\u529f\u901a\u77e5");
        log.info("\u7ed3\u675f\u6d3b\u52a8\u67e5\u8be2\u62fc\u56e2\u6d88\u606f\u662f\u5426\u542f\u7528fali:{},succ:{}", (Object)faliEnable, (Object)succEnable);
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        log.info("\u7ed3\u675f\u6d3b\u52a8\u5165\u53c2:{}", (Object)data);
        String group_activity_id = data.getString("group_activity_id");
        String current = TimeUtils.getCurrentTimeInString();
        Query queryActivity = new Query((CriteriaDefinition)Criteria.where((String)"group_activity_id").is((Object)group_activity_id));
        Update updateEndTime = new Update().set("end_time", (Object)current).set("modifier_id", (Object)user_id).set("modified_date", (Object)current);
        WriteResult activityResult = this.mongoTemplate.updateMulti(queryActivity, updateEndTime, GroupActivity.class);
        if (activityResult.getN() > 0 && (goodsResult = this.mongoTemplate.updateMulti(queryActivityGoods = new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_id").is((Object)group_activity_id)), updateEndTime, GroupActivityGoods.class)).getN() > 0 && (skuResult = this.mongoTemplate.updateMulti(querySku = new Query((CriteriaDefinition)Criteria.where((String)"rel_activity_id").is((Object)group_activity_id)), updateEndTime, GroupActivityGoodsSku.class)).getN() > 0 && !ObjectUtils.isEmpty((Object)(bodies = this.mongoTemplate.find(queryBody = new Query((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y").and("rel_activity_id").is((Object)group_activity_id)), GroupActivityBody.class)))) {
            for (GroupActivityBody body : bodies) {
                List members;
                WriteResult bodyResult;
                if (!"in_group".equals(body.getGroup_status())) continue;
                Query queryOneBody = new Query((CriteriaDefinition)Criteria.where((String)"group_activity_body_id").is((Object)body.getGroup_activity_body_id()));
                Update updateStatus = new Update().set("group_status", (Object)"fail_group").set("modified_date", (Object)current).set("reason_group_status", (Object)"activity_over_hand");
                Query queryGoodLeast = new Query((CriteriaDefinition)Criteria.where((String)"product_id").is((Object)body.getProduct_id()).and("is_active").is((Object)"Y").and("rel_group_activity_id").is((Object)group_activity_id));
                GroupActivityGoods one = (GroupActivityGoods)this.mongoTemplate.findOne(queryGoodLeast, GroupActivityGoods.class);
                Query queryOneMem = new Query((CriteriaDefinition)Criteria.where((String)"rel_body_id").is((Object)body.getGroup_activity_body_id()));
                long memCount = 0L;
                memCount = this.mongoTemplate.count(queryOneMem, GroupActivityMember.class);
                int[] flag = new int[]{1};
                if (one != null && (long)one.getLeast_group_num().intValue() <= memCount) {
                    updateStatus.set("group_status", (Object)"success_group");
                    flag[0] = 2;
                }
                if ((bodyResult = this.mongoTemplate.updateMulti(queryOneBody, updateStatus, GroupActivityBody.class)).getN() <= 0 || ObjectUtils.isEmpty((Object)(members = this.mongoTemplate.find(queryOneMem, GroupActivityMember.class)))) continue;
                for (GroupActivityMember mem : members) {
                    Query queryOneMemb;
                    WriteResult memResult;
                    if (!"in_group".equals(mem.getGroup_status()) || (memResult = this.mongoTemplate.updateMulti(queryOneMemb = new Query((CriteriaDefinition)Criteria.where((String)"group_activity_member_id").is((Object)mem.getGroup_activity_member_id())), updateStatus, GroupActivityMember.class)).getN() <= 0 || !StringUtils.isNotNull((Object)mem.getOrder_id())) continue;
                    1 member = new /* Unavailable Anonymous Inner Class!! */;
                    Thread thread = new Thread((Runnable)member);
                    thread.start();
                }
            }
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setMsg("\u6d3b\u52a8\u7ed3\u675f\u6210\u529f");
    }

    public DataResponse deleActivity(DataRequest dataRequest) {
        Query queryActivityGoods;
        WriteResult goodResult;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        log.info("\u5220\u9664\u6d3b\u52a8\u5165\u53c2:{}", (Object)data);
        String group_activity_id = data.getString("group_activity_id");
        Query queryActivity = new Query((CriteriaDefinition)Criteria.where((String)"group_activity_id").is((Object)group_activity_id));
        WriteResult activityResult = this.mongoTemplate.remove(queryActivity, GroupActivity.class);
        if (activityResult.getN() > 0 && (goodResult = this.mongoTemplate.remove(queryActivityGoods = new Query((CriteriaDefinition)Criteria.where((String)"rel_group_activity_id").is((Object)group_activity_id)), GroupActivityGoods.class)).getN() > 0) {
            Query querySku = new Query((CriteriaDefinition)Criteria.where((String)"rel_activity_id").is((Object)group_activity_id));
            WriteResult writeResult = this.mongoTemplate.remove(querySku, GroupActivityGoodsSku.class);
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u6d3b\u52a8\u6210\u529f");
    }

    public DataResponse queryActivityBaseInfo(DataRequest dataRequest) {
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        log.info("\u67e5\u8be2\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u5165\u53c2data:{}", (Object)data);
        String group_activity_id = data.getString("group_activity_id");
        GroupActivity oneActivity = (GroupActivity)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"group_activity_id").is((Object)group_activity_id)), GroupActivity.class);
        if (oneActivity != null) {
            JSONArray store_ids;
            String head_img = oneActivity.getImage();
            if (StringUtils.isNotNull((Object)head_img)) {
                String authUrl = this.aliCDNUrlAuth.getAuthUrl(head_img);
                oneActivity.setImage(authUrl);
            }
            if ((store_ids = oneActivity.getStore_ids()) != null && store_ids.size() > 0) {
                Query queryStores = new Query((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y").and("corp_code").is((Object)corp_code).and("store_id").in((Collection)store_ids));
                queryStores.fields().include("_id").include("store_id").include("store_name");
                List stores = this.mongoTemplate.find(queryStores, Store.class);
                oneActivity.setStores_show(stores);
            }
        }
        log.info("\u67e5\u8be2\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u8fd4\u53c2oneActivity:{}", (Object)oneActivity);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("oneActivity", (Object)oneActivity);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
    }

    public DataResponse testWeiXinMessage(DataRequest dataRequest) {
        log.info("---------\u62fc\u56e2\u6d4b\u8bd5----------\u5f00\u53d1\u73af\u5883-------");
        DataRequest dataRequestFailSuc = new DataRequest();
        JSONObject jsonData = new JSONObject();
        jsonData.put("corp_code", (Object)"C10022");
        jsonData.put("vip_id", (Object)"5f602c74ae1c0a00015d2cf0");
        jsonData.put("product_name", (Object)"\u5546\u54c1\u540d\u5b57123");
        jsonData.put("group_price", (Object)10);
        jsonData.put("order_id", (Object)"5f22c2597e1cc20001cb832e");
        jsonData.put("refund_pay", (Object)22);
        dataRequestFailSuc.setData(jsonData);
        log.info("---------\u62fc\u56e2\u6d4b\u8bd5----------\u5f00\u53d1\u73af\u5883-------,memId:{},\u5165\u53c2:data{}-------", (Object)"memId", (Object)jsonData);
        DataResponse respFail = this.wechatAgent.callRest(dataRequestFailSuc, "/group/activity/failSendMess");
        return respFail;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

