/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kr.weitao.activity.service.DiscountActivityService;
import kr.weitao.activity.service.impl.ActivityServiceImpl;
import kr.weitao.activity.utils.ScheduleUtils;
import kr.weitao.business.entity.activity.DiscountActivity;
import kr.weitao.business.entity.activity.RelDiscountActivity;
import kr.weitao.business.entity.product.Spec;
import kr.weitao.business.entity.product.SpecItem;
import kr.weitao.common.exception.ServiceException;
import kr.weitao.common.util.AliCDNUrlAuth;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.bson.types.ObjectId;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class DiscountActivityServiceImpl
extends ActivityServiceImpl
implements DiscountActivityService {
    private static ConcurrentHashMap paramMap = new ConcurrentHashMap(16);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AliCDNUrlAuth aliCDNUrlAuth;
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;

    public DataResponse addDisActivity(DataRequest dataRequest) {
        String endTime;
        JSONObject requestData = dataRequest.getData();
        String status = "0";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String currentDate = simpleDateFormat.format(date);
        String beginTime = requestData.getString("begin_time");
        if (beginTime.compareTo(endTime = requestData.getString("end_time")) >= 0) {
            throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        if (beginTime.compareTo(currentDate) <= 0) {
            beginTime = currentDate;
            status = "1";
        }
        JSONArray productArray = new JSONArray();
        StringBuilder stringBuilder = new StringBuilder();
        JSONArray productInfo = requestData.getJSONArray("productInfo");
        for (int i = 0; i < productInfo.size(); ++i) {
            JSONObject productObj = productInfo.getJSONObject(i);
            String pid = productObj.getString("product_id");
            stringBuilder.append(pid).append(",");
            productArray.add((Object)pid);
        }
        String productIds = stringBuilder.substring(0, stringBuilder.length() - 1);
        JSONObject operationObj = new JSONObject();
        operationObj.put("activity_type", (Object)"DIS");
        operationObj.put("product_id", (Object)productIds);
        this.operationalActivitiesByAdd(this.mongoTemplate, operationObj);
        String activityId = "DIS" + System.currentTimeMillis();
        DiscountActivity discountActivity = DiscountActivity.builder()._id(activityId).name(requestData.getString("name")).status(status).begin_time(requestData.getString("begin_time")).end_time(requestData.getString("end_time")).lable(requestData.getString("lable")).limitBuy(requestData.getJSONObject("limit_buy")).cancleOrderTime(requestData.getInteger("cancle_order_time").intValue()).remark(requestData.getString("remark")).product_id(productArray).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNull((Object)requestData.getString("is_active")) ? "Y" : requestData.getString("is_active")).creater_id(requestData.getString("user_id")).created_date(currentDate).modifier_id(requestData.getString("user_id")).modified_date(currentDate).store_name("\u5c0f\u7a0b\u5e8f").store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).count_down(requestData.getString("count_down")).count_down_hour(requestData.getInteger("count_down_hour")).build();
        this.mongoTemplate.save((Object)discountActivity);
        for (int i = 0; i < productInfo.size(); ++i) {
            JSONObject productObj = productInfo.getJSONObject(i);
            String pid = productObj.getString("product_id");
            JSONArray skuArray = productObj.getJSONArray("skuArray");
            for (int j = 0; j < skuArray.size(); ++j) {
                JSONObject skuObj = skuArray.getJSONObject(j);
                RelDiscountActivity relDiscountActivity = RelDiscountActivity.builder().activity_id(activityId).product_id(pid).sku_id(skuObj.getString("sku_id")).seckill_price(skuObj.getDouble("seckill_price")).reduce_money(skuObj.getDouble("reduce_money")).sale(skuObj.getString("sale")).modified_date(currentDate).build();
                this.mongoTemplate.save((Object)relDiscountActivity);
            }
        }
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u65b0\u589e\u9650\u65f6\u6298\u6263\u6210\u529f!");
    }

    public DataResponse modifyDisActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        DBObject dbObject = this.mongoTemplate.getCollection("def_discount_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        if (dbObject == null) {
            throw new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        String status = dbObject.get("status").toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentDate = simpleDateFormat.format(new Date());
        String beginTime = requestData.getString("begin_time");
        String endTime = requestData.getString("end_time");
        if (endTime.compareTo(currentDate) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        this.judgeActivityStatus(status);
        if (status.equals("0")) {
            if (beginTime.compareTo(endTime) >= 0) {
                throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (beginTime.compareTo(currentDate) <= 0) {
                beginTime = currentDate;
                status = "1";
            }
        } else if (status.equals("2")) {
            beginTime = dbObject.get("begin_time").toString();
            endTime = dbObject.get("end_time").toString();
        }
        JSONArray productArray = new JSONArray();
        StringBuilder stringBuilder = new StringBuilder();
        JSONArray productInfo = requestData.getJSONArray("productInfo");
        for (int i = 0; i < productInfo.size(); ++i) {
            JSONObject productObj = productInfo.getJSONObject(i);
            String pid = productObj.getString("product_id");
            stringBuilder.append(pid).append(",");
            productArray.add((Object)pid);
        }
        String productIds = stringBuilder.substring(0, stringBuilder.length() - 1);
        JSONObject operationObj = new JSONObject();
        operationObj.put("activity_type", (Object)"DIS");
        operationObj.put("activity_id", (Object)activityId);
        operationObj.put("product_id", (Object)productIds);
        this.operationalActivitiesByModify(this.mongoTemplate, operationObj);
        DiscountActivity discountActivity = DiscountActivity.builder().name(requestData.getString("name")).status(status).begin_time(requestData.getString("begin_time")).end_time(requestData.getString("end_time")).lable(requestData.getString("lable")).limitBuy(requestData.getJSONObject("limit_buy")).cancleOrderTime(requestData.getInteger("cancle_order_time").intValue()).remark(requestData.getString("remark")).product_id(productArray).user_id(requestData.getString("user_id")).corp_code(requestData.getString("corp_code")).is_active(StringUtils.isNull((Object)requestData.getString("is_active")) ? "Y" : requestData.getString("is_active")).modifier_id(requestData.getString("user_id")).modified_date(currentDate).store_ids(requestData.getJSONArray("store_ids")).store_flag(requestData.getString("store_flag")).count_down(requestData.getString("count_down")).count_down_hour(requestData.getInteger("count_down_hour")).build();
        DBCollection activityDbCollection = this.mongoTemplate.getCollection("def_discount_activity");
        DBObject activityUpdateObj = (DBObject)JSON.parse((String)JSONObject.toJSONString((Object)discountActivity));
        BasicDBObject activityDbObject = new BasicDBObject();
        activityDbObject.put((Object)"$set", (Object)activityUpdateObj);
        activityDbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)activityDbObject, false, false);
        this.mongoTemplate.getCollection("rel_discount_activity").remove((DBObject)new BasicDBObject("activity_id", (Object)activityId));
        for (int i = 0; i < productInfo.size(); ++i) {
            JSONObject productObj = productInfo.getJSONObject(i);
            String pid = productObj.getString("product_id");
            JSONArray skuArray = productObj.getJSONArray("skuArray");
            for (int j = 0; j < skuArray.size(); ++j) {
                JSONObject skuObj = skuArray.getJSONObject(j);
                RelDiscountActivity relDiscountActivity = RelDiscountActivity.builder().activity_id(activityId).product_id(pid).sku_id(skuObj.getString("sku_id")).seckill_price(skuObj.getDouble("seckill_price")).reduce_money(skuObj.getDouble("reduce_money")).sale(skuObj.getString("sale")).modified_date(currentDate).build();
                this.mongoTemplate.save((Object)relDiscountActivity);
            }
        }
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
        ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
        this.createActivityScheduJob(this.scheduler, status, activityId, simpleDateFormat, beginTime, endTime);
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u4fee\u6539\u9650\u65f6\u6298\u6263\u6d3b\u52a8\u6210\u529f!");
    }

    public DataResponse deleteDisActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBCollection dbCollection = this.mongoTemplate.getCollection("def_discount_activity");
        DBObject dbObject = dbCollection.findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            String status = obj.get("status").toString();
            if ("3".equals(status) || "0".equals(status)) {
                BasicDBObject updateActivity = new BasicDBObject();
                updateActivity.put((Object)"$set", (Object)new BasicDBObject("is_active", (Object)"N"));
                dbCollection.update((DBObject)new BasicDBObject("_id", (Object)activityId), (DBObject)updateActivity, false, false);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("START" + activityId), (String)activityId);
                ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)("END" + activityId), (String)activityId);
                return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u79d2\u6740\u6d3b\u52a8\u6210\u529f!");
            }
            throw new ServiceException("\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664!");
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728!"));
    }

    public DataResponse listDisActivity(DataRequest dataRequest) {
        return this.baseListActivitys(dataRequest, this.mongoTemplate, "def_discount_activity", "def_user");
    }

    public DataResponse getActivity(DataRequest dataRequest) {
        JSONObject requestData = dataRequest.getData();
        String activityId = requestData.getString("id");
        if (StringUtils.isNull((Object)activityId)) {
            throw new ServiceException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DBObject dbObject = this.mongoTemplate.getCollection("def_discount_activity").findOne((DBObject)new BasicDBObject("_id", (Object)activityId));
        return Optional.ofNullable(dbObject).map(obj -> {
            DBObject modifyUserInfo;
            DBObject createUserInfo;
            String id = obj.get("_id").toString();
            obj.put("id", (Object)id);
            obj.removeField("_id");
            Map map = obj.toMap();
            if (StringUtils.isNotNull(map.get("creater_id")) && (createUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("creater_id").toString())))) != null) {
                map.put("creater_name", createUserInfo.get("user_name"));
            }
            if (StringUtils.isNotNull(map.get("modifier_id")) && (modifyUserInfo = this.mongoTemplate.getCollection("def_user").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(map.get("modifier_id").toString())))) != null) {
                map.put("modifier_name", modifyUserInfo.get("user_name"));
            }
            JSONArray productInfo = new JSONArray();
            JSONArray productIds = JSONArray.parseArray((String)JSONObject.toJSONString(map.get("product_id")));
            for (int i = 0; i < productIds.size(); ++i) {
                String pid = productIds.get(i).toString();
                JSONObject pObj = new JSONObject();
                DBCursor skuInfoArray = this.mongoTemplate.getCollection("def_discount_activity").find((DBObject)new BasicDBObject("activity_id", (Object)id).append("product_id", (Object)pid));
                List skuList = this.handleDbCursor(skuInfoArray);
                pObj.put("product_id", (Object)pid);
                pObj.put("skuArray", (Object)skuList);
                pObj = this.handleProductInfo(pObj);
                productInfo.add((Object)pObj);
            }
            map.put("productInfo", productInfo);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityInfo", (Object)map);
            return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u67e5\u8be2\u6210\u529f!").setData(jsonObject);
        }).orElseThrow(() -> new ServiceException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01"));
    }

    private JSONObject handleProductInfo(JSONObject productInfo) {
        String productId = productInfo.getString("product_id");
        DBObject productObj = this.mongoTemplate.getCollection("def_product").findOne((DBObject)new BasicDBObject("product_id", (Object)productId));
        if (productObj != null) {
            productObj.put("id", (Object)productObj.get("_id").toString());
            productObj.removeField("_id");
            if (StringUtils.isNotNull((Object)productObj.get("first_image_url"))) {
                productObj.put("first_image_url", (Object)this.aliCDNUrlAuth.getAuthURLA(productObj.get("first_image_url").toString()));
            }
            productInfo.put("productInfo", (Object)productObj);
            JSONArray skuArray = this.getSkuListByProductId(this.mongoTemplate, productId);
            productInfo.put("skuInfo", (Object)skuArray);
        }
        JSONArray skuJsonArray = new JSONArray();
        JSONArray skuArray = productInfo.getJSONArray("skuArray");
        for (int i = 0; i < skuArray.size(); ++i) {
            JSONObject skuObj = skuArray.getJSONObject(i);
            DBObject skuDbObj = this.mongoTemplate.getCollection("def_sku").findOne((DBObject)new BasicDBObject("_id", (Object)new ObjectId(skuObj.getString("sku_id"))));
            if (skuDbObj != null) {
                String skuId = skuDbObj.get("_id").toString();
                skuDbObj.put("id", (Object)skuId);
                skuDbObj.removeField("_id");
                JSONArray specArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)skuDbObj.get("spec_array")));
                for (int l = 0; l < specArray.size(); ++l) {
                    JSONObject specOne = specArray.getJSONObject(l);
                    String spec_id = specOne.getString("spec_id");
                    Spec spec = (Spec)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_id").is((Object)spec_id)), Spec.class);
                    if (null != spec) {
                        specOne.put("spec_name", (Object)spec.getName());
                    }
                    String spec_item_id = specOne.getString("spec_item_id");
                    SpecItem specItem = (SpecItem)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"spec_item_id").is((Object)spec_item_id)), SpecItem.class);
                    if (null == specItem) continue;
                    specOne.put("spec_item_name", (Object)specItem.getName());
                }
                skuDbObj.put("spec_array", (Object)specArray);
                skuObj.put("skuInfo", (Object)skuDbObj);
                skuObj.put("lastStock", (Object)Integer.parseInt(this.getSkuLastStock(this.mongoTemplate, skuId, productId)));
            }
            skuJsonArray.add((Object)skuObj);
        }
        productInfo.put("skuArray", (Object)skuJsonArray);
        return productInfo;
    }

    public DataResponse pauseActivity(DataRequest dataRequest) {
        return this.basePauseActivity(dataRequest, this.mongoTemplate, "def_discount_activity");
    }

    public DataResponse recoveryActivity(DataRequest dataRequest) {
        return this.baseRecoveryActivity(dataRequest, this.mongoTemplate, "def_discount_activity");
    }

    public DataResponse endActivity(DataRequest dataRequest) {
        this.baseEndActivity(dataRequest, this.scheduler, this.mongoTemplate, "def_discount_activity");
        this.unLockParamWithEndActivity(dataRequest.getData().getString("id"));
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u6267\u884c\u6210\u529f!");
    }

    private void unLockParamWithEndActivity(String activityId) {
        DBCursor dbCursor = this.mongoTemplate.getCollection("rel_discount_activity").find((DBObject)new BasicDBObject("activity_id", (Object)activityId));
        while (dbCursor.hasNext()) {
            DBObject dbObject = dbCursor.next();
            paramMap.remove(activityId + dbObject.get("sku_id"));
        }
    }
}

