/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.activity.service.AwardActivityService;
import kr.weitao.activity.utils.MongodbUtils;
import kr.weitao.activity.utils.TimeBucket;
import kr.weitao.business.common.agent.WechatAgent;
import kr.weitao.business.entity.Corp;
import kr.weitao.business.entity.LogMpCode;
import kr.weitao.business.entity.Store;
import kr.weitao.business.entity.activity.AwardActivity;
import kr.weitao.business.entity.activity.Index_award;
import kr.weitao.business.entity.activity.LogAward;
import kr.weitao.common.exception.ServiceException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.bson.types.ObjectId;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AwardActivityImpl
implements AwardActivityService {
    private static final Logger log = LoggerFactory.getLogger(AwardActivityImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongodbUtils mongodbUtils;
    @Autowired
    WechatAgent wechatAgent;
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;

    public DataResponse addAwardInfo(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        String start_time = data.getString("start_time");
        String end_time = data.getString("end_time");
        String status = "1";
        Integer award_count = data.getInteger("award_count");
        if (award_count <= 0) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u62bd\u5956\u6b21\u6570\uff01");
        }
        String activity_id = data.getString("activity_id");
        if (StringUtils.isNotNull((Object)activity_id)) {
            long index_award_count = this.mongoTemplate.count(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id).and("is_active").is((Object)"Y")), Index_award.class);
            if (index_award_count <= 0L) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8bf7\u6dfb\u52a0\u5956\u54c1\u4fe1\u606f\uff01");
            }
            if (index_award_count > 6L) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5956\u54c1\u6570\u91cf\u4e0d\u5f97\u8d85\u8fc76\u4e2a\uff01");
            }
        }
        String id = "";
        if (data != null) {
            JSONArray store_array;
            AwardActivity awardActivity = (AwardActivity)JSONObject.parseObject((String)data.toString(), AwardActivity.class);
            if (start_time.compareTo(TimeUtils.getCurrentTimeInString()) <= 0) {
                start_time = TimeUtils.getCurrentTimeInString();
                awardActivity.setStart_time(start_time);
                status = "2";
            }
            if (CollectionUtils.isEmpty((Collection)(store_array = data.getJSONArray("store_array")))) {
                if (this.timeOption(corp_code, start_time, end_time, null, null)) {
                    return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8be5\u65f6\u95f4\u6bb5\u5185\u5df2\u6709\u62bd\u5956\u6d3b\u52a8\uff01");
                }
            } else if (!CollectionUtils.isEmpty((Collection)store_array)) {
                for (int i = 0; i < store_array.size(); ++i) {
                    if (!this.timeOption(corp_code, start_time, end_time, null, store_array.getString(i))) continue;
                    return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8be5\u65f6\u95f4\u6bb5\u5185\u5df2\u6709\u62bd\u5956\u6d3b\u52a8\uff01");
                }
            }
            awardActivity.setCorp_code(corp_code);
            awardActivity.setCreated_date(TimeUtils.getCurrentTimeInString());
            awardActivity.setCreator_id(user_id);
            awardActivity.setModified_date(TimeUtils.getCurrentTimeInString());
            awardActivity.setModifier_id(user_id);
            awardActivity.setAward_status(status);
            awardActivity.setIs_active("Y");
            awardActivity.setIs_suspend("N");
            awardActivity.setIs_finish("N");
            this.mongoTemplate.save((Object)awardActivity);
            id = awardActivity.getAward_activity_id();
        }
        JSONObject object = new JSONObject();
        object.put("id", (Object)id);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object).setMsg("\u62bd\u5956\u6d3b\u52a8\u521b\u5efa\u6210\u529f!");
    }

    private boolean timeOption(String corp_code, String start_time, String end_time, String id, String store_id) {
        if (start_time.compareTo(end_time) >= 0) {
            throw new ServiceException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (end_time.compareTo(TimeUtils.getCurrentTimeInString()) <= 0) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        BasicDBObject query_award_activity = new BasicDBObject();
        query_award_activity.put((Object)"corp_code", (Object)corp_code);
        query_award_activity.put((Object)"end_time", (Object)new BasicDBObject("$gte", (Object)start_time));
        query_award_activity.put((Object)"is_finish", (Object)new BasicDBObject("$ne", (Object)"Y"));
        if (id != null) {
            query_award_activity.put((Object)"award_activity_id", (Object)new BasicDBObject("$ne", (Object)id));
        }
        BasicDBList dbList = new BasicDBList();
        dbList.add((Object)query_award_activity);
        BasicDBList list = new BasicDBList();
        if (StringUtils.isNotNull((Object)store_id)) {
            list.add((Object)new BasicDBObject("store_array", (Object)new BasicDBObject("$eq", (Object)store_id)));
            list.add((Object)new BasicDBObject("store_array", (Object)new BasicDBObject("$eq", (Object)new JSONArray[0])));
            dbList.add((Object)new BasicDBObject("$or", (Object)list));
        }
        BasicDBObject include_query = new BasicDBObject("$and", (Object)dbList);
        log.info("+++++++++\u91cd\u53e0\u65f6\u95f4\uff1a{}", (Object)query_award_activity.toMap());
        DBCursor cursor_activity = this.mongoTemplate.getCollection("def_award_activity").find((DBObject)include_query);
        while (cursor_activity.hasNext()) {
            Map map = cursor_activity.next().toMap();
            TimeBucket[] buckets = new TimeBucket[]{new TimeBucket(map.get("start_time").toString(), map.get("end_time").toString()), new TimeBucket(start_time, end_time)};
            TimeBucket union = TimeBucket.union((TimeBucket[])buckets);
            if (null == union) continue;
            return true;
        }
        return false;
    }

    public DataResponse modAwardInfo(HttpServletRequest request) {
        String activity_id;
        JSONArray store_array;
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        log.info("++++++\u4f20\u53c2\uff1a" + data.toString());
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        String status = "1";
        String start_time = data.getString("start_time");
        String end_time = data.getString("end_time");
        if (start_time.compareTo(TimeUtils.getCurrentTimeInString()) <= 0) {
            start_time = TimeUtils.getCurrentTimeInString();
            data.put("start_time", (Object)start_time);
            status = "2";
        }
        if (CollectionUtils.isEmpty((Collection)(store_array = data.getJSONArray("store_array")))) {
            if (this.timeOption(corp_code, start_time, end_time, id, null)) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8be5\u65f6\u95f4\u6bb5\u5185\u5df2\u6709\u62bd\u5956\u6d3b\u52a8\uff01");
            }
        } else if (!CollectionUtils.isEmpty((Collection)store_array)) {
            for (int i = 0; i < store_array.size(); ++i) {
                if (!this.timeOption(corp_code, start_time, end_time, id, store_array.getString(i))) continue;
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8be5\u65f6\u95f4\u6bb5\u5185\u5df2\u6709\u62bd\u5956\u6d3b\u52a8\uff01");
            }
        }
        if (StringUtils.isNotNull((Object)(activity_id = data.getString("activity_id")))) {
            long award_count = this.mongoTemplate.count(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id)), Index_award.class);
            if (award_count <= 0L) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8bf7\u6dfb\u52a0\u5956\u54c1\u4fe1\u606f\uff01");
            }
            if (award_count > 12L) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5956\u54c1\u6570\u91cf\u4e0d\u5f97\u8d85\u8fc712\u4e2a\uff01");
            }
        }
        AwardActivity award_activity = (AwardActivity)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)id)), AwardActivity.class);
        Integer award_count = data.getInteger("award_count");
        if (award_count <= 0) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u62bd\u5956\u6b21\u6570\uff01");
        }
        if (award_count < award_activity.getAward_count()) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u62bd\u5956\u6b21\u6570\u4e0d\u5f97\u5c0f\u4e8e\u73b0\u6709\u62bd\u5956\u6b21\u6570\uff01");
        }
        Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)id).and("corp_code").is((Object)corp_code));
        Update update = new Update();
        for (String key : data.keySet()) {
            if ("_id".equals(key) || "activity_id".equals(key)) continue;
            update.set(key, data.get((Object)key));
        }
        update.set("award_status", (Object)status);
        update.set("start_time", (Object)start_time);
        update.set("modifier_id", (Object)user_id);
        update.set("modified_date", (Object)TimeUtils.getCurrentTimeInString());
        log.info("==========query\uff1a{}", (Object)query1);
        log.info("+++++++++++++update\uff1a{}", (Object)update);
        this.mongoTemplate.updateFirst(query1, update, AwardActivity.class);
        JSONObject object = new JSONObject();
        object.put("id", (Object)id);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object).setMsg("\u4fee\u6539\u6210\u529f\uff01");
    }

    public DataResponse delAwardInfo(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        JSONArray ids = data.getJSONArray("ids");
        log.info("+++++++\u5220\u9664\u6570\u636eids\uff1a" + ids);
        for (int i = 0; i < ids.size(); ++i) {
            if (!StringUtils.isNotNull((Object)ids.get(i))) continue;
            String id = ids.get(i).toString();
            AwardActivity activity = (AwardActivity)this.mongoTemplate.findById((Object)id, AwardActivity.class);
            Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)id));
            Update update = new Update();
            update.set("is_active", (Object)"N");
            log.info("++++++++++\u5220\u9664\u5956\u54c1\u5bf9\u5e94\u7684\u62bd\u5956\u8bb0\u5f55\uff1a{}", (Object)query1);
            this.mongoTemplate.updateMulti(query1, update, LogAward.class);
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)id));
            Update update1 = new Update();
            update1.set("is_active", (Object)"N");
            this.mongoTemplate.updateMulti(query, update1, AwardActivity.class);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u6210\u529f\uff01");
    }

    public DataResponse addIndexAward(HttpServletRequest request) {
        long count;
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        String activity_id = data.getString("activity_id");
        if (StringUtils.isNotNull((Object)activity_id) && (count = this.mongoTemplate.count(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id).and("is_active").is((Object)"Y")), Index_award.class)) >= 6L) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u5956\u54c1\u6570\u91cf\u4e0a\u9650\u4e0d\u5f97\u5927\u4e8e6\u4e2a");
        }
        String id = "";
        if (StringUtils.isNull((Object)activity_id)) {
            ObjectId objectId = new ObjectId();
            activity_id = objectId.toString();
        }
        if (data != null) {
            Double power;
            Double power1 = power = data.getDouble("power");
            if (power < 0.0) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u62bd\u5956\u6982\u7387\u4e0d\u80fd\u4e3a\u8d1f\uff01");
            }
            Double power_sum = 0.0;
            List index_awards = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id).and("is_active").is((Object)"Y")), Index_award.class);
            for (Index_award index_award : index_awards) {
                power_sum = power_sum + index_award.getPower();
            }
            log.info("+++++++++++\u5df2\u6dfb\u52a0\u7684\u5956\u54c1\u6982\u7387\u548c\uff1a{}", (Object)power_sum);
            power1 = power1 + power_sum;
            if (power1 > 100.0) {
                return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u603b\u5956\u54c1\u6982\u7387\u4e4b\u548c\u4e0d\u5f97\u5927\u4e8e100%\uff01");
            }
            Index_award index_award = (Index_award)JSONObject.parseObject((String)data.toString(), Index_award.class);
            index_award.setCorp_code(corp_code);
            index_award.setActivity_id(activity_id);
            index_award.setIs_active("Y");
            double power_num = power / 100.0;
            index_award.setPower_num(Double.valueOf(power_num));
            index_award.setCreated_date(TimeUtils.getCurrentTimeInString());
            index_award.setModified_date(TimeUtils.getCurrentTimeInString());
            this.mongoTemplate.save((Object)index_award);
            id = index_award.getIndex_award_id();
        }
        JSONObject object = new JSONObject();
        object.put("id", (Object)id);
        object.put("activity_id", (Object)activity_id);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object).setMsg("\u6dfb\u52a0\u5956\u54c1\u6210\u529f\uff01");
    }

    public DataResponse modIndexAward(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String corp_code = data.getString("corp_code");
        String user_id = data.getString("user_id");
        String id = data.getString("id");
        Double power = data.getDouble("power");
        String activity_id = data.getString("activity_id");
        Double power1 = power;
        if (power < 0.0) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u62bd\u5956\u6982\u7387\u4e0d\u80fd\u4e3a\u8d1f\uff01");
        }
        Double power_sum = 0.0;
        List index_awards = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"activity_id").is((Object)activity_id).and("is_active").is((Object)"Y").and("index_award_id").ne((Object)id)), Index_award.class);
        for (Index_award index_award : index_awards) {
            power_sum = power_sum + index_award.getPower();
        }
        log.info("+++++++++++\u5df2\u6dfb\u52a0\u7684\u5956\u54c1\u6982\u7387\u548c\uff1a{}", (Object)power_sum);
        power1 = power1 + power_sum;
        if (power1 > 100.0) {
            return new DataResponse().setCode("-1").setStatus(Status.FAILED).setMsg("\u603b\u5956\u54c1\u6982\u7387\u4e4b\u548c\u4e0d\u5f97\u5927\u4e8e100%\uff01");
        }
        data.put("power_num", (Object)(power / 100.0));
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"index_award_id").is((Object)id).and("corp_code").is((Object)corp_code));
        Update update = new Update();
        for (String key : data.keySet()) {
            if ("id".equals(key)) continue;
            update.set(key, data.get((Object)key));
        }
        update.set("modified_date", (Object)TimeUtils.getCurrentTimeInString());
        this.mongoTemplate.updateFirst(query, update, Index_award.class);
        JSONObject object = new JSONObject();
        object.put("id", (Object)id);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object).setMsg("\u4fee\u6539\u6210\u529f\uff01");
    }

    public DataResponse delIndexAward(DataRequest dataRequest) {
        JSONObject data = dataRequest.getData();
        JSONArray ids = data.getJSONArray("ids");
        if (ids != null) {
            this.delAward(ids);
        }
        return new DataResponse().setStatus(Status.SUCCESS).setCode("0").setMsg("\u5220\u9664\u6210\u529f\uff01");
    }

    public DataResponse selIndexAward(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest dataRequest = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = dataRequest.getData();
        Integer page_num = data.getInteger("page_num");
        Integer page_size = data.getInteger("page_size");
        JSONArray filter = data.getJSONArray("filter");
        String corp_code = data.getString("corp_code");
        String award_activity_id = data.getString("award_activity_id");
        String activity_id = data.getString("activity_id");
        BasicDBObject query = new BasicDBObject();
        if (StringUtils.isNotNull((Object)filter)) {
            query = this.mongodbUtils.changeCondition(filter);
        }
        JSONObject object = null;
        if (StringUtils.isNotNull((Object)award_activity_id) && !"".equals(award_activity_id)) {
            AwardActivity awardActivity = (AwardActivity)this.mongoTemplate.findById((Object)award_activity_id, AwardActivity.class);
            if (awardActivity != null) {
                log.info("============\u6d3b\u52a8\uff1a" + awardActivity.toString());
                query.put((Object)"activity_id", (Object)awardActivity.getActivity_id());
                query.put((Object)"corp_code", (Object)corp_code);
                query.put((Object)"is_active", (Object)"Y");
                object = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, new BasicDBObject("created_date", (Object)-1), "def_index_award");
                JSONArray list = object.getJSONArray("list");
                long count = 0L;
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject index_award = list.getJSONObject(i);
                    String index_award_id = index_award.getString("index_award_id");
                    Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_id").is((Object)index_award_id).and("corp_code").is((Object)corp_code));
                    log.info("++++++++\u67e5\u8be2\u5956\u54c1\u53d1\u9001\u6b21\u6570\u6761\u4ef6\uff1a" + query1);
                    count = this.mongoTemplate.count(query1, LogAward.class);
                    index_award.put("send_count", (Object)count);
                    jsonArray.add((Object)index_award);
                }
                object.put("list", (Object)jsonArray);
            }
        } else {
            BasicDBObject query1 = new BasicDBObject();
            query1.put((Object)"activity_id", (Object)activity_id);
            query1.put((Object)"corp_code", (Object)corp_code);
            query1.put((Object)"is_active", (Object)"Y");
            object = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query1, new BasicDBObject("created_date", (Object)-1), "def_index_award");
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
    }

    public DataResponse findOneIndexAward(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String award_id = data.getString("award_id");
        String corp_code = data.getString("corp_code");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"index_award_id").is((Object)award_id).and("corp_code").is((Object)corp_code));
        log.info("++++++++++\u67e5\u8be2\u5956\u54c1query\uff1a" + query);
        Index_award indexAward = (Index_award)this.mongoTemplate.findOne(query, Index_award.class);
        JSONObject object = new JSONObject();
        object.put("indexAward", (Object)indexAward);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object).setMsg("\u67e5\u8be2\u6210\u529f\uff01");
    }

    public DataResponse generateMiniQrCode(DataRequest dataRequest) {
        Query query_mp;
        DataResponse dataResponse = new DataResponse();
        JSONObject data = dataRequest.getData();
        String corp_code = data.getString("corp_code");
        String id = data.getString("id");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code)).addCriteria((CriteriaDefinition)Criteria.where((String)"is_active").is((Object)"Y"));
        Corp corp = (Corp)this.mongoTemplate.findOne(query, Corp.class);
        String mini_appid = corp.getMini_appid();
        LogMpCode logMpCode = (LogMpCode)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"store_id").is((Object)id).and("type").is((Object)"lottery").and("corp_code").is((Object)corp_code)), LogMpCode.class);
        String urlQcode = "";
        if (logMpCode == null || StringUtils.isNull((Object)logMpCode.getUrl())) {
            logMpCode = new LogMpCode();
            logMpCode.setCreated_time(TimeUtils.getCurrentTimeInString());
            logMpCode.setType("lottery");
            logMpCode.setStore_id(id);
            logMpCode.setIs_read("N");
            logMpCode.setCorp_code(corp_code);
            JSONObject mpCodeParam = new JSONObject();
            mpCodeParam.put("award_activity_id", (Object)id);
            logMpCode.setParam(mpCodeParam);
            this.mongoTemplate.save((Object)logMpCode);
            String mp_id = logMpCode.get_id().toString();
            query_mp = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(mp_id)));
            JSONObject param = new JSONObject();
            param.put("scene_param", (Object)id);
            param.put("page", (Object)"pages/container/index");
            param.put("mini_appid", (Object)mini_appid);
            DataRequest resu = new DataRequest();
            resu.setData(param);
            log.info("\u8bf7\u6c42\u5c0f\u7a0b\u5e8f\u7801\u53c2\u6570{}", (Object)param);
            DataResponse response = this.wechatAgent.callRest(resu, "/wechat/mini/getWXACodeUnlimitImage");
            log.info("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801{}", (Object)response);
            if ("SUCCESS".equals(response.getStatus().toString())) {
                JSONObject urlInfo = response.getData();
                logMpCode.setUrl(urlInfo.getString("url"));
                this.mongoTemplate.updateFirst(query_mp, Update.update((String)"url", (Object)urlInfo.getString("url")), LogMpCode.class);
                urlQcode = urlInfo.getString("url");
            }
        } else {
            String mp_id = logMpCode.get_id().toString();
            query_mp = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(mp_id)));
            LogMpCode codeInfo = (LogMpCode)this.mongoTemplate.findOne(query_mp, LogMpCode.class);
            urlQcode = codeInfo.getUrl();
        }
        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)id)).addCriteria((CriteriaDefinition)Criteria.where((String)"corp_code").is((Object)corp_code));
        Update update = new Update();
        update.set("miniQrCode", (Object)urlQcode);
        this.mongoTemplate.updateFirst(query1, update, AwardActivity.class);
        JSONObject object = new JSONObject();
        object.put("url", (Object)urlQcode);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setData(object);
    }

    public DataResponse findawardInfo(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest dataRequest = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = dataRequest.getData();
        Integer page_num = data.getInteger("page_num");
        Integer page_size = data.getInteger("page_size");
        JSONArray filter = data.getJSONArray("filter");
        String corp_code = data.getString("corp_code");
        BasicDBObject query = new BasicDBObject();
        if (StringUtils.isNotNull((Object)filter)) {
            query = this.mongodbUtils.changeCondition(filter);
        }
        query.put((Object)"corp_code", (Object)corp_code);
        query.put((Object)"is_active", (Object)"Y");
        log.info("++++++++++\u62bd\u5956\u6d3b\u52a8\u67e5\u8be2\u6761\u4ef6" + query);
        JSONObject jsonObject = this.mongodbUtils.queryByPage(page_size.intValue(), page_num.intValue(), query, new BasicDBObject("modified_date", (Object)-1), "def_award_activity");
        JSONArray list = jsonObject.getJSONArray("list");
        for (int i = 0; i < list.size(); ++i) {
            JSONObject jsonObject1 = list.getJSONObject(i);
            String start_time = jsonObject1.getString("start_time");
            String end_time = jsonObject1.getString("end_time");
            String is_finish = jsonObject1.getString("is_finish");
            if (is_finish.equals("Y")) {
                jsonObject1.put("award_status", (Object)"3");
            } else {
                String now = TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date start_time1 = simpleDateFormat.parse(start_time);
                    Date end_time1 = simpleDateFormat.parse(end_time);
                    Date now1 = simpleDateFormat.parse(now);
                    if (start_time1.after(now1)) {
                        jsonObject1.put("award_status", (Object)"1");
                    }
                    if (start_time1.before(now1) && now1.before(end_time1)) {
                        String is_suspend = jsonObject1.getString("is_suspend");
                        jsonObject1.put("award_status", (Object)"2");
                        if (is_suspend.equals("Y")) {
                            jsonObject1.put("award_status", (Object)"4");
                        }
                    }
                    if (end_time1.before(now1)) {
                        jsonObject1.put("award_status", (Object)"3");
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            list.remove(i);
            list.add(i, (Object)jsonObject1);
        }
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(jsonObject);
    }

    public DataResponse findOneawardInfo(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String award_activity_id = data.getString("award_activity_id");
        AwardActivity awardActivity = (AwardActivity)this.mongoTemplate.findById((Object)award_activity_id, AwardActivity.class);
        JSONArray store_array = awardActivity.getStore_array();
        ArrayList<Store> stores = new ArrayList<Store>();
        for (int j = 0; j < store_array.size(); ++j) {
            Store store = (Store)this.mongoTemplate.findById(store_array.get(j), Store.class);
            store.setName(store.getStore_name());
            stores.add(store);
        }
        JSONObject object = new JSONObject();
        object.put("awardActivity", (Object)awardActivity);
        object.put("stores", stores);
        return dataResponse.setStatus(Status.SUCCESS).setCode("0").setData(object);
    }

    public DataResponse suspendOneawardInfo(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String award_activity_id = data.getString("award_activity_id");
        String is_suspend = data.getString("is_suspend");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)award_activity_id));
        Update update = new Update();
        update.set("is_suspend", (Object)is_suspend);
        this.mongoTemplate.updateFirst(query, update, AwardActivity.class);
        String msg = null;
        msg = is_suspend.equals("Y") ? "\u6d3b\u52a8\u6682\u505c\uff01" : "\u6d3b\u52a8\u5f00\u542f";
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg(msg);
    }

    public DataResponse finishOneawardInfo(HttpServletRequest request) {
        DataResponse dataResponse = new DataResponse();
        DataRequest requestPayload = DataRequest.getRequestPayload((HttpServletRequest)request);
        JSONObject data = requestPayload.getData();
        String award_activity_id = data.getString("award_activity_id");
        String is_finish = data.getString("is_finish");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_activity_id").is((Object)award_activity_id));
        Update update = new Update();
        update.set("is_finish", (Object)is_finish);
        this.mongoTemplate.updateFirst(query, update, AwardActivity.class);
        return dataResponse.setCode("0").setStatus(Status.SUCCESS).setMsg("\u6d3b\u52a8\u7ed3\u675f\uff01");
    }

    private void delAward(JSONArray award_array) {
        for (int j = 0; j < award_array.size(); ++j) {
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"award_id").is(award_array.get(j)));
            Update update = new Update();
            update.set("active", (Object)"N");
            log.info("++++++++++\u5220\u9664\u5956\u54c1\u5bf9\u5e94\u7684\u62bd\u5956\u8bb0\u5f55\uff1a{}", (Object)query);
            this.mongoTemplate.updateMulti(query, update, LogAward.class);
            Query query1 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"index_award_id").is(award_array.get(j)));
            Update update1 = new Update();
            update1.set("is_active", (Object)"N");
            log.info("++++++++++\u5220\u9664\u5956\u54c1\uff1a" + query1);
            this.mongoTemplate.updateMulti(query1, update1, Index_award.class);
        }
    }
}

