/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.service.common;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.business.common.agent.UserAgent;
import kr.weitao.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    @Value(value="crm_url")
    String crm_url;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    UserAgent user_agent;

    public JSONObject getUser(String user_id) {
        JSONObject user_jo = new JSONObject();
        if (StringUtils.isNull((Object)user_id)) {
            return user_jo;
        }
        JSONObject user_param = new JSONObject();
        user_param.put("user_id", (Object)user_id);
        try {
            user_jo = this.user_agent.getData(user_param, "/user/info");
        }
        catch (Exception e) {
            log.error("get user error:" + e.getLocalizedMessage(), (Throwable)e);
            return user_jo;
        }
        if (user_jo != null && !user_jo.isEmpty()) {
            user_jo = user_jo.getJSONObject("user");
        }
        if (user_jo != null) {
            user_jo.put("id", (Object)user_jo.getString("_id"));
        }
        return user_jo;
    }
}

