/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import kr.weitao.activity.service.PromotionActivityService;
import kr.weitao.starter.config.annotation.WebLog;
import kr.weitao.starter.model.DataRequest;
import kr.weitao.starter.model.DataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8"})
@RestController
@RefreshScope
@RequestMapping(value={"/activity"})
public class PromotionActivityController {
    private static final Logger log = LoggerFactory.getLogger(PromotionActivityController.class);
    @Autowired
    PromotionActivityService promotionActivityService;

    @ApiOperation(value="\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8-ycj")
    @WebLog(description="\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8")
    @PostMapping(value={"/addActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse addActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.addActivityV2(dataRequest);
    }

    @ApiOperation(value="\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8V2-wsc")
    @WebLog(description="\u65b0\u589e\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8V2")
    @PostMapping(value={"/addActivityV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse addActivityV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.addActivityV2(dataRequest);
    }

    @ApiOperation(value="\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8")
    @WebLog(description="\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8")
    @PostMapping(value={"/modifyActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse modifyActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.modifyActivityV2(dataRequest);
    }

    @ApiOperation(value="\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8V2")
    @WebLog(description="\u4fee\u6539\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8V2")
    @PostMapping(value={"/modifyActivityV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse modifyActivityV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.modifyActivityV2(dataRequest);
    }

    @ApiOperation(value="\u5220\u9664\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8")
    @WebLog(description="\u5220\u9664\u6ee1\u51cf\u6ee1\u8d60\u6d3b\u52a8")
    @PostMapping(value={"/deleteActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse deleteActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.deleteActivity(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    @WebLog(description="\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    @PostMapping(value={"/listActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse listActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.listActivity(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6d3b\u52a8")
    @WebLog(description="\u67e5\u8be2\u5355\u4e2a\u6d3b\u52a8")
    @PostMapping(value={"/getActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse getActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.getActivityV2(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6d3b\u52a8")
    @WebLog(description="\u67e5\u8be2\u5355\u4e2a\u6d3b\u52a8")
    @PostMapping(value={"/getActivityV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse getActivityV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.getActivityV2(dataRequest);
    }

    @ApiOperation(value="\u6682\u505c\u5355\u4e2a\u6d3b\u52a8")
    @WebLog(description="\u6682\u505c\u5355\u4e2a\u6d3b\u52a8")
    @PostMapping(value={"/pauseActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse pauseActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.pauseActivity(dataRequest);
    }

    @ApiOperation(value="\u6062\u590d\u5355\u4e2a\u6d3b\u52a8")
    @WebLog(description="\u6062\u590d\u5355\u4e2a\u6d3b\u52a8")
    @PostMapping(value={"/recoveryActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse recoveryActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.recoveryActivity(dataRequest);
    }

    @ApiOperation(value="\u7ed3\u675f\u5355\u4e2a\u6d3b\u52a8")
    @WebLog(description="\u7ed3\u675f\u5355\u4e2a\u6d3b\u52a8")
    @PostMapping(value={"/endActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse endActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.endActivity(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u6d3b\u52a8\u4e0b\u7684\u5546\u54c1")
    @WebLog(description="\u67e5\u8be2\u67d0\u4e2a\u6d3b\u52a8\u4e0b\u7684\u5546\u54c1")
    @PostMapping(value={"/listProductsByActivityId"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProductsByActivityId(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.listProductsByActivityId(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u9009\u62e9\u6d3b\u52a8\u7684\u5546\u54c1\u5217\u8868")
    @WebLog(description="\u67e5\u8be2\u672a\u9009\u62e9\u6d3b\u52a8\u7684\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/listProductsByInactivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProductsByInactivity(@RequestBody DataRequest dataRequest) {
        dataRequest.getData().put("is_activity", (Object)"N");
        return this.promotionActivityService.listProductsV3(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u9009\u62e9\u6d3b\u52a8\u7684\u5546\u54c1\u5217\u8868V2")
    @WebLog(description="\u67e5\u8be2\u672a\u9009\u62e9\u6d3b\u52a8\u7684\u5546\u54c1\u5217\u8868V2")
    @PostMapping(value={"/listProductsByInactivityV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProductsByInactivityV2(@RequestBody DataRequest dataRequest) {
        dataRequest.getData().put("is_activity", (Object)"N");
        return this.promotionActivityService.listProductsV3(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868")
    @WebLog(description="\u67e5\u8be2\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/listProducts"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProducts(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.listProductsV3(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868")
    @WebLog(description="\u67e5\u8be2\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/listProductsV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProductsV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.listProductsV3(dataRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868\uff08\u5173\u8054\u6d3b\u52a8\uff09")
    @WebLog(description="\u67e5\u8be2\u5546\u54c1\u5217\u8868\uff08\u5173\u8054\u6d3b\u52a8\uff09")
    @PostMapping(value={"/listProductsLinkActivity"}, produces={"application/json;charset=utf-8"})
    public DataResponse listProductsLinkActivity(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.listProductsLinkActivity(dataRequest);
    }

    @WebLog(description="\u6d3b\u52a8\u5546\u54c1\u8ba1\u7b97")
    @ApiOperation(value="\u6d3b\u52a8\u5546\u54c1\u8ba1\u7b97")
    @PostMapping(value={"/calculateProducts"}, produces={"application/json;charset=utf-8"})
    public DataResponse calculateProducts(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.calculateProductsV3(dataRequest);
    }

    @WebLog(description="\u6d3b\u52a8\u5546\u54c1\u8ba1\u7b97V2")
    @ApiOperation(value="\u6d3b\u52a8\u5546\u54c1\u8ba1\u7b97V2")
    @PostMapping(value={"/calculateProductsV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse calculateProductsV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.calculateProductsV3(dataRequest);
    }

    @WebLog(description="\u6d3b\u52a8\u8fd0\u8d39\u8ba1\u7b97")
    @ApiOperation(value="\u8fd0\u8d39\u8ba1\u7b97")
    @PostMapping(value={"/calculatePostage"}, produces={"application/json;charset=utf-8"})
    public DataResponse calculatePostage(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.calculatePostageV3(dataRequest);
    }

    @WebLog(description="\u6d3b\u52a8\u8fd0\u8d39\u8ba1\u7b97")
    @ApiOperation(value="\u8fd0\u8d39\u8ba1\u7b97")
    @PostMapping(value={"/calculatePostageV2"}, produces={"application/json;charset=utf-8"})
    public DataResponse calculatePostageV2(@RequestBody DataRequest dataRequest) {
        return this.promotionActivityService.calculatePostageV3(dataRequest);
    }
}

