/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.activity.config.quartz;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kr.weitao.activity.service.PromotionActivityService;
import kr.weitao.activity.service.SeckillActivityService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class AsyncJobFactory
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(AsyncJobFactory.class);
    @Autowired
    PromotionActivityService promotionActivityService;
    @Autowired
    SeckillActivityService seckillActivityService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        log.info("AsyncJobFactory execute");
        JobKey jobKey = context.getJobDetail().getKey();
        String groupName = jobKey.getGroup();
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String func = data.get((Object)"func").toString();
        JSONObject jsonObject = JSONObject.parseObject((String)func);
        String moduleCode = jsonObject.getString("module_code");
        try {
            if ("ACTIVITY".equals(moduleCode)) {
                if (groupName.startsWith("PA")) {
                    this.promotionActivityService.updateActivityStatus(jobKey);
                } else if (groupName.startsWith("SA")) {
                    this.seckillActivityService.updateActivityStatus(jobKey);
                } else if (groupName.startsWith("DIS")) {
                    this.seckillActivityService.updateActivityStatus(jobKey);
                }
            } else if ("ACTIVITY_SECKILL_STOCK".equals(moduleCode)) {
                JSONArray skuArray = jsonObject.getJSONArray("skuArray");
                this.seckillActivityService.handleSeckillStockByOrder(jobKey.getName(), jobKey.getGroup(), skuArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

