/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.client.rpc;

import Ice.Communicator;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.Util;
import com.bizvane.sun.base.utils.MD5Util;
import com.bizvane.sun.v1.common.Data;
import com.bizvane.sun.v1.common.DataBox;
import com.bizvane.sun.v1.common.Ident;
import com.bizvane.sun.v1.common.Sign;
import com.bizvane.sun.v1.common.Status;
import com.bizvane.sun.v1.etl.SatellitePrx;
import com.bizvane.sun.v1.etl.SatellitePrxHelper;
import java.util.Map;

public class ClientETL {
    Communicator ic = null;
    String satelliteService = "ETLService";
    String[] arg = new String[]{"--Ice.Config=default.config"};
    SatellitePrx satellitePrx;

    public ClientETL() {
        try {
            this.ic = Util.initialize((String[])this.arg);
        }
        catch (LocalException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public ClientETL(String[] args) {
        try {
            this.ic = args.length < 1 ? Util.initialize((String[])this.arg) : Util.initialize((String[])args);
        }
        catch (LocalException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void CleanUp() {
        if (this.ic != null) {
            try {
                this.ic.destroy();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public SatellitePrx getSatellitePrx() {
        try {
            if (this.satellitePrx == null) {
                ObjectPrx base = this.ic.stringToProxy(this.satelliteService);
                this.satellitePrx = SatellitePrxHelper.checkedCast(base);
            }
            return this.satellitePrx;
        }
        catch (LocalException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public DataBox Push(DataBox db) {
        DataBox defaultdb = new DataBox();
        if (db.data.size() < 1) {
            defaultdb.status = Status.FAILED;
            defaultdb.msg = "Empty request data";
            return defaultdb;
        }
        db.method = "com.bizvane.sun.etl.method.PushToHDFS";
        DataBox respDB = this.getSatellitePrx().put(db);
        return respDB;
    }

    public static Sign getSign(Map<String, Data> data, Ident ident, long timestamp) {
        String srcString = ident.accessKey + ident.accessSecret + Long.toString(timestamp);
        String encryptString = MD5Util.getMD5Str32(srcString);
        Sign sign = new Sign("MD5", encryptString);
        return sign;
    }
}

