/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.client.http;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.sun.base.utils.HttpClient;
import com.bizvane.sun.base.utils.MD5Util;
import com.bizvane.sun.v1.common.Data;
import com.bizvane.sun.v1.common.Ident;
import com.bizvane.sun.v1.common.Sign;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ClientETL {
    private static HttpClient httpClient = new HttpClient();
    private static String serverAddress = "http://api.etl.bizvane.com/app/etl";

    public ClientETL(String serverAddr) {
        serverAddress = serverAddr;
    }

    public JSONObject Push(JSONObject jsonObject) {
        jsonObject.put("method", (Object)"com.bizvane.sun.etl.method.PushToHDFS");
        RequestBody body = RequestBody.create((MediaType)HttpClient.JSON, (String)jsonObject.toJSONString());
        Request request = new Request.Builder().url(serverAddress).post(body).build();
        try {
            Response response = httpClient.post(request);
            String respString = response.body().string();
            JSONObject respJSON = JSONObject.parseObject((String)respString);
            return respJSON;
        }
        catch (IOException e) {
            System.out.print("Http put error: " + e.getMessage());
            return null;
        }
    }

    public static Sign getSign(Map<String, Data> data, Ident ident, long timestamp) {
        String srcString = ident.accessKey + ident.accessSecret + Long.toString(timestamp);
        String encryptString = MD5Util.getMD5Str32(srcString);
        Sign sign = new Sign("MD5", encryptString);
        return sign;
    }
}

