/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.base.utils;

import Ice.Object;
import com.bizvane.sun.base.utils.LogUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class JSONUtil {
    static ObjectMapper objectMapper = new ObjectMapper();
    static Logger logger = LogUtil.getLogger(JSONUtil.class);

    public static JSON_TYPE getJSONType(String json) {
        if (json == null || json.isEmpty()) {
            return JSON_TYPE.JSON_TYPE_ERROR;
        }
        char[] strChar = json.toCharArray();
        char firstChar = strChar[0];
        char lastChar = strChar[strChar.length - 1];
        if (firstChar == '{' && lastChar == '}') {
            try {
                objectMapper.readValue(json, Map.class);
                return JSON_TYPE.JSON_TYPE_OBJECT;
            }
            catch (IOException e) {
                return JSON_TYPE.JSON_TYPE_ERROR;
            }
        }
        if (firstChar == '[' && lastChar == ']') {
            try {
                objectMapper.readValue(json, List.class);
                return JSON_TYPE.JSON_TYPE_ARRAY;
            }
            catch (IOException e) {
                return JSON_TYPE.JSON_TYPE_ERROR;
            }
        }
        return JSON_TYPE.JSON_TYPE_ERROR;
    }

    public static List<Map> getMapList(String json) {
        try {
            return (List)objectMapper.readValue(json, List.class);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static Map getMap(String json) {
        try {
            return (Map)objectMapper.readValue(json, Map.class);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getJsonList(String json) {
        try {
            List _list = (List)objectMapper.readValue(json, List.class);
            LinkedList<String> list = new LinkedList<String>();
            for (Map map : _list) {
                list.add(JSONUtil.getJsonString(map));
            }
            return list;
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String getValueString(String json, String key) {
        try {
            Map map = (Map)objectMapper.readValue(json, Map.class);
            Set set = map.keySet();
            for (String _key : set) {
                if (!_key.equals(key)) continue;
                return ((Object)map.get(key)).toString();
            }
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static String getJsonString(Map map) {
        try {
            return objectMapper.writeValueAsString((java.lang.Object)map);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static enum JSON_TYPE {
        JSON_TYPE_OBJECT,
        JSON_TYPE_ARRAY,
        JSON_TYPE_ERROR;

    }
}

