/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.weekend.reflection;

import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Pattern;
import tk.mybatis.mapper.weekend.Fn;
import tk.mybatis.mapper.weekend.reflection.ReflectionOperationException;

public class Reflections {
    private static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    private static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");

    private Reflections() {
    }

    public static String fnToFieldName(Fn fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            return Introspector.decapitalize(getter);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionOperationException(e);
        }
    }

    public static String[] fnToFieldNames(Fn ... fns) {
        ArrayList<String> list = new ArrayList<String>();
        for (Fn fn : fns) {
            list.add(Reflections.fnToFieldName(fn));
        }
        return list.toArray(new String[0]);
    }
}

