/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import pl.project13.maven.git.CommitIdGenerationMode;
import pl.project13.maven.git.GitCommitIdExecutionException;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.JGitProvider;
import pl.project13.maven.git.NativeGitProvider;
import pl.project13.maven.git.PropertiesFileGenerator;
import pl.project13.maven.git.PropertiesFilterer;
import pl.project13.maven.git.PropertiesReplacer;
import pl.project13.maven.git.ReplacementProperty;
import pl.project13.maven.git.build.BuildServerDataProvider;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;

@org.apache.maven.plugins.annotations.Mojo(name="revision", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class GitCommitIdMojo
extends AbstractMojo {
    private static final String CONTEXT_KEY = GitCommitIdMojo.class.getName() + ".properties";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    List<MavenProject> reactorProjects;
    @Parameter(property="session", required=true, readonly=true)
    MavenSession session;
    @Parameter(defaultValue="false")
    boolean injectAllReactorProjects;
    @Parameter(defaultValue="false")
    boolean verbose;
    @Parameter(defaultValue="true")
    boolean skipPoms;
    @Parameter(defaultValue="false")
    boolean generateGitPropertiesFile;
    @Parameter(defaultValue="${project.build.outputDirectory}/git.properties")
    String generateGitPropertiesFilename;
    @Parameter(defaultValue="${project.basedir}/.git")
    File dotGitDirectory;
    @Parameter
    GitDescribeConfig gitDescribe;
    @Parameter(defaultValue="7")
    int abbrevLength;
    @Parameter(defaultValue="properties")
    String format;
    @Parameter(defaultValue="git")
    String prefix;
    private String prefixDot = "";
    @Parameter(defaultValue="yyyy-MM-dd'T'HH:mm:ssZ")
    String dateFormat;
    @Parameter
    String dateFormatTimeZone;
    @Parameter(defaultValue="true")
    boolean failOnNoGitDirectory;
    @Parameter(defaultValue="true")
    boolean failOnUnableToExtractRepoInfo;
    @Parameter(defaultValue="false")
    boolean useNativeGit;
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(property="maven.gitcommitid.skip", defaultValue="false")
    private boolean skipViaCommandLine;
    @Parameter(defaultValue="false")
    boolean runOnlyOnce;
    @Parameter
    List<String> excludeProperties;
    @Parameter
    List<String> includeOnlyProperties;
    @Parameter(defaultValue="flat")
    String commitIdGenerationMode;
    private CommitIdGenerationMode commitIdGenerationModeEnum;
    @Parameter
    List<ReplacementProperty> replacementProperties;
    @Parameter(defaultValue="HEAD")
    String evaluateOnCommit;
    protected static final Pattern allowedCharactersForEvaluateOnCommit = Pattern.compile("[a-zA-Z0-9\\_\\-\\^\\/\\.]+");
    @Parameter(defaultValue="30000")
    long nativeGitTimeoutInMs;
    @Parameter(defaultValue="true")
    boolean useBranchNameFromBuildEnvironment;
    @Parameter(defaultValue="true")
    boolean injectIntoSysProperties;
    @Component
    private BuildContext buildContext;
    private Properties properties;
    private Charset sourceCharset = StandardCharsets.UTF_8;
    @Nonnull
    private final LoggerBridge log = new MavenLoggerBridge((Mojo)this, false);
    @Nonnull
    private PropertiesFilterer propertiesFilterer = new PropertiesFilterer(this.log);
    @Nonnull
    PropertiesReplacer propertiesReplacer = new PropertiesReplacer(this.log);

    public void execute() throws MojoExecutionException {
        try {
            this.log.setVerbose(this.verbose);
            if (this.buildContext != null && this.buildContext.isIncremental() && (!this.generateGitPropertiesFile || PropertiesFileGenerator.craftPropertiesOutputFile(this.project.getBasedir(), this.generateGitPropertiesFilename).exists())) {
                return;
            }
            String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
            this.sourceCharset = null != sourceEncoding ? Charset.forName(sourceEncoding) : Charset.defaultCharset();
            if (this.skip || this.skipViaCommandLine) {
                this.log.info("skip is enabled, skipping execution!");
                return;
            }
            if (this.runOnlyOnce && !this.session.getExecutionRootDirectory().equals(this.session.getCurrentProject().getBasedir().getAbsolutePath())) {
                this.log.info("runOnlyOnce is enabled and this project is not the top level project, skipping execution!");
                return;
            }
            if (this.isPomProject(this.project) && this.skipPoms) {
                this.log.info("isPomProject is true and skipPoms is true, return");
                return;
            }
            this.dotGitDirectory = this.lookupGitDirectory();
            if (this.failOnNoGitDirectory && !this.directoryExists(this.dotGitDirectory)) {
                throw new GitCommitIdExecutionException(".git directory is not found! Please specify a valid [dotGitDirectory] in your pom.xml");
            }
            if (this.gitDescribe == null) {
                this.gitDescribe = new GitDescribeConfig();
            }
            if (this.dotGitDirectory == null) {
                this.log.info("dotGitDirectory is null, aborting execution!");
                return;
            }
            this.log.info("dotGitDirectory {}", (Object)this.dotGitDirectory.getAbsolutePath());
            if (this.evaluateOnCommit == null || !allowedCharactersForEvaluateOnCommit.matcher(this.evaluateOnCommit).matches()) {
                this.log.error("suspicious argument for evaluateOnCommit, aborting execution!");
                return;
            }
            try {
                boolean alreadyInjected;
                try {
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.valueOf(this.commitIdGenerationMode.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Detected wrong setting for 'commitIdGenerationMode'. Falling back to default 'flat' mode!");
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.FLAT;
                }
                this.properties = new Properties();
                String trimmedPrefix = this.prefix.trim();
                this.prefixDot = trimmedPrefix.equals("") ? "" : trimmedPrefix + ".";
                Properties contextProperties = this.getContextProperties(this.project);
                boolean bl = alreadyInjected = this.injectAllReactorProjects && contextProperties != null;
                if (alreadyInjected) {
                    this.log.info("injectAllReactorProjects is enabled - attempting to use the already computed values");
                    this.properties = contextProperties;
                }
                this.loadGitData(this.properties);
                this.loadBuildData(this.properties);
                this.propertiesReplacer.performReplacement(this.properties, this.replacementProperties);
                this.propertiesFilterer.filter(this.properties, this.includeOnlyProperties, this.prefixDot);
                this.propertiesFilterer.filterNot(this.properties, this.excludeProperties, this.prefixDot);
                this.logProperties();
                if (this.generateGitPropertiesFile) {
                    new PropertiesFileGenerator(this.log, this.buildContext, this.format, this.prefixDot, this.project.getName()).maybeGeneratePropertiesFile(this.properties, this.project.getBasedir(), this.generateGitPropertiesFilename, this.sourceCharset);
                }
                this.publishPropertiesInto(this.project.getProperties());
                this.publishPropertiesInto(this.session.getUserProperties());
                if (this.injectAllReactorProjects) {
                    this.appendPropertiesToReactorProjects();
                }
                if (this.injectIntoSysProperties) {
                    this.publishPropertiesInto(System.getProperties());
                    this.publishPropertiesInto(this.session.getSystemProperties());
                }
            }
            catch (Exception e) {
                this.handlePluginFailure(e);
            }
        }
        catch (GitCommitIdExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Nullable
    private Properties getContextProperties(MavenProject project) {
        Object stored = project.getContextValue(CONTEXT_KEY);
        if (stored instanceof Properties) {
            return (Properties)stored;
        }
        return null;
    }

    private void loadBuildData(Properties properties) {
        BuildServerDataProvider buildServerDataProvider = BuildServerDataProvider.getBuildServerProvider(System.getenv(), this.log);
        buildServerDataProvider.setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setProject(this.project).setPrefixDot(this.prefixDot);
        buildServerDataProvider.loadBuildData(properties);
    }

    private void publishPropertiesInto(Properties p) {
        p.putAll((Map<?, ?>)this.properties);
    }

    private void handlePluginFailure(Exception e) throws GitCommitIdExecutionException {
        if (this.failOnUnableToExtractRepoInfo) {
            throw new GitCommitIdExecutionException("Could not complete Mojo execution...", e);
        }
        this.log.error(e.getMessage(), e);
    }

    private void appendPropertiesToReactorProjects() {
        for (MavenProject mavenProject : this.reactorProjects) {
            this.log.info("{}] project {}", (Object)mavenProject.getName(), (Object)mavenProject.getName());
            this.publishPropertiesInto(mavenProject.getProperties());
            mavenProject.setContextValue(CONTEXT_KEY, (Object)this.properties);
        }
    }

    private File lookupGitDirectory() throws GitCommitIdExecutionException {
        return new GitDirLocator(this.project, this.reactorProjects).lookupGitDirectory(this.dotGitDirectory);
    }

    private void logProperties() {
        for (Object key : this.properties.keySet()) {
            String keyString = key.toString();
            this.log.info("including property {} in results", (Object)keyString);
        }
    }

    private void loadGitData(@Nonnull Properties properties) throws GitCommitIdExecutionException {
        if (this.useNativeGit) {
            this.loadGitDataWithNativeGit(properties);
        } else {
            this.loadGitDataWithJGit(properties);
        }
    }

    private void loadGitDataWithNativeGit(@Nonnull Properties properties) throws GitCommitIdExecutionException {
        try {
            File basedir = this.project.getBasedir().getCanonicalFile();
            GitDataProvider nativeGitProvider = NativeGitProvider.on(basedir, this.nativeGitTimeoutInMs, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum).setUseBranchNameFromBuildEnvironment(this.useBranchNameFromBuildEnvironment).setExcludeProperties(this.excludeProperties).setIncludeOnlyProperties(this.includeOnlyProperties);
            nativeGitProvider.loadGitData(this.evaluateOnCommit, properties);
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    private void loadGitDataWithJGit(@Nonnull Properties properties) throws GitCommitIdExecutionException {
        GitDataProvider jGitProvider = JGitProvider.on(this.dotGitDirectory, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum).setUseBranchNameFromBuildEnvironment(this.useBranchNameFromBuildEnvironment).setExcludeProperties(this.excludeProperties).setIncludeOnlyProperties(this.includeOnlyProperties);
        jGitProvider.loadGitData(this.evaluateOnCommit, properties);
    }

    private boolean isPomProject(@Nonnull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }
}

