/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.Arrays;

public enum TokenType {
    Spread("...", "..."),
    Period(".", "."),
    QuestionPeriod("?.", "?."),
    Comma(",", ","),
    Semicolon(";", ";"),
    Colon(":", ":"),
    Plus("+", "+"),
    Minus("-", "-"),
    Asterisk("*", "*"),
    ForwardSlash("/", "/"),
    PostSlash("\\", "\\"),
    Percentage("%", "%"),
    LeftParantheses("(", ")"),
    RightParantheses(")", ")"),
    LeftBracket("[", "["),
    RightBracket("]", "]"),
    LeftCurly("{", "{"),
    RightCurly("}", "{"),
    Less("<", "<"),
    Greater(">", ">"),
    LessEqual("<=", "<="),
    GreaterEqual(">=", ">="),
    Equal("==", "=="),
    NotEqual("!=", "!="),
    Assignment(true, "=", "="),
    PlusPlus(true, "++", "++"),
    MinusMinus(true, "--", "--"),
    PlusEqual(true, "+=", "+="),
    MinusEqual(true, "-=", "-="),
    AsteriskEqual(true, "*=", "*="),
    ForwardSlashEqual(true, "/=", "/="),
    PercentEqual(true, "%=", "%="),
    ColonColon("::", "::"),
    EqualEqualEqual("===", "==="),
    NotEqualEqual("!==", "!=="),
    And("&&", "&&"),
    Or("||", "||"),
    Xor("^", "^"),
    Not("!", "!"),
    BitAnd("&", "&"),
    BitOr("|", "|"),
    BitNot("~", "~"),
    LShift("<<", "<<"),
    RShift(">>", ">>"),
    Rshift2(">>>", ">>>"),
    XorEqual(true, "^=", "^="),
    BitAndEqual(true, "&=", "&="),
    BitOrEqual(true, "|=", "|="),
    LShiftEqual(true, "<<=", "<<="),
    RShiftEqual(true, ">>=", ">>="),
    RShift2Equal(true, ">>>=", ">>>="),
    SqlAnd("and", "and"),
    SqlOr("or", "or"),
    SqlNotEqual("<>", "<>", true),
    QuestionMark("?", "?"),
    DoubleQuote("\"", "\""),
    TripleQuote("\"\"\"", "\"\"\""),
    SingleQuote("'", "'"),
    Lambda("=>"),
    RegexpLiteral("a regexp"),
    BooleanLiteral("true or false"),
    DoubleLiteral("a double floating point number"),
    DecimalLiteral("a decimal point number"),
    FloatLiteral("a floating point number"),
    LongLiteral("a long integer number"),
    IntegerLiteral("an integer number"),
    ShortLiteral("a short integer number"),
    ByteLiteral("a byte integer number"),
    CharacterLiteral("a character"),
    StringLiteral("a string"),
    NullLiteral("null"),
    Language("language"),
    Comment("comment"),
    Identifier("an identifier");

    private static final TokenType[] VALUES;
    private final String literal;
    private final String error;
    private final boolean inLinq;
    private final boolean modifiable;

    private TokenType(String error) {
        this(null, error);
    }

    private TokenType(String literal, String error) {
        this(literal, error, false);
    }

    private TokenType(boolean modifiable, String literal, String error) {
        this(literal, error, false, modifiable);
    }

    private TokenType(String literal, String error, boolean inLinq) {
        this(literal, error, inLinq, false);
    }

    private TokenType(String literal, String error, boolean inLinq, boolean modifiable) {
        this.literal = literal;
        this.error = error;
        this.inLinq = inLinq;
        this.modifiable = modifiable;
    }

    public static TokenType[] getSortedValues() {
        return VALUES;
    }

    public boolean isInLinq() {
        return this.inLinq;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getError() {
        return this.error;
    }

    static {
        VALUES = TokenType.values();
        Arrays.sort(VALUES, (o1, o2) -> {
            if (o1.literal == null && o2.literal == null) {
                return 0;
            }
            if (o1.literal == null && o2.literal != null) {
                return 1;
            }
            if (o1.literal != null && o2.literal == null) {
                return -1;
            }
            return o2.literal.length() - o1.literal.length();
        });
    }
}

