/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.functions;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.MapExtension;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.functions.ObjectTypeConditionExtension;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.reflection.JavaReflection;

public class StreamExtension {
    @Comment(value="\u5c06\u5bf9\u8c61\u8f6c\u4e3aList")
    public static List<Object> arrayLikeToList(Object arrayLike) {
        if (arrayLike == null) {
            return new ArrayList<Object>();
        }
        if (arrayLike instanceof Collection) {
            return new ArrayList<Object>((Collection)arrayLike);
        }
        if (arrayLike.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>(Array.getLength(arrayLike));
            IntStream.range(0, Array.getLength(arrayLike)).forEach(i -> list.add(Array.get(arrayLike, i)));
            return list;
        }
        if (arrayLike instanceof Iterator) {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator it = (Iterator)arrayLike;
            it.forEachRemaining(list::add);
            return list;
        }
        if (arrayLike instanceof Enumeration) {
            Enumeration en = (Enumeration)arrayLike;
            return Collections.list(en);
        }
        throw new MagicScriptException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + arrayLike.getClass());
    }

    @Comment(value="\u5c06\u96c6\u5408\u4f7f\u7528\u8fde\u63a5\u7b26\u62fc\u63a5\u8d77\u6765")
    public static String join(Object target, @Comment(name="separator", value="\u62fc\u63a5\u7b26\uff0c\u5982`,`") String separator) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        StringBuilder sb = new StringBuilder();
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            sb.append(objects.get(i));
            if (i + 1 >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @Comment(value="\u5c06\u96c6\u5408\u8f6c\u4e3aJavaBean")
    public static Object asBean(Object source, @Comment(name="target", value="\u76ee\u6807\u7c7b\u578b") Class<?> target) {
        return StreamExtension.asBean(source, target, false);
    }

    @Comment(value="\u5c06\u96c6\u5408\u8f6c\u4e3aJavaBean")
    public static Object asBean(Object source, @Comment(name="target", value="\u76ee\u6807\u7c7b\u578b") Class<?> target, @Comment(name="isArray", value="\u662f\u5426\u662f\u6570\u7ec4") boolean isArray) {
        AbstractCollection collection;
        Class<?> sourceClass = source.getClass();
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        int size = objects.size();
        boolean isCollection = false;
        boolean isMap = false;
        boolean isOrigin = false;
        boolean targetIsArray = false;
        Class<?> innerClass = null;
        if (size > 0) {
            Object first = objects.get(0);
            innerClass = first.getClass();
            isCollection = ObjectTypeConditionExtension.isCollection(innerClass);
            isMap = ObjectTypeConditionExtension.isMap(innerClass);
            isOrigin = ObjectTypeConditionExtension.is(first, target);
            isOrigin = isOrigin || JavaReflection.isPrimitiveAssignableFrom(first.getClass(), target);
            targetIsArray = ObjectTypeConditionExtension.isArray(target);
        }
        if (isArray) {
            Object result = Array.newInstance(target, objects.size());
            for (int i = 0; i < size; ++i) {
                Object value = objects.get(i);
                if (innerClass.isArray()) {
                    Array.set(result, i, StreamExtension.asBean(value, innerClass.getComponentType(), true));
                    continue;
                }
                if (targetIsArray) {
                    Array.set(result, i, StreamExtension.asBean(value, target.getComponentType(), true));
                    continue;
                }
                if (isCollection) {
                    Array.set(result, i, StreamExtension.asBean(value, innerClass, false));
                    continue;
                }
                if (isMap) {
                    Array.set(result, i, MapExtension.asBean((Map)value, innerClass));
                    continue;
                }
                if (!isOrigin) continue;
                Array.set(result, i, value);
            }
            return result;
        }
        if (List.class.isAssignableFrom(sourceClass)) {
            collection = new ArrayList(size);
        } else if (Set.class.isAssignableFrom(sourceClass)) {
            collection = new HashSet(size);
        } else {
            throw new MagicScriptException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + sourceClass);
        }
        for (Object value : objects) {
            if (isCollection) {
                collection.add(StreamExtension.asBean(value, target));
                continue;
            }
            if (isMap) {
                collection.add(MapExtension.asBean((Map)value, target));
                continue;
            }
            if (!isOrigin) break;
            collection.add(value);
        }
        return collection;
    }

    private Object toOriginType(Object target, List<Object> results) {
        if (target instanceof Collection) {
            return results;
        }
        if (target.getClass().isArray()) {
            return results.toArray();
        }
        if (target instanceof Iterator) {
            return results;
        }
        if (target instanceof Enumeration) {
            return results;
        }
        return null;
    }

    @Comment(value="\u5411\u96c6\u5408\u4e2d\u6dfb\u52a0\u5143\u7d20", origin=true)
    public Object push(Object target, @Comment(name="item", value="\u8981\u6dfb\u52a0\u7684\u5143\u7d20") Object item) {
        if (target instanceof Collection) {
            if (item instanceof Collection) {
                ((Collection)target).addAll((Collection)item);
            } else {
                ((Collection)target).add(item);
            }
        } else {
            throw new MagicScriptException("push\u65b9\u6cd5\u4e0d\u652f\u6301\u7c7b\u578b:" + target.getClass());
        }
        return target;
    }

    @Comment(value="\u5c06\u96c6\u5408\u8fdb\u884c\u8f6c\u6362\uff0c\u5e76\u8fd4\u56de\u65b0\u96c6\u5408", origin=true)
    public Object map(Object target, @Comment(name="function", value="\u8f6c\u6362\u51fd\u6570\uff0c\u5982\u63d0\u53d6\u5c5e\u6027(item)=>item.xxx") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        ArrayList<Object> results = new ArrayList<Object>(objects.size());
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            Object object = objects.get(i);
            results.add(function.apply(new Object[]{object, i, len}));
        }
        return this.toOriginType(target, results);
    }

    @Comment(value="\u5c06\u96c6\u5408\u8fdb\u884c\u8fc7\u6ee4\uff0c\u5e76\u8fd4\u56de\u65b0\u96c6\u5408", origin=true)
    public Object filter(Object target, @Comment(name="function", value="\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5982(item)=>item.xxx == 1") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        ArrayList<Object> results = new ArrayList<Object>(objects.size());
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            Object object = objects.get(i);
            if (!BooleanLiteral.isTrue(function.apply(new Object[]{object, i, len}))) continue;
            results.add(object);
        }
        return this.toOriginType(target, results);
    }

    @Comment(value="\u67e5\u627e\u5143\u7d20")
    public Object find(Object target, @Comment(name="function", value="\u5339\u914d\u6761\u4ef6\uff0c\u5982(item)=>item.xxx == 1") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            Object object = objects.get(i);
            if (!BooleanLiteral.isTrue(function.apply(new Object[]{object, i, len}))) continue;
            return object;
        }
        return null;
    }

    @Comment(value="\u67e5\u627e\u5143\u7d20\u7d22\u5f15")
    public int findIndex(Object target, @Comment(name="function", value="\u5339\u914d\u6761\u4ef6\uff0c\u5982(item)=>item.xxx == 1") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            Object object = objects.get(i);
            if (!BooleanLiteral.isTrue(function.apply(new Object[]{object, i, len}))) continue;
            return i;
        }
        return -1;
    }

    @Comment(value="\u5408\u5e76\u591a\u4e2a\u96c6\u5408, \u8fd4\u56de\u65b0\u7684\u96c6\u5408", origin=true)
    public Object concat(Object src, Object ... target) {
        ArrayList<Object> results = new ArrayList<Object>(StreamExtension.arrayLikeToList(src));
        if (target != null) {
            for (Object o : target) {
                results.addAll(StreamExtension.arrayLikeToList(o));
            }
        }
        return this.toOriginType(target, results);
    }

    @Comment(value="\u96c6\u5408\u8f6c\u4e3aMap")
    public Map<Object, Object> toMap(Object src, @Comment(name="mappingKey", value="key\u503c") Function<Object[], Object> mappingKey, @Comment(name="mappingValue", value="value\u503c") Function<Object[], Object> mappingValue) {
        ArrayList<Object> target = new ArrayList<Object>(StreamExtension.arrayLikeToList(src));
        int size = target.size();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object item = target.get(i);
            Object[] parameters = new Object[]{item, i, size};
            map.put(mappingKey.apply(parameters), mappingValue.apply(parameters));
        }
        return map;
    }

    @Comment(value="\u96c6\u5408\u8f6c\u4e3aMap")
    public Map<Object, Object> toMap(Object src, @Comment(name="mappingKey", value="key\u503c") Function<Object[], Object> mappingKey) {
        return this.toMap(src, mappingKey, objects -> objects[0]);
    }

    @Comment(value="\u5c06\u96c6\u5408\u8fdb\u884c\u5faa\u73af\u64cd\u4f5c\uff0c\u5e76\u8fd4\u56de\u65b0\u96c6\u5408", origin=true)
    public Object each(Object target, @Comment(name="function", value="\u5faa\u73af\u51fd\u6570\uff0c\u5982\u5faa\u73af\u6dfb\u52a0\u5c5e\u6027(item)=>{item.xxx = 'newVal'}") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        ArrayList<Object> results = new ArrayList<Object>(objects.size());
        int len = objects.size();
        for (int i = 0; i < len; ++i) {
            Object object = objects.get(i);
            function.apply(new Object[]{object, i, len});
            results.add(object);
        }
        return this.toOriginType(target, results);
    }

    @Comment(value="\u5c06\u96c6\u5408\u8fdb\u884c\u6392\u5e8f\uff0c\u5e76\u8fd4\u56de\u65b0\u96c6\u5408", origin=true)
    public Object sort(Object target, @Comment(name="function", value="\u6392\u5e8f\u51fd\u6570\uff0c\u5982\u4ece\u5927\u5230\u5c0f(a,b)=>a-b") Function<Object[], Object> function) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        objects.sort((o1, o2) -> ObjectConvertExtension.asInt(function.apply(new Object[]{o1, o2}), 0));
        return this.toOriginType(target, objects);
    }

    @Comment(value="\u5c06\u96c6\u5408\u8fdb\u884c\u53cd\u8f6c\u64cd\u4f5c", origin=true)
    public Object reserve(Object target) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        Collections.reverse(objects);
        return this.toOriginType(target, objects);
    }

    @Comment(value="\u5c06\u96c6\u5408\u7684\u987a\u5e8f\u6253\u4e71", origin=true)
    public Object shuffle(Object target) {
        List<Object> objects = StreamExtension.arrayLikeToList(target);
        Collections.shuffle(objects);
        return this.toOriginType(target, objects);
    }

    @Comment(value="\u96c6\u5408\u53bb\u91cd", origin=true)
    public Object distinct(Object target) {
        return this.toOriginType(target, StreamExtension.arrayLikeToList(target).stream().distinct().collect(Collectors.toList()));
    }

    @Comment(value="\u5c06\u96c6\u5408\u4f7f\u7528`,`\u62fc\u63a5\u8d77\u6765")
    public String join(Object target) {
        return StreamExtension.join(target, ",");
    }

    @Comment(value="\u53d6\u51fa\u96c6\u5408\u6700\u5927\u503c\uff0c\u5982\u679c\u627e\u4e0d\u5230\u8fd4\u56denull")
    public Object max(Object target) {
        return StreamExtension.arrayLikeToList(target).stream().filter(Objects::nonNull).max(BinaryOperation::compare).orElse(null);
    }

    @Comment(value="\u53d6\u51fa\u96c6\u5408\u6700\u5c0f\u503c\uff0c\u5982\u679c\u627e\u4e0d\u5230\u8fd4\u56denull")
    public Object min(Object target) {
        return StreamExtension.arrayLikeToList(target).stream().filter(Objects::nonNull).min(BinaryOperation::compare).orElse(null);
    }

    @Comment(value="\u53d6\u51fa\u96c6\u5408\u5e73\u5747\u503c\uff0c\u5982\u679c\u65e0\u6cd5\u8ba1\u7b97\u8fd4\u56denull")
    public Double avg(Object target) {
        OptionalDouble average = StreamExtension.arrayLikeToList(target).stream().filter(v -> v instanceof Number).mapToDouble(value -> ((Number)value).doubleValue()).average();
        return average.isPresent() ? Double.valueOf(average.getAsDouble()) : null;
    }

    @Comment(value="\u5bf9\u96c6\u5408\u8fdb\u884c\u7d2f\u52a0\u64cd\u4f5c")
    public Number sum(Object target) {
        return StreamExtension.arrayLikeToList(target).stream().filter(value -> value instanceof Number).mapToDouble(value -> ((Number)value).doubleValue()).sum();
    }

    @Comment(value="\u5bf9\u96c6\u5408\u8fdb\u884c\u5206\u7ec4")
    public Map<Object, List<Object>> group(Object target, @Comment(name="condition", value="\u5206\u7ec4\u6761\u4ef6\uff0c\u5982item=>item.xxx + '_' + item.yyy") Function<Object[], Object> condition) {
        return StreamExtension.arrayLikeToList(target).stream().collect(Collectors.groupingBy(item -> condition.apply(Stream.of(item).toArray()), LinkedHashMap::new, Collectors.toList()));
    }

    @Comment(value="\u5bf9\u96c6\u5408\u8fdb\u884c\u5206\u7ec4\u5e76\u8f6c\u6362")
    public Map<Object, Object> group(Object target, @Comment(name="condition", value="\u5206\u7ec4\u6761\u4ef6\uff0c\u5982item=>item.xxx + '_' + item.yyy") Function<Object[], Object> condition, @Comment(name="mapping", value="\u8f6c\u6362\u51fd\u6570\uff0c\u5982\u5206\u7ec4\u6c42\u548c(list)=>list.sum()") Function<Object[], Object> mapping) {
        return StreamExtension.arrayLikeToList(target).stream().collect(Collectors.groupingBy(item -> condition.apply(Stream.of(item).toArray()), LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> mapping.apply(Stream.of(list).toArray()))));
    }

    @Comment(value="\u5c06\u4e24\u4e2a\u96c6\u5408\u5173\u8054\u8d77\u6765")
    public List<Object> join(Object source, @Comment(name="target", value="\u53e6\u4e00\u4e2a\u96c6\u5408") Object target, @Comment(name="condition", value="\u5173\u8054\u6761\u4ef6\uff0c\u5982:(left,right)=>left.xxx = right.xxx") Function<Object[], Object> condition) {
        return this.join(source, target, condition, args -> {
            Object left = args[0];
            Object right = args[1];
            LinkedHashMap map = new LinkedHashMap();
            if (left instanceof Map) {
                map.putAll((Map)left);
            }
            if (right instanceof Map) {
                map.putAll((Map)right);
            }
            return map;
        });
    }

    @Comment(value="\u5c06\u4e24\u4e2a\u96c6\u5408\u5173\u8054\u5e76\u8f6c\u6362")
    public List<Object> join(Object source, @Comment(name="target", value="\u53e6\u4e00\u4e2a\u96c6\u5408") Object target, @Comment(name="condition", value="\u5173\u8054\u6761\u4ef6\uff0c\u5982:(left,right)=>left.xxx == right.xxx") Function<Object[], Object> condition, @Comment(name="mapping", value="\u6620\u5c04\u51fd\u6570\uff0c\u5982:(left,right)=>{xxx : left.xxx, yyy : right.yyy}") Function<Object[], Object> mapping) {
        if (target == null) {
            return null;
        }
        List<Object> targetList = StreamExtension.arrayLikeToList(target);
        return StreamExtension.arrayLikeToList(source).stream().map(left -> mapping.apply(Stream.of(left, targetList.stream().filter(right -> Objects.equals(true, condition.apply(Stream.of(left, right).toArray()))).findFirst().orElse(null)).toArray())).collect(Collectors.toList());
    }

    @Comment(value="\u622a\u53d6\u96c6\u5408", origin=true)
    public Object skip(Object source, @Comment(name="value", value="\u8df3\u8fc7\u7684\u6570\u91cf") int value) {
        return this.toOriginType(source, StreamExtension.arrayLikeToList(source).stream().skip(value).collect(Collectors.toList()));
    }

    @Comment(value="\u9650\u5236\u96c6\u5408\u6570\u91cf", origin=true)
    public Object limit(Object source, @Comment(name="value", value="\u8df3\u8fc7\u7684\u6570\u91cf") int value) {
        return this.toOriginType(source, StreamExtension.arrayLikeToList(source).stream().limit(value).collect(Collectors.toList()));
    }

    @Comment(value="\u5224\u65ad\u96c6\u5408\u662f\u5426\u90fd\u6ee1\u8db3\u6761\u4ef6")
    public boolean every(Object source, @Comment(name="condition", value="\u5224\u65ad\u6761\u4ef6") Function<Object[], Object> condition) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            if (BooleanLiteral.isTrue(condition.apply(new Object[]{objects.get(i), i}))) continue;
            return false;
        }
        return true;
    }

    @Comment(value="\u5224\u65ad\u96c6\u5408\u4e2d\u662f\u5426\u81f3\u5c11\u6709\u4e00\u4e2a\u5143\u7d20\u6ee1\u8db3\u6761\u4ef6")
    public boolean some(Object source, @Comment(name="condition", value="\u5224\u65ad\u6761\u4ef6") Function<Object[], Object> condition) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            if (!BooleanLiteral.isTrue(condition.apply(new Object[]{objects.get(i), i}))) continue;
            return true;
        }
        return false;
    }

    @Comment(value="\u627e\u5230\u96c6\u5408\u4e2d\u7b2c\u4e00\u4e2a\u4e0d\u4e3anull\u7684\u5143\u7d20")
    public Object findNotNull(Object source) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        for (Object object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Comment(value="\u5faa\u73af\u96c6\u5408\u901a\u8fc7\u7ed9\u5b9a\u7684\u8ba1\u7b97\u51fd\u6570\u8fd4\u56de\u4e00\u4e2a\u65b0\u503c")
    public Object reduce(Object source, @Comment(name="reduceFunction", value="\u5904\u7406\u51fd\u6570\uff0c\u5982\u7d2f\u52a0\u8ba1\u7b97\uff1a(val,item)=>val + item") Function<Object[], Object> reduceFunction) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        if (objects.isEmpty()) {
            return null;
        }
        int size = objects.size();
        if (size == 1) {
            return objects.get(0);
        }
        Object result = objects.get(0);
        for (int i = 1; i < size; ++i) {
            result = reduceFunction.apply(new Object[]{result, objects.get(i)});
        }
        return result;
    }

    @Comment(value="\u8fd4\u56de\u96c6\u5408\u4e2d\u7684\u7b2c\u4e00\u4e2a\u5143\u7d20")
    public static Object first(Object source) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        return objects.size() > 0 ? objects.get(0) : null;
    }

    @Comment(value="\u8fd4\u56de\u96c6\u5408\u4e2d\u7684\u6700\u540e\u4e00\u4e2a\u5143\u7d20")
    public Object last(Object source) {
        List<Object> objects = StreamExtension.arrayLikeToList(source);
        return objects.size() > 0 ? objects.get(objects.size() - 1) : null;
    }

    @Comment(value="\u8fd4\u56de\u96c6\u5408\u6216\u6570\u7ec4\u7684\u957f\u5ea6")
    public int size(Object arrayLike) {
        if (arrayLike instanceof Collection) {
            return ((Collection)arrayLike).size();
        }
        if (arrayLike.getClass().isArray()) {
            return Array.getLength(arrayLike);
        }
        if (arrayLike instanceof Iterator) {
            ArrayList list = new ArrayList();
            Iterator it = (Iterator)arrayLike;
            it.forEachRemaining(list::add);
            return list.size();
        }
        if (arrayLike instanceof Enumeration) {
            Enumeration en = (Enumeration)arrayLike;
            return Collections.list(en).size();
        }
        throw new MagicScriptException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + arrayLike.getClass());
    }

    @Comment(value="\u8fd4\u56de\u96c6\u5408\u6216\u6570\u7ec4\u7684\u957f\u5ea6")
    public int getLength(Object source) {
        return this.size(source);
    }
}

