/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.UUID;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalSyncHubCommandStep;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseSyncHubMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String hubConnectionId;
    @PropertyElement
    protected String hubProjectId;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        CommandScope syncHub = new CommandScope(InternalSyncHubCommandStep.COMMAND_NAME);
        syncHub.addArgumentValue(InternalSyncHubCommandStep.CHANGELOG_FILE_ARG, (Object)this.changeLogFile).addArgumentValue(InternalSyncHubCommandStep.URL_ARG, (Object)database.getConnection().getURL()).addArgumentValue(InternalSyncHubCommandStep.HUB_CONNECTION_ID_ARG, this.hubConnectionId != null ? UUID.fromString(this.hubConnectionId) : null).addArgumentValue(InternalSyncHubCommandStep.HUB_PROJECT_ID_ARG, this.hubProjectId != null ? UUID.fromString(this.hubProjectId) : null).addArgumentValue(InternalSyncHubCommandStep.DATABASE_ARG, (Object)database).addArgumentValue(InternalSyncHubCommandStep.FAIL_IF_OFFLINE_ARG, (Object)false);
        syncHub.execute();
    }
}

