/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.core.office.TemporaryException;

public abstract class AbstractRetryable<T extends Throwable> {
    protected AbstractRetryable() {
    }

    protected abstract void attempt() throws TemporaryException, T;

    public void execute(long interval, long timeout) throws RetryTimeoutException, T {
        this.execute(0L, interval, timeout);
    }

    public void execute(long delay, long interval, long timeout) throws RetryTimeoutException, T {
        long start = System.currentTimeMillis();
        if (delay > 0L) {
            this.sleep(delay);
        }
        while (true) {
            try {
                this.attempt();
                return;
            }
            catch (TemporaryException temporaryException) {
                if (System.currentTimeMillis() - start < timeout) {
                    this.sleep(interval);
                    continue;
                }
                throw new RetryTimeoutException(temporaryException.getCause());
            }
            break;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

