/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManager;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficeManagerPool
extends AbstractOfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPool.class);
    private static final int POOL_STOPPED = 0;
    private static final int POOL_STARTED = 1;
    private static final int POOL_SHUTDOWN = 2;
    protected static final int DEFAULT_POOL_SIZE = 1;
    private static final long DEFAULT_TASK_QUEUE_TIMEOUT = 30000L;
    private final AtomicInteger poolState = new AtomicInteger(0);
    private final long taskQueueTimeout;
    private final BlockingQueue<OfficeManager> pool;
    private List<OfficeManager> entries;

    protected AbstractOfficeManagerPool(@NonNull File workingDir, @Nullable Integer poolSize, @Nullable Long taskQueueTimeout) {
        super(workingDir);
        this.taskQueueTimeout = taskQueueTimeout == null ? 30000L : taskQueueTimeout;
        this.pool = new ArrayBlockingQueue<OfficeManager>(poolSize == null ? 1 : poolSize);
    }

    protected void setEntries(@NonNull List<@NonNull OfficeManager> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    @Override
    public final void execute(@NonNull OfficeTask task) throws OfficeException {
        if (!this.isRunning()) {
            throw new IllegalStateException("This office manager is not running.");
        }
        OfficeManager entry = null;
        try {
            entry = this.acquireManager();
            entry.execute(task);
        }
        finally {
            if (entry != null) {
                this.releaseManager(entry);
            }
        }
    }

    @Override
    public final boolean isRunning() {
        return this.poolState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                throw new IllegalStateException("This office manager has been shutdown.");
            }
            if (this.poolState.get() == 1) {
                throw new IllegalStateException("This office manager is already running.");
            }
            for (OfficeManager manager : this.entries) {
                manager.start();
                this.releaseManager(manager);
            }
            this.makeTempDir();
            this.poolState.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                return;
            }
            this.poolState.set(2);
            try {
                LOGGER.info("Stopping the office manager pool...");
                this.pool.clear();
                OfficeException firstException = null;
                for (OfficeManager manager : this.entries) {
                    try {
                        manager.stop();
                    }
                    catch (OfficeException ex) {
                        if (firstException != null) continue;
                        firstException = ex;
                    }
                }
                if (firstException != null) {
                    throw firstException;
                }
                LOGGER.info("Office manager stopped");
            }
            finally {
                this.deleteTempDir();
            }
        }
    }

    private OfficeManager acquireManager() throws OfficeException {
        try {
            OfficeManager manager = this.pool.poll(this.taskQueueTimeout, TimeUnit.MILLISECONDS);
            if (manager == null) {
                throw new OfficeException("No office manager available after " + this.taskQueueTimeout + " millisec.");
            }
            return manager;
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("Thread has been interrupted while waiting for a manager to become available.", interruptedEx);
        }
    }

    private void releaseManager(OfficeManager manager) throws OfficeException {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("interrupted", interruptedEx);
        }
    }

    public static abstract class AbstractOfficeManagerPoolBuilder<B extends AbstractOfficeManagerPoolBuilder<B>>
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<B> {
        protected Long taskExecutionTimeout;
        protected Long taskQueueTimeout;

        protected AbstractOfficeManagerPoolBuilder() {
        }

        public @NonNull B taskExecutionTimeout(@Nullable Long taskExecutionTimeout) {
            if (taskExecutionTimeout != null) {
                Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskExecutionTimeout, (String)String.format("taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout));
            }
            this.taskExecutionTimeout = taskExecutionTimeout;
            return (B)this;
        }

        public @NonNull B taskQueueTimeout(@Nullable Long taskQueueTimeout) {
            if (taskQueueTimeout != null) {
                Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskQueueTimeout, (String)String.format("taskQueueTimeout %s must greater than or equal to 0", taskQueueTimeout));
            }
            this.taskQueueTimeout = taskQueueTimeout;
            return (B)this;
        }
    }
}

