/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.job.DocumentSpecs;

public abstract class AbstractDocumentSpecs
implements DocumentSpecs {
    private final File file;
    private DocumentFormat documentFormat;

    protected AbstractDocumentSpecs(@NonNull File file) {
        Validate.notNull((Object)file, (String)"file must not be null", (Object[])new Object[0]);
        this.file = file;
    }

    @Override
    public @NonNull File getFile() {
        return this.file;
    }

    @Override
    public @Nullable DocumentFormat getFormat() {
        return this.documentFormat;
    }

    void setDocumentFormat(DocumentFormat documentFormat) {
        Validate.notNull((Object)documentFormat, (String)"documentFormat must not be null", (Object[])new Object[0]);
        this.documentFormat = documentFormat;
    }

    public @NonNull String toString() {
        return this.getClass().getSimpleName() + "{file=" + Optional.of(this.file).map(File::getName) + ", format=" + Optional.ofNullable(this.documentFormat).map(DocumentFormat::getExtension).orElse("null") + '}';
    }
}

