/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.ConversionJobWithOptionalSourceFormatUnspecified;
import org.jodconverter.core.job.SourceDocumentSpecsFromFile;
import org.jodconverter.core.job.SourceDocumentSpecsFromInputStream;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.TemporaryFileMaker;

public abstract class AbstractConverter
implements DocumentConverter {
    private static final boolean DEFAULT_CLOSE_STREAM = true;
    protected final OfficeManager officeManager;
    protected final DocumentFormatRegistry formatRegistry;

    protected AbstractConverter(@NonNull OfficeManager officeManager, @NonNull DocumentFormatRegistry formatRegistry) {
        Validate.notNull((Object)officeManager, (String)"officeManager must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)formatRegistry, (String)"formatRegistry must not be null", (Object[])new Object[0]);
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    @Override
    public @NonNull ConversionJobWithOptionalSourceFormatUnspecified convert(@NonNull File source) {
        SourceDocumentSpecsFromFile specs = new SourceDocumentSpecsFromFile(source);
        DocumentFormat format = this.formatRegistry.getFormatByExtension(FilenameUtils.getExtension((String)source.getName()));
        if (format != null) {
            specs.setDocumentFormat(format);
        }
        return this.convert(specs);
    }

    @Override
    public @NonNull ConversionJobWithOptionalSourceFormatUnspecified convert(@NonNull InputStream source) {
        return this.convert(source, true);
    }

    @Override
    public @NonNull ConversionJobWithOptionalSourceFormatUnspecified convert(@NonNull InputStream source, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.convert(new SourceDocumentSpecsFromInputStream(source, (TemporaryFileMaker)((Object)this.officeManager), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert InputStream");
    }

    protected abstract @NonNull AbstractConversionJobWithSourceFormatUnspecified convert(@NonNull AbstractSourceDocumentSpecs var1);

    @Override
    public @NonNull DocumentFormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    public static abstract class AbstractConverterBuilder<B extends AbstractConverterBuilder<B>> {
        protected OfficeManager officeManager;
        protected DocumentFormatRegistry formatRegistry;

        protected AbstractConverterBuilder() {
        }

        protected abstract @NonNull AbstractConverter build();

        public @NonNull B officeManager(@NonNull OfficeManager officeManager) {
            Validate.notNull((Object)officeManager, (String)"officeManager must not be null", (Object[])new Object[0]);
            this.officeManager = officeManager;
            return (B)this;
        }

        public @NonNull B formatRegistry(@NonNull DocumentFormatRegistry formatRegistry) {
            Validate.notNull((Object)formatRegistry, (String)"formatRegistry must not be null", (Object[])new Object[0]);
            this.formatRegistry = formatRegistry;
            return (B)this;
        }
    }
}

