/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormatRegistryException;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;

public final class DefaultDocumentFormatRegistryInstanceHolder {
    private static DocumentFormatRegistry instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull DocumentFormatRegistry getInstance() {
        Class<DocumentFormatRegistry> clazz = DocumentFormatRegistry.class;
        synchronized (DocumentFormatRegistry.class) {
            if (instance == null) {
                try (InputStream input = DefaultDocumentFormatRegistryInstanceHolder.class.getResourceAsStream("/document-formats.json");){
                    instance = JsonDocumentFormatRegistry.create(input);
                }
                catch (IOException ex) {
                    throw new DocumentFormatRegistryException("Unable to load the default document-formats.json configuration file", ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(@NonNull DocumentFormatRegistry registry) {
        Class<DocumentFormatRegistry> clazz = DocumentFormatRegistry.class;
        synchronized (DocumentFormatRegistry.class) {
            instance = registry;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private DefaultDocumentFormatRegistryInstanceHolder() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

