/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class RequestURITest {
    private static Server server;
    private static URI serverURI;

    public static Stream<Arguments> data() {
        ArrayList<Arguments> ret = new ArrayList<Arguments>();
        ret.add(Arguments.of((Object[])new Object[]{"/hello", "/hello", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%20world", "/hello%20world", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello;world", "/hello;world", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello:world", "/hello:world", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello!world", "/hello!world", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello?world", "/hello", "world"}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello?type=world", "/hello", "type=world"}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello?type=wo&rld", "/hello", "type=wo&rld"}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello?type=wo%20rld", "/hello", "type=wo%20rld"}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello?type=wo+rld", "/hello", "type=wo+rld"}));
        ret.add(Arguments.of((Object[])new Object[]{"/It%27s%20me%21", "/It%27s%20me%21", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%2fworld", "/hello%2fworld", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%2Fworld", "/hello%2Fworld", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/%2f%2Fhello%2Fworld", "/%2f%2Fhello%2Fworld", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%3Fworld", "/hello%3Fworld", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%252Fworld", "/hello%252Fworld", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello%u0025world", "/hello%u0025world", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello-euro-%E2%82%AC", "/hello-euro-%E2%82%AC", null}));
        ret.add(Arguments.of((Object[])new Object[]{"/hello-euro?%E2%82%AC", "/hello-euro", "%E2%82%AC"}));
        for (int i = 0; i < 31; ++i) {
            String raw = String.format("/hello%%%02Xworld", i);
            ret.add(Arguments.of((Object[])new Object[]{raw, raw, null}));
        }
        return ret.stream();
    }

    @BeforeAll
    public static void startServer() throws Exception {
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(RequestUriServlet.class, "/*");
        server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        serverURI = new URI(String.format("http://%s:%d/", host, port));
    }

    @AfterAll
    public static void stopServer() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected Socket newSocket(String host, int port) throws Exception {
        Socket socket = new Socket(host, port);
        socket.setSoTimeout(10000);
        socket.setTcpNoDelay(true);
        return socket;
    }

    protected static String readResponse(Socket client) throws IOException {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(client.getInputStream()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println(e + " while reading '" + sb + "'");
                throw e;
            }
        }
        br.close();
        return string;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetRequestURI_HTTP10(String rawpath, String expectedReqUri, String expectedQuery) throws Exception {
        try (Socket client = this.newSocket(serverURI.getHost(), serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            String request = String.format("GET %s HTTP/1.0\r\n\r\n", rawpath);
            os.write(request.getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = RequestURITest.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("RequestURI: " + expectedReqUri)));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("QueryString: " + expectedQuery)));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetRequestURI_HTTP11(String rawpath, String expectedReqUri, String expectedQuery) throws Exception {
        try (Socket client = this.newSocket(serverURI.getHost(), serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            String request = String.format("GET %s HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", rawpath, serverURI.getHost());
            os.write(request.getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = RequestURITest.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("RequestURI: " + expectedReqUri)));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)("QueryString: " + expectedQuery)));
        }
    }

    public static class RequestUriServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            out.println("RequestURI: " + req.getRequestURI());
            out.println("QueryString: " + req.getQueryString());
            out.print("FullURI: " + req.getRequestURI());
            if (req.getQueryString() != null) {
                out.print('?');
                out.print(req.getQueryString());
            }
            out.println();
        }
    }
}

