/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.common.database.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.shardingsphere.spi.database.type.BranchDatabaseType;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class DatabaseTypes {
    private static final Map<String, DatabaseType> DATABASE_TYPES = new HashMap<String, DatabaseType>();

    public static String getTrunkDatabaseTypeName(DatabaseType databaseType) {
        return databaseType instanceof BranchDatabaseType ? ((BranchDatabaseType)databaseType).getTrunkDatabaseType().getName() : databaseType.getName();
    }

    public static DatabaseType getTrunkDatabaseType(String name) {
        return DATABASE_TYPES.get(name) instanceof BranchDatabaseType ? ((BranchDatabaseType)DATABASE_TYPES.get(name)).getTrunkDatabaseType() : DatabaseTypes.getActualDatabaseType(name);
    }

    public static DatabaseType getActualDatabaseType(String name) {
        return Optional.ofNullable(DATABASE_TYPES.get(name)).orElseThrow(() -> new ShardingSphereException("Unsupported database:'%s'", name));
    }

    public static DatabaseType getDatabaseTypeByURL(String url) {
        return DATABASE_TYPES.values().stream().filter(each -> DatabaseTypes.matchStandardURL(url, each) || DatabaseTypes.matchURLAlias(url, each)).findAny().orElse(DATABASE_TYPES.get("SQL92"));
    }

    private static boolean matchStandardURL(String url, DatabaseType databaseType) {
        return url.startsWith(String.format("jdbc:%s:", databaseType.getName().toLowerCase()));
    }

    private static boolean matchURLAlias(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixAlias().stream().anyMatch(url::startsWith);
    }

    static {
        for (DatabaseType each : ServiceLoader.load(DatabaseType.class)) {
            DATABASE_TYPES.put(each.getName(), each);
        }
    }
}

