/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import javax.crypto.SecretKeyFactory;
import kafka.server.Defaults$;
import kafka.utils.CoreUtils$;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u000f\t\u0019\u0002+Y:to>\u0014H-\u00128d_\u0012,'\u000fV3ti*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\u0011i\u0016\u001cH/\u00128d_\u0012,G)Z2pI\u0016$\u0012A\u0006\t\u0003\u0013]I!\u0001\u0007\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003'i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b\"B\u0012\u0001\t\u0003)\u0012a\u0006;fgR,enY8eKJ\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\t\u0011#\u0004C\u0003'\u0001\u0011\u0005Q#\u0001\u000euKN$XI\\2pI\u0016$UmY8eK\u0006cwm\u001c:ji\"l7\u000f\u000b\u0002&5!)\u0011\u0006\u0001C\u0005U\u0005)b/\u001a:jMf,enY8eK\u0012\u0004\u0016m]:x_J$G\u0003\u0002\f,aeBQ\u0001\f\u0015A\u00025\nq!\u001a8d_\u0012,'\u000f\u0005\u0002\u0013]%\u0011qF\u0001\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\")\u0011\u0007\u000ba\u0001e\u0005A\u0001/Y:to>\u0014H\r\u0005\u00024m9\u0011\u0011\u0002N\u0005\u0003k)\ta\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QG\u0003\u0005\u0006u!\u0002\rAM\u0001\bK:\u001cw\u000eZ3e\u0001")
public class PasswordEncoderTest {
    @Test
    public void testEncodeDecode() {
        String string;
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)None$.MODULE$, Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), Defaults$.MODULE$.PasswordEncoderKeyLength(), Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)"4096", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assert.assertEquals((Object)"128", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        try {
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            string = "PBKDF2WithHmacSHA512";
        }
        catch (Exception exception) {
            string = "PBKDF2WithHmacSHA1";
        }
        String defaultKeyFactoryAlgorithm = string;
        Assert.assertEquals((Object)defaultKeyFactoryAlgorithm, (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assert.assertEquals((Object)"AES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        this.verifyEncodedPassword(encoder, password, encoded);
    }

    @Test
    public void testEncoderConfigChange() {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "DES/CBC/PKCS5Padding", 64, 1024);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)"1024", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assert.assertEquals((Object)"64", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        Assert.assertEquals((Object)"PBKDF2WithHmacSHA1", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assert.assertEquals((Object)"DES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        PasswordEncoder decoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 2048);
        Assert.assertEquals((Object)password, (Object)decoder.decode(encoded).value());
        PasswordEncoder decoder2 = new PasswordEncoder(new Password("secret-2"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 1024);
        try {
            decoder2.decode(encoded);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeDecodeAlgorithms() {
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DES/CBC/PKCS5Padding", 64);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DESede/CBC/PKCS5Padding", 192);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/OFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA1"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/GCM/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA256"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA512"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
    }

    private void verifyEncodedPassword(PasswordEncoder encoder, String password, String encoded) {
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)password.length())).toString(), (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()));
        Assert.assertNotNull((String)"Invalid salt", (Object)encoder.base64Decode((String)encodedMap.apply((Object)"salt")));
        Assert.assertNotNull((String)"Invalid encoding parameters", (Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        Assert.assertNotNull((String)"Invalid encoded password", (Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp())));
        Assert.assertEquals((Object)password, (Object)encoder.decode(encoded).value());
    }

    private final void verifyEncodeDecode$1(Option keyFactoryAlg, String cipherAlg, int keyLength) {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), keyFactoryAlg, cipherAlg, keyLength, Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        this.verifyEncodedPassword(encoder, password, encoded);
    }
}

