// Autogenerated Jamon implementation
// /home/busbey/projects/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 27, 1
import java.util.*;
// 28, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 29, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 30, 1
import org.apache.hadoop.hbase.ServerName;
// 31, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 33, 1
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 34, 1
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String bcn;
  private final String bcv;
  private final String filter;
  private final String format;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getBcn__IsNotDefault())
    {
      p_implData.setBcn("");
    }
    if(! p_implData.getBcv__IsNotDefault())
    {
      p_implData.setBcv("");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    bcn = p_implData.getBcn();
    bcv = p_implData.getBcv();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 37, 1
    if (format.equals("json") && bcn != null && bcn.length() > 0  )
    {
      // 37, 66
      jamonWriter.write("\n  ");
      // 38, 3
      {
        org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl(this.getTemplateManager());
        __jamon__var_6.renderNoFlush(jamonWriter, regionServer.getCacheConfig(), regionServer.getConfiguration(), bcn, bcv);
      }
      // 38, 136
      jamonWriter.write("\n  ");
      // 39, 3
      return; 
    }
    // 40, 1
    else if (format.equals("json") )
    {
      // 40, 34
      jamonWriter.write("\n  ");
      // 41, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 41, 68
      jamonWriter.write("\n  ");
      // 42, 3
      return; 
    }
    // 43, 7
    jamonWriter.write("\n");
    // 44, 1
    
  ServerInfo serverInfo = ProtobufUtil.getServerInfo(null, regionServer.getRSRpcServices());
  ServerName serverName = ProtobufUtil.toServerName(serverInfo.getServerName());
  List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(regionServer.getRSRpcServices());
  MasterAddressTracker masterAddressTracker = regionServer.getMasterAddressTracker();
  ServerName masterServerName = masterAddressTracker == null ? null
    : masterAddressTracker.getMasterAddress();
  int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();

    // 53, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
    // 60, 33
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
    // 60, 63
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 88, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 88, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 90, 23
    jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
    // 100, 37
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 100, 53
    jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
    // 107, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl(this.getTemplateManager());
      __jamon__var_8.renderNoFlush(jamonWriter, regionServer.getRegionServerMetrics().getRegionServerWrapper(), regionServer.getRpcServer().getMetrics().getHBaseServerWrapper());
    }
    // 108, 89
    jamonWriter.write("\n    </section>\n\n    <section>\n    ");
    // 112, 5
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_9.setFilter(filter );
      __jamon__var_9.renderNoFlush(jamonWriter);
    }
    // 112, 53
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Block Cache</h2>\n    ");
    // 117, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl(this.getTemplateManager());
      __jamon__var_10.renderNoFlush(jamonWriter, regionServer.getCacheConfig(), regionServer.getConfiguration() );
    }
    // 117, 112
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
    // 122, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl(this.getTemplateManager());
      __jamon__var_11.renderNoFlush(jamonWriter, regionServer, onlineRegions);
    }
    // 122, 86
    jamonWriter.write("\n    </section>\n\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
    // 136, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 136, 76
    jamonWriter.write(", revision=");
    // 136, 87
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 136, 147
    jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
    // 141, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 141, 73
    jamonWriter.write(", ");
    // 141, 75
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 141, 131
    jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>HBase Source Checksum</td>\n            <td>");
    // 146, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 146, 80
    jamonWriter.write("</td>\n            <td>HBase source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>Hadoop Version</td>\n            <td>");
    // 151, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 151, 70
    jamonWriter.write(", revision=");
    // 151, 81
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 151, 135
    jamonWriter.write("</td>\n            <td>Hadoop version and revision</td>\n        </tr>\n        <tr>\n            <td>Hadoop Compiled</td>\n            <td>");
    // 156, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 156, 67
    jamonWriter.write(", ");
    // 156, 69
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 156, 119
    jamonWriter.write("</td>\n            <td>When Hadoop version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Hadoop Source Checksum</td>\n            <td>");
    // 161, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 161, 74
    jamonWriter.write("</td>\n            <td>Hadoop source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Version</td>\n            <td>");
    // 166, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 166, 64
    jamonWriter.write(", revision=");
    // 166, 75
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 166, 123
    jamonWriter.write("</td>\n            <td>ZooKeeper client version and revision</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Compiled</td>\n            <td>");
    // 171, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 171, 66
    jamonWriter.write("</td>\n            <td>When ZooKeeper client version was compiled</td>\n        </tr>\n        <tr>\n            <td>Zookeeper Quorum</td>\n            <td>");
    // 176, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(regionServer.getZooKeeper().getQuorum()), jamonWriter);
    // 176, 62
    jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
    // 181, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getRegionServerCoprocessors())), jamonWriter);
    // 181, 92
    jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
    // 186, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 186, 60
    jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
    // 192, 17
    if (masterServerName == null )
    {
      // 192, 49
      jamonWriter.write("\n                No master found\n                ");
    }
    // 194, 17
    else
    {
      // 194, 24
      jamonWriter.write("\n                ");
      // 195, 17
      
                String host = masterServerName.getHostname() + ":" + infoPort;
                String url = "//" + host + "/master-status";
                
      // 199, 17
      jamonWriter.write("<a href=\"");
      // 199, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 199, 35
      jamonWriter.write("\">");
      // 199, 37
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 199, 47
      jamonWriter.write("</a>\n                ");
    }
    // 200, 23
    jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n");
  }
  
  
}
