/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.NoPauseDetector;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.noop.NoopCounter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.noop.NoopFunctionCounter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import io.micrometer.core.instrument.noop.NoopGauge;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import io.micrometer.core.instrument.noop.NoopMeter;
import io.micrometer.core.instrument.noop.NoopTimeGauge;
import io.micrometer.core.instrument.noop.NoopTimer;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.org.pcollections.HashTreePMap;
import io.micrometer.shaded.org.pcollections.PMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public abstract class MeterRegistry
implements AutoCloseable {
    protected final Clock clock;
    private final Object meterMapLock = new Object();
    private final List<MeterFilter> filters = new CopyOnWriteArrayList<MeterFilter>();
    private final List<Consumer<Meter>> meterAddedListeners = new CopyOnWriteArrayList<Consumer<Meter>>();
    private final Config config = new Config();
    private final More more = new More();
    private volatile PMap<Meter.Id, Meter> meterMap = HashTreePMap.empty();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private PauseDetector pauseDetector = new NoPauseDetector();
    private NamingConvention namingConvention = NamingConvention.snakeCase;

    protected MeterRegistry(Clock clock) {
        Objects.requireNonNull(clock);
        this.clock = clock;
    }

    protected abstract <T> Gauge newGauge(Meter.Id var1, @Nullable T var2, ToDoubleFunction<T> var3);

    protected abstract Counter newCounter(Meter.Id var1);

    protected abstract LongTaskTimer newLongTaskTimer(Meter.Id var1);

    protected abstract Timer newTimer(Meter.Id var1, DistributionStatisticConfig var2, PauseDetector var3);

    protected abstract DistributionSummary newDistributionSummary(Meter.Id var1, DistributionStatisticConfig var2, double var3);

    protected abstract Meter newMeter(Meter.Id var1, Meter.Type var2, Iterable<Measurement> var3);

    protected <T> TimeGauge newTimeGauge(Meter.Id id, T obj, TimeUnit valueFunctionUnit, ToDoubleFunction<T> valueFunction) {
        final Meter.Id withUnit = id.withBaseUnit(this.getBaseTimeUnitStr());
        final Gauge gauge = this.newGauge(withUnit, obj, obj2 -> TimeUtils.convert(valueFunction.applyAsDouble(obj2), valueFunctionUnit, this.getBaseTimeUnit()));
        return new TimeGauge(){

            @Override
            public Meter.Id getId() {
                return withUnit;
            }

            @Override
            public double value() {
                return gauge.value();
            }

            @Override
            public TimeUnit baseTimeUnit() {
                return MeterRegistry.this.getBaseTimeUnit();
            }
        };
    }

    protected abstract <T> FunctionTimer newFunctionTimer(Meter.Id var1, T var2, ToLongFunction<T> var3, ToDoubleFunction<T> var4, TimeUnit var5);

    protected abstract <T> FunctionCounter newFunctionCounter(Meter.Id var1, T var2, ToDoubleFunction<T> var3);

    protected List<Tag> getConventionTags(Meter.Id id) {
        return id.getConventionTags(this.config().namingConvention());
    }

    protected String getConventionName(Meter.Id id) {
        return id.getConventionName(this.config().namingConvention());
    }

    protected abstract TimeUnit getBaseTimeUnit();

    protected abstract DistributionStatisticConfig defaultHistogramConfig();

    private String getBaseTimeUnitStr() {
        return this.getBaseTimeUnit().toString().toLowerCase();
    }

    Counter counter(Meter.Id id) {
        return this.registerMeterIfNecessary(Counter.class, id, this::newCounter, NoopCounter::new);
    }

    <T> Gauge gauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return this.registerMeterIfNecessary(Gauge.class, id, id2 -> this.newGauge((Meter.Id)id2, obj, valueFunction), NoopGauge::new);
    }

    Timer timer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetectorOverride) {
        return this.registerMeterIfNecessary(Timer.class, id, distributionStatisticConfig, (id2, filteredConfig) -> {
            Meter.Id withUnit = id2.withBaseUnit(this.getBaseTimeUnitStr());
            return this.newTimer(withUnit, filteredConfig.merge(this.defaultHistogramConfig()), pauseDetectorOverride);
        }, NoopTimer::new);
    }

    DistributionSummary summary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return this.registerMeterIfNecessary(DistributionSummary.class, id, distributionStatisticConfig, (id2, filteredConfig) -> this.newDistributionSummary((Meter.Id)id2, filteredConfig.merge(this.defaultHistogramConfig()), scale), NoopDistributionSummary::new);
    }

    Meter register(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return this.registerMeterIfNecessary(Meter.class, id, id2 -> this.newMeter((Meter.Id)id2, type, measurements), NoopMeter::new);
    }

    public List<Meter> getMeters() {
        return Collections.unmodifiableList(new ArrayList(this.meterMap.values()));
    }

    public void forEachMeter(Consumer<? super Meter> consumer) {
        this.meterMap.values().forEach(consumer);
    }

    public Config config() {
        return this.config;
    }

    public Search find(String name) {
        return Search.in(this).name(name);
    }

    public RequiredSearch get(String name) {
        return RequiredSearch.in(this).name(name);
    }

    public Counter counter(String name, Iterable<Tag> tags) {
        return Counter.builder(name).tags(tags).register(this);
    }

    public Counter counter(String name, String ... tags) {
        return this.counter(name, Tags.of(tags));
    }

    public DistributionSummary summary(String name, Iterable<Tag> tags) {
        return DistributionSummary.builder(name).tags(tags).register(this);
    }

    public DistributionSummary summary(String name, String ... tags) {
        return this.summary(name, Tags.of(tags));
    }

    public Timer timer(String name, Iterable<Tag> tags) {
        return Timer.builder(name).tags(tags).register(this);
    }

    public Timer timer(String name, String ... tags) {
        return this.timer(name, Tags.of(tags));
    }

    public More more() {
        return this.more;
    }

    @Nullable
    public <T> T gauge(String name, Iterable<Tag> tags, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        Gauge.builder(name, obj, valueFunction).tags(tags).register(this);
        return obj;
    }

    @Nullable
    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)this.gauge(name, tags, number, Number::doubleValue);
    }

    @Nullable
    public <T extends Number> T gauge(String name, T number) {
        return this.gauge(name, Collections.emptyList(), number);
    }

    @Nullable
    public <T> T gauge(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return this.gauge(name, Collections.emptyList(), obj, valueFunction);
    }

    @Nullable
    public <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)this.gauge(name, tags, collection, Collection::size);
    }

    @Nullable
    public <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)this.gauge(name, tags, map, Map::size);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, Function<Meter.Id, M> builder, Function<Meter.Id, M> noopBuilder) {
        return (M)this.registerMeterIfNecessary(meterClass, id, null, (id2, conf) -> (Meter)builder.apply((Meter.Id)id2), noopBuilder);
    }

    private <M extends Meter> M registerMeterIfNecessary(Class<M> meterClass, Meter.Id id, @Nullable DistributionStatisticConfig config, BiFunction<Meter.Id, DistributionStatisticConfig, M> builder, Function<Meter.Id, M> noopBuilder) {
        Meter m;
        Meter.Id mappedId = id;
        if (!id.isSynthetic()) {
            for (MeterFilter filter : this.filters) {
                mappedId = filter.map(mappedId);
            }
        }
        if (!meterClass.isInstance(m = this.getOrCreateMeter(config, builder, id, mappedId, noopBuilder))) {
            throw new IllegalArgumentException("There is already a registered meter of a different type with the same name");
        }
        return (M)((Meter)meterClass.cast(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meter getOrCreateMeter(@Nullable DistributionStatisticConfig config, BiFunction<Meter.Id, DistributionStatisticConfig, ? extends Meter> builder, Meter.Id originalId, Meter.Id mappedId, Function<Meter.Id, ? extends Meter> noopBuilder) {
        Meter m = (Meter)this.meterMap.get(mappedId);
        if (m == null) {
            if (this.isClosed()) {
                return noopBuilder.apply(mappedId);
            }
            Object object = this.meterMapLock;
            synchronized (object) {
                m = (Meter)this.meterMap.get(mappedId);
                if (m == null) {
                    if (!this.accept(originalId)) {
                        return noopBuilder.apply(mappedId);
                    }
                    if (config != null) {
                        for (MeterFilter meterFilter : this.filters) {
                            DistributionStatisticConfig filteredConfig = meterFilter.configure(mappedId, config);
                            if (filteredConfig == null) continue;
                            config = filteredConfig;
                        }
                    }
                    m = builder.apply(mappedId, config);
                    this.meterMap = this.meterMap.plus(mappedId, m);
                    for (Consumer consumer : this.meterAddedListeners) {
                        consumer.accept(m);
                    }
                }
            }
        }
        return m;
    }

    private boolean accept(Meter.Id id) {
        for (MeterFilter filter : this.filters) {
            MeterFilterReply reply = filter.accept(id);
            if (reply == MeterFilterReply.DENY) {
                return false;
            }
            if (reply != MeterFilterReply.ACCEPT) continue;
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object object = this.meterMapLock;
            synchronized (object) {
                for (Meter meter : this.meterMap.values()) {
                    meter.close();
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public class More {
        public LongTaskTimer longTaskTimer(String name, String ... tags) {
            return this.longTaskTimer(name, Tags.of(tags));
        }

        public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
            return LongTaskTimer.builder(name).tags(tags).register(MeterRegistry.this);
        }

        LongTaskTimer longTaskTimer(Meter.Id id) {
            return (LongTaskTimer)MeterRegistry.this.registerMeterIfNecessary(LongTaskTimer.class, id, id2 -> {
                Meter.Id withUnit = id2.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newLongTaskTimer(withUnit);
            }, NoopLongTaskTimer::new);
        }

        public <T> FunctionCounter counter(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> countFunction) {
            return FunctionCounter.builder(name, obj, countFunction).tags(tags).register(MeterRegistry.this);
        }

        public <T extends Number> FunctionCounter counter(String name, Iterable<Tag> tags, T number) {
            return FunctionCounter.builder(name, number, Number::doubleValue).tags(tags).register(MeterRegistry.this);
        }

        <T> FunctionCounter counter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
            return (FunctionCounter)MeterRegistry.this.registerMeterIfNecessary(FunctionCounter.class, id, id2 -> MeterRegistry.this.newFunctionCounter((Meter.Id)id2, obj, countFunction), NoopFunctionCounter::new);
        }

        public <T> FunctionTimer timer(String name, Iterable<Tag> tags, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
            return FunctionTimer.builder(name, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit).tags(tags).register(MeterRegistry.this);
        }

        <T> FunctionTimer timer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
            return (FunctionTimer)MeterRegistry.this.registerMeterIfNecessary(FunctionTimer.class, id, id2 -> {
                Meter.Id withUnit = id2.withBaseUnit(MeterRegistry.this.getBaseTimeUnitStr());
                return MeterRegistry.this.newFunctionTimer(withUnit, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit);
            }, NoopFunctionTimer::new);
        }

        public <T> TimeGauge timeGauge(String name, Iterable<Tag> tags, T obj, TimeUnit timeFunctionUnit, ToDoubleFunction<T> timeFunction) {
            return TimeGauge.builder(name, obj, timeFunctionUnit, timeFunction).tags(tags).register(MeterRegistry.this);
        }

        <T> TimeGauge timeGauge(Meter.Id id, T obj, TimeUnit timeFunctionUnit, ToDoubleFunction<T> timeFunction) {
            return (TimeGauge)MeterRegistry.this.registerMeterIfNecessary(TimeGauge.class, id, id2 -> MeterRegistry.this.newTimeGauge((Meter.Id)id2, obj, timeFunctionUnit, timeFunction), NoopTimeGauge::new);
        }
    }

    public class Config {
        public Config commonTags(Iterable<Tag> tags) {
            this.meterFilter(MeterFilter.commonTags(tags));
            return this;
        }

        public Config commonTags(String ... tags) {
            return this.commonTags(Tags.of(tags));
        }

        public Config meterFilter(MeterFilter filter) {
            MeterRegistry.this.filters.add(filter);
            return this;
        }

        public Config onMeterAdded(Consumer<Meter> meter) {
            MeterRegistry.this.meterAddedListeners.add(meter);
            return this;
        }

        public Config namingConvention(NamingConvention convention) {
            MeterRegistry.this.namingConvention = convention;
            return this;
        }

        public NamingConvention namingConvention() {
            return MeterRegistry.this.namingConvention;
        }

        public Clock clock() {
            return MeterRegistry.this.clock;
        }

        public Config pauseDetector(PauseDetector detector) {
            MeterRegistry.this.pauseDetector = detector;
            return this;
        }

        public PauseDetector pauseDetector() {
            return MeterRegistry.this.pauseDetector;
        }
    }
}

