/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.producer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.util.HashUtil;
import com.ztesoft.zsmart.nros.base.zmq.config.ZMQConfig;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import com.ztesoft.zsmart.nros.base.zmq.producer.AbstractZMQCheckHandler;
import com.ztesoft.zsmart.nros.base.zmq.producer.DefaultZMQProducer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTZMQProducer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZMQConfig zmqCfg;
    private static Map<String, TransactionProducer> producerMap = new HashMap<String, TransactionProducer>();

    public TransactionProducer getTProducer(String groupId, Class handlerClass) {
        TransactionProducer producer = producerMap.get(groupId);
        if (null == producer) {
            producer = this.getProducer(groupId, handlerClass);
            producerMap.put(groupId, producer);
            return producer;
        }
        return producer;
    }

    @PreDestroy
    private void shutdown() {
        try {
            for (Map.Entry<String, TransactionProducer> next : producerMap.entrySet()) {
                TransactionProducer producer = next.getValue();
                if (producer == null || !producer.isStarted()) continue;
                producer.shutdown();
                this.logger.error("MQ Msg producer shutdown successfully");
            }
        }
        catch (ONSClientException e) {
            this.logger.error("MQ Msg producer shutdown error-->", (Throwable)e);
        }
    }

    private TransactionProducer getProducer(String groupId, Class handlerClass) {
        if (this.zmqCfg.isEnabled()) {
            if (groupId == null || groupId.isEmpty()) {
                throw new BusiException("!!!!!! ProducerId is null or empty, a default groupId[" + groupId + "] was generated");
            }
            Properties properties = new Properties();
            properties.setProperty("GROUP_ID", groupId);
            properties.setProperty("AccessKey", this.zmqCfg.getAccessKey());
            properties.setProperty("SecretKey", this.zmqCfg.getSecretKey());
            properties.setProperty("SendMsgTimeoutMillis", this.zmqCfg.getProducerSendTimeout());
            properties.setProperty("NAMESRV_ADDR", this.zmqCfg.getGlobalNamesrvAddr());
            try {
                this.logger.info(" ############## Begin to create ZMQ Producer id@" + groupId);
                AbstractZMQCheckHandler abstractZMQCheckHandler = (AbstractZMQCheckHandler)handlerClass.newInstance();
                TransactionProducer producer = ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)abstractZMQCheckHandler);
                producer.start();
                this.logger.info(" ############## ZMQ Producer id@" + groupId + " created success.");
                return producer;
            }
            catch (ONSClientException e) {
                this.logger.error("MQ Msg producer id@" + groupId + " created error-->", (Throwable)e);
                throw new BusiException("500", "MQ Msg producer id@" + groupId + " created error @" + DefaultZMQProducer.class);
            }
            catch (Exception e) {
                this.logger.error("MQ Msg producer id@" + groupId + " handler error-->", (Throwable)e);
                throw new BusiException("500", "MQ Msg producer id@" + groupId + " handler error @" + DefaultZMQProducer.class);
            }
        }
        return null;
    }

    public SendResult sendMessage(TransactionProducer producer, final NrosMQMessage nrosMQMessage, Class handlerClass, final Object args) throws ONSClientException {
        try {
            final AbstractZMQCheckHandler abstractZMQCheckHandler = (AbstractZMQCheckHandler)handlerClass.newInstance();
            SendResult sendResult = producer.send(nrosMQMessage.getMqMessage(), new LocalTransactionExecuter(){

                public TransactionStatus execute(Message msg, Object arg) {
                    String msgId = msg.getMsgID();
                    long crc32Id = HashUtil.crc32Code(msg.getBody());
                    TransactionStatus transactionStatus = TransactionStatus.Unknow;
                    try {
                        boolean isCommit = abstractZMQCheckHandler.execbusinessService(nrosMQMessage, args);
                        transactionStatus = isCommit ? TransactionStatus.CommitTransaction : TransactionStatus.RollbackTransaction;
                    }
                    catch (Exception e) {
                        DefaultTZMQProducer.this.logger.error("Message Id:{}", (Object)msgId, (Object)e);
                    }
                    DefaultTZMQProducer.this.logger.warn("Message Id:{}transactionStatus:{}", (Object)msgId, (Object)transactionStatus.name());
                    return transactionStatus;
                }
            }, null);
            return sendResult;
        }
        catch (Exception e) {
            this.logger.error(new Date() + " Send mq message failed. Topic is:" + nrosMQMessage.getMsgId() + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

