/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZMQHandler
implements MessageListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public Action consume(Message message, ConsumeContext consumeContext) {
        this.logger.info("#########ZMQHandler consume msg-->" + message.getTopic() + " " + message.getTag() + " " + new String(message.getBody(), Charset.forName("UTF-8")));
        NrosMQMessage nrosMsg = null;
        try {
            nrosMsg = NrosMQMessage.convertFromMQMessage(message);
            if (null != nrosMsg.getUserId()) {
                this.logger.info("#########ZMQHandler consume msg hasValidSessionByUserId ->." + SessionUtils.hasValidSessionByUserId(nrosMsg.getUserId() + ""));
            }
            return this.doBusinesses(nrosMsg, consumeContext);
        }
        catch (BusiException e) {
            this.logger.error(e.toString());
            return Action.ReconsumeLater;
        }
    }

    public abstract Action doBusinesses(NrosMQMessage var1, ConsumeContext var2);
}

