/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.paas;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.FileUtils;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={OSSClient.class})
public class OssUtils {
    private Logger logger = LoggerFactory.getLogger(OssUtils.class);
    @Value(value="${nros.oss.public.bucket:public-nros-bucket}")
    private String OSS_PUBLIC_BUCKET_NAME;
    @Value(value="${nros.oss.private.bucket:private-nros-bucket}")
    private String OSS_PRIVATE_BUCKET_NAME;
    @Value(value="${nros.oss.root.path:common}")
    private String OSS_ROOT_PATH;
    @Value(value="${nros.oss.extranet.endpoint}")
    private String OSS_EXTRANET_END_POINT;
    @Value(value="${nros.oss.expires.time:300}")
    private Integer OSS_EXPIRES_TIME;
    @Resource(name="ossClient")
    private OSSClient ossClient;
    @Resource(name="publicOssClient")
    private OSSClient publicOssClient;
    private static final Date OSS_URL_EXPIRATION = DateUtils.addMinutes((Date)new Date(), (int)5);

    public String upLoad(File file) {
        this.logger.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb--------");
        if (null == this.publicOssClient) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(new Date());
        if (file == null) {
            return null;
        }
        try {
            if (!this.publicOssClient.doesBucketExist(this.OSS_PUBLIC_BUCKET_NAME)) {
                this.publicOssClient.createBucket(this.OSS_PUBLIC_BUCKET_NAME);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.OSS_PUBLIC_BUCKET_NAME);
                createBucketRequest.setCannedACL(CannedAccessControlList.Private);
                this.publicOssClient.createBucket(createBucketRequest);
            }
            String name = file.getName();
            String fileExtension = FileUtils.getFileExtension(name);
            String fileUrl = this.OSS_ROOT_PATH + "/" + dateStr + "/" + UUID.randomUUID().toString().replace("-", "") + fileExtension;
            PutObjectResult result = this.publicOssClient.putObject(new PutObjectRequest(this.OSS_PUBLIC_BUCKET_NAME, fileUrl, file));
            if (result != null) {
                this.logger.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
            return this.getUrl(fileUrl);
        }
        catch (OSSException oe) {
            this.logger.error(oe.getMessage());
        }
        catch (ClientException ce) {
            this.logger.error(ce.getErrorMessage());
        }
        return null;
    }

    private String getUrl(String fileUrl) {
        if (StringUtils.isEmpty((CharSequence)fileUrl)) {
            this.logger.error("{}", (Object)"\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
            ExceptionHandler.publish("BASE-SYS-00001", "\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] split = this.OSS_EXTRANET_END_POINT.split("//");
        stringBuilder.append(split[0]).append("//").append(this.OSS_PUBLIC_BUCKET_NAME).append(".").append(split[1]).append("/").append(fileUrl);
        String url = stringBuilder.toString();
        return url;
    }

    public String upLoadPrivate(File file) {
        this.logger.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb--------");
        if (null == this.ossClient) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(new Date());
        try {
            if (!this.ossClient.doesBucketExist(this.OSS_PRIVATE_BUCKET_NAME)) {
                this.ossClient.createBucket(this.OSS_PRIVATE_BUCKET_NAME);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.OSS_PRIVATE_BUCKET_NAME);
                createBucketRequest.setCannedACL(CannedAccessControlList.Private);
                this.ossClient.createBucket(createBucketRequest);
            }
            String name = file.getName();
            String fileExtension = FileUtils.getFileExtension(name);
            String fileUrl = this.OSS_ROOT_PATH + "/" + dateStr + "/" + UUID.randomUUID().toString().replace("-", "") + fileExtension;
            PutObjectResult result = this.ossClient.putObject(new PutObjectRequest(this.OSS_PRIVATE_BUCKET_NAME, fileUrl, file));
            if (result != null) {
                this.logger.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
            Date expiration = new Date(System.currentTimeMillis() + (long)(this.OSS_EXPIRES_TIME * 1000));
            URL url = this.ossClient.generatePresignedUrl(this.OSS_PRIVATE_BUCKET_NAME, fileUrl, expiration);
            return this.getPrivateUrl(url.toString());
        }
        catch (OSSException var6) {
            this.logger.error(var6.getMessage());
        }
        catch (ClientException var7) {
            this.logger.error(var7.getErrorMessage());
        }
        return null;
    }

    private String getPrivateUrl(String fileUrl) {
        if (StringUtils.isEmpty((CharSequence)fileUrl)) {
            this.logger.error("{}", (Object)"\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
            ExceptionHandler.publish("BASE-SYS-00001", "\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] split = this.OSS_EXTRANET_END_POINT.split("//");
        String[] fileUrlSplit = fileUrl.split(".com");
        stringBuilder.append(split[0]).append("//").append(this.OSS_PRIVATE_BUCKET_NAME).append(".").append(split[1]).append(fileUrlSplit[1]);
        String url = stringBuilder.toString();
        return url;
    }
}

