/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.paas;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class CacheUtils {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void removePattern(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public void hmSet(String key, Object hashKey, Object value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put((Object)key, hashKey, value);
    }

    public Object hmGet(String key, Object hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.get((Object)key, hashKey);
    }

    public Map hmEntries(String key) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.entries((Object)key);
    }

    public void hmDel(String key, Object ... hashKeys) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.delete((Object)key, hashKeys);
    }

    public void lPush(String k, Object v) {
        ListOperations list = this.redisTemplate.opsForList();
        list.rightPush((Object)k, v);
    }

    public List<Object> lRange(String k, long l, long l1) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)k, l, l1);
    }

    public void add(String key, Object value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.add((Object)key, new Object[]{value});
    }

    public void removeSet(String key, Object ... value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.remove((Object)key, value);
    }

    public Set<Object> setMembers(String key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members((Object)key);
    }

    public void zAdd(String key, Object value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, value, scoure);
    }

    public Set<Object> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public void setExpireTime(String key, long timeout) {
        Long expiredTime = this.redisTemplate.getExpire((Object)key);
        if (expiredTime > -1L) {
            this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
        }
    }
}

