/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.event.WriteHandler;
import com.alibaba.excel.metadata.BaseRowModel;
import com.ztesoft.zsmart.nros.base.util.excel.CellStyleFormat;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterHandler07<T extends Class<? extends BaseRowModel>>
implements WriteHandler {
    private static final Logger log = LoggerFactory.getLogger(WriterHandler07.class);
    private Map<Integer, CellStyleFormat> colStyleFormat = new HashMap<Integer, CellStyleFormat>();
    private Map<Integer, CellStyle> colStyle = new HashMap<Integer, CellStyle>();
    private Map<String, String> infoMap = new HashMap<String, String>();
    private static final String TITLE_NUM = "title_num";

    WriterHandler07(T rowModel) {
        this.init(rowModel);
    }

    private void init(T rowModel) {
        Field[] declaredFields = ((Class)rowModel).getDeclaredFields();
        int titleNum = 0;
        for (Field field : declaredFields) {
            CellStyleFormat cellStyle = field.getAnnotation(CellStyleFormat.class);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty != null) {
                titleNum = Math.max(excelProperty.value().length, titleNum);
            }
            if (cellStyle == null || excelProperty == null) continue;
            this.colStyleFormat.put(excelProperty.index(), cellStyle);
        }
        this.infoMap.put(TITLE_NUM, String.valueOf(titleNum));
    }

    public void sheet(int sheetNo, Sheet sheet) {
        for (Map.Entry<Integer, CellStyleFormat> entry : this.colStyleFormat.entrySet()) {
            this.colStyle.put(entry.getKey(), WriterHandler07.getCellStyle(sheet, entry.getValue()));
        }
    }

    public void row(int rowNum, Row row) {
    }

    public void cell(int cellNum, Cell cell) {
        CellStyle cellStyle = this.colStyle.get(cellNum);
        if (cell.getRowIndex() <= Integer.valueOf(this.infoMap.get(TITLE_NUM)) - 1) {
            return;
        }
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
    }

    private static CellStyle getCellStyle(Sheet sheet, CellStyleFormat value) {
        CellStyle style = sheet.getWorkbook().createCellStyle();
        style.setFillForegroundColor(value.fillBackgroundColor().index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(value.horizontalAlignment());
        Font font = sheet.getWorkbook().createFont();
        font.setFontName(value.cellFont().fontName());
        font.setColor(value.cellFont().fontColor().index);
        font.setFontHeightInPoints(value.cellFont().fontHeightInPoints());
        font.setBold(value.cellFont().bold());
        style.setFont(font);
        return style;
    }
}

