/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.excel;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriterFactory
extends ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriterFactory.class);
    private OutputStream outputStream;
    private int sheetNo = 1;

    ExcelWriterFactory(OutputStream outputStream, ExcelTypeEnum typeEnum) {
        super(outputStream, typeEnum);
        this.outputStream = outputStream;
    }

    public ExcelWriterFactory write(List<? extends BaseRowModel> list, String sheetName, BaseRowModel object) {
        ++this.sheetNo;
        try {
            Sheet sheet = new Sheet(this.sheetNo, 0, object.getClass());
            sheet.setSheetName(sheetName);
            this.write(list, sheet);
        }
        catch (Exception ex) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return this;
    }

    public void finish() {
        super.finish();
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }
}

