/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.excel.ExcelListener;
import com.ztesoft.zsmart.nros.base.util.excel.ExcelWriterFactory;
import com.ztesoft.zsmart.nros.base.util.excel.MyBeanCopy;
import com.ztesoft.zsmart.nros.base.util.excel.WriterHandler07;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    private ExcelUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseRowModel> void writeExcel(HttpServletResponse response, List<T> list, String fileName, ExcelTypeEnum excelTypeEnum, String sheetName, Class<T> classType) throws Exception {
        if (sheetName == null || "".equals(sheetName)) {
            sheetName = "sheet1";
        }
        if (excelTypeEnum == ExcelTypeEnum.XLSX) {
            ExcelWriter writer = EasyExcelFactory.getWriterWithTempAndHandler(null, (OutputStream)ExcelUtils.getOutputStream(fileName, response, excelTypeEnum), (ExcelTypeEnum)excelTypeEnum, (boolean)true, new WriterHandler07<Class<T>>(classType));
            Sheet sheet = new Sheet(1, 0, classType);
            sheet.setSheetName(sheetName);
            try {
                writer.write(list, sheet);
            }
            finally {
                writer.finish();
            }
        }
        if (excelTypeEnum == ExcelTypeEnum.XLS) {
            ExcelWriterFactory writer = new ExcelWriterFactory(ExcelUtils.getOutputStream(fileName, response, excelTypeEnum), excelTypeEnum);
            Sheet sheet = new Sheet(1, 0, classType);
            sheet.setSheetName(sheetName);
            try {
                writer.write(list, sheet);
            }
            finally {
                writer.finish();
                writer.close();
            }
        }
    }

    public static <T extends BaseRowModel> List<T> readExcel(MultipartFile excel, Class<T> rowModel) throws Exception {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = ExcelUtils.getReader(excel, excelListener);
        if (reader == null) {
            return new ArrayList();
        }
        for (Sheet sheet : reader.getSheets()) {
            sheet.setClazz(rowModel);
            reader.read(sheet);
        }
        return ExcelUtils.getExtendsBeanList(excelListener.getDataList(), rowModel);
    }

    public static <T extends BaseRowModel> List<T> readExcel(MultipartFile excel, Class<T> rowModel, int sheetNo, int headLineNum) throws Exception {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = ExcelUtils.getReader(excel, excelListener);
        if (reader == null) {
            return new ArrayList();
        }
        reader.read(new Sheet(sheetNo, headLineNum, rowModel));
        return ExcelUtils.getExtendsBeanList(excelListener.getDataList(), rowModel);
    }

    private static OutputStream getOutputStream(String fileName, HttpServletResponse response, ExcelTypeEnum excelTypeEnum) throws Exception {
        String filePath = fileName + excelTypeEnum.getValue();
        try {
            fileName = new String(filePath.getBytes(), "ISO-8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setLocale(new Locale("zh", "CN"));
            return response.getOutputStream();
        }
        catch (IOException e) {
            ExceptionHandler.publish("", "\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01");
            return null;
        }
    }

    private static ExcelReader getReader(MultipartFile excel, ExcelListener excelListener) throws Exception {
        String fileName = excel.getOriginalFilename();
        if (fileName == null) {
            ExceptionHandler.publish("", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (!fileName.toLowerCase().endsWith(ExcelTypeEnum.XLS.getValue()) && !fileName.toLowerCase().endsWith(ExcelTypeEnum.XLSX.getValue())) {
            ExceptionHandler.publish("", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
        }
        try {
            InputStream inputStream = excel.getInputStream();
            return new ExcelReader(inputStream, null, (AnalysisEventListener)excelListener, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T extends BaseRowModel> List<T> getExtendsBeanList(List<?> list, Class<T> typeClazz) {
        return MyBeanCopy.convert(list, typeClazz);
    }
}

