/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ExcelListener
extends AnalysisEventListener {
    private List<Object> dataList = new ArrayList<Object>();
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public void invoke(Object object, AnalysisContext context) {
        if (!ExcelListener.checkObjAllFieldsIsNull(object)) {
            this.dataList.add(object);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    private static boolean checkObjAllFieldsIsNull(Object object) {
        if (null == object) {
            return true;
        }
        try {
            for (Field f : object.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                ExcelProperty property = f.getAnnotation(ExcelProperty.class);
                if (property == null || SERIAL_VERSION_UID.equals(f.getName()) || f.get(object) == null || ExcelListener.isBlank(f.get(object).toString())) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public List<Object> getDataList() {
        return this.dataList;
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

