/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisLockUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisLockUtils.class);
    private static final DefaultRedisScript<String> UNLOCK_LUA;
    private static final String LOCK_VALUE = "1";
    private static final String LOCK_HEARD = "lock:";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean setLock(String key, String value, long expire) {
        if (StringUtils.isBlank((CharSequence)value)) {
            value = LOCK_VALUE;
        }
        return this.setNx(this.buildKey(key), value, expire);
    }

    public boolean setLock(String key, long expire) {
        return this.setNx(key, null, expire);
    }

    public boolean setLock(String key, long expire, long waitTime) {
        return this.setLock(key, null, expire, waitTime);
    }

    public boolean setLock(String key, String value, long expire, long waitTime) {
        if (waitTime == 0L) {
            return this.setLock(key, value, expire);
        }
        long start = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - start <= waitTime) continue;
            return false;
        } while (!this.setLock(key, value, expire));
        return Boolean.TRUE;
    }

    public Optional<String> getLockValue(String key) {
        String o = (String)this.redisTemplate.opsForValue().get((Object)this.buildKey(key));
        return Optional.ofNullable(o);
    }

    public boolean releaseLock(String key) {
        return this.releaseLock(key, LOCK_VALUE);
    }

    public boolean releaseLock(String key, String value) {
        try {
            Object execute = this.redisTemplate.execute(connection -> connection.eval(UNLOCK_LUA.getScriptAsString().getBytes(), ReturnType.INTEGER, 1, (byte[][])new byte[][]{this.buildKey(key).getBytes(), value.getBytes()}));
            return execute.equals(1L);
        }
        catch (Exception e) {
            log.error("release lock occured an exception", (Throwable)e);
            return false;
        }
    }

    private boolean setNx(String key, String value, long expiredTime) {
        Boolean resultBoolean = null;
        try {
            resultBoolean = (Boolean)this.redisTemplate.execute(connection -> {
                Object nativeConnection = connection.getNativeConnection();
                String redisResult = "";
                RedisSerializer stringRedisSerializer = this.redisTemplate.getKeySerializer();
                byte[] keyByte = stringRedisSerializer.serialize((Object)key);
                byte[] valueByte = stringRedisSerializer.serialize((Object)value);
                if (nativeConnection instanceof RedisAsyncCommands) {
                    RedisAsyncCommands commands = (RedisAsyncCommands)nativeConnection;
                    redisResult = commands.getStatefulConnection().sync().set((Object)keyByte, (Object)valueByte, SetArgs.Builder.nx().px(expiredTime));
                }
                if (nativeConnection instanceof RedisAdvancedClusterAsyncCommands) {
                    RedisAdvancedClusterAsyncCommands clusterAsyncCommands = (RedisAdvancedClusterAsyncCommands)nativeConnection;
                    redisResult = clusterAsyncCommands.getStatefulConnection().sync().set((Object)keyByte, (Object)keyByte, SetArgs.Builder.nx().px(expiredTime));
                }
                return "OK".equalsIgnoreCase(redisResult);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultBoolean != null && resultBoolean != false;
    }

    private String buildKey(String key) {
        return LOCK_HEARD + key;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        sb.append("then ");
        sb.append("    return redis.call(\"del\",KEYS[1]) ");
        sb.append("else ");
        sb.append("    return 0 ");
        sb.append("end ");
        DefaultRedisScript script = new DefaultRedisScript();
        script.setScriptText(sb.toString());
        UNLOCK_LUA = script;
    }
}

