/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ztesoft.zsmart.nros.base.util.PropertiesUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.validation.constraints.NotNull;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={Object.class})
@MappedJdbcTypes(value={JdbcType.OTHER})
public class JSONTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(JSONTypeHandler.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private Class<T> clazz;
    private static String databaseType = PropertiesUtil.getValue("application.properties", "database.type", "mysql");

    public JSONTypeHandler(@NotNull Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T para, JdbcType jdbcType) throws SQLException {
        if ("postgresql".equalsIgnoreCase(databaseType)) {
            PGobject jsonObject = new PGobject();
            jsonObject.setType("json");
            jsonObject.setValue(this.toJson(para));
            ps.setObject(i, jsonObject);
        } else if ("mysql".equalsIgnoreCase(databaseType)) {
            ps.setString(i, JSON.toJSONString(para, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty}));
        } else {
            logger.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b --> {}", (Object)databaseType);
            throw new IllegalArgumentException("databaseType is error");
        }
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toObject(rs.getString(columnName), this.clazz);
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toObject(rs.getString(columnIndex), this.clazz);
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toObject(cs.getString(columnIndex), this.clazz);
    }

    private String toJson(T object) {
        try {
            return JSON.toJSONString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private T toObject(String content, Class<T> clazz) {
        if (content != null && !content.isEmpty()) {
            try {
                if (clazz.getTypeName().equalsIgnoreCase("java.lang.Object")) {
                    return (T)content;
                }
                return (T)JSON.parseObject((String)content, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        logger.info("\u52a0\u8f7d\u6570\u636e\u5e93\u7c7b\u578b --> {}", (Object)databaseType);
    }
}

