/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class IdGenerator {
    private static SecureRandom random = new SecureRandom();
    private final long workerId;
    private final long datacenterId;
    private final long idepoch;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long lastTimestamp = -1L;
    private long sequence;
    private static final Random r = new Random();

    public static String createId() {
        return new BigInteger(32, random).toString();
    }

    public static String createUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public IdGenerator() {
        this(1288834974657L);
    }

    public IdGenerator(long idepoch) {
        this(r.nextInt(31), r.nextInt(31), 0L, idepoch);
    }

    public IdGenerator(long workerId, long datacenterId, long sequence) {
        this(workerId, datacenterId, sequence, 1344322705519L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IdGenerator(long workerId, long datacenterId, long sequence, long idepoch) {
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.sequence = sequence;
        this.idepoch = idepoch;
        if (workerId < 0L || workerId > 31L) throw new IllegalArgumentException("workerId is illegal: " + workerId);
        if (datacenterId < 0L || datacenterId > 31L) throw new IllegalArgumentException("datacenterId is illegal: " + workerId);
        if (idepoch < System.currentTimeMillis()) return;
        throw new IllegalArgumentException("idepoch is illegal: " + idepoch);
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public long getId() {
        long id = this.nextId();
        return id;
    }

    private synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException("Clock moved backwards.");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - this.idepoch << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
        return id;
    }

    public long getIdTimestamp(long id) {
        return this.idepoch + (id >> 22);
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IdWorker{");
        sb.append("workerId=").append(this.workerId);
        sb.append(", datacenterId=").append(this.datacenterId);
        sb.append(", idepoch=").append(this.idepoch);
        sb.append(", lastTimestamp=").append(this.lastTimestamp);
        sb.append(", sequence=").append(this.sequence);
        sb.append('}');
        return sb.toString();
    }

    public static String getIdWithPrefix(String prefix) {
        IdGenerator idWorker = new IdGenerator();
        return prefix + String.valueOf(idWorker.getId());
    }

    public static long getIdNumber() {
        IdGenerator idWorker = new IdGenerator();
        return idWorker.getId();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(IdGenerator.getIdWithPrefix("CG"));
    }
}

