/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameGenerator {
    private static final Logger log = LoggerFactory.getLogger(FrameGenerator.class);
    public static final String CHARSERT = "UTF-8";

    public static void generateCode(String templateName, String className, String packageName, String module, String entity, String subproject, String term) throws Exception {
        SimpleDateFormat smf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Template template = null;
        String basePath = FrameGenerator.class.getResource("/").getPath().replace("/start/target/classes/", "");
        try {
            File fileDir;
            Properties properties = new Properties();
            String templatePath = basePath + "/start/src/main/resources/template";
            properties.setProperty("file.resource.loader.path", templatePath);
            properties.setProperty("ISO-8859-1", CHARSERT);
            properties.setProperty("input.encoding", CHARSERT);
            properties.setProperty("output.encoding", CHARSERT);
            Velocity.init((Properties)properties);
            template = Velocity.getTemplate((String)templateName);
            VelocityContext context = new VelocityContext();
            context.put("packageName", (Object)packageName);
            context.put("className", (Object)className);
            context.put("module", (Object)module);
            context.put("moduleToUp", (Object)"Inventory");
            context.put("entity", (Object)entity);
            context.put("term", (Object)term);
            context.put("USER", (Object)"yang.chao");
            context.put("TIME", (Object)smf.format(new Date()));
            context.put("entityToLow", (Object)(entity.substring(0, 1).toLowerCase() + entity.substring(1, entity.length())));
            String path = basePath + "/server/src/main/java/" + packageName.replace('.', '/');
            if (packageName.indexOf("api") != -1) {
                path = basePath + "/client/src/main/java/" + packageName.replace('.', '/');
            }
            if (!(fileDir = new File(path)).exists()) {
                fileDir.mkdirs();
            }
            FileOutputStream outStream = new FileOutputStream(new File(fileDir, className + ".java"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, CHARSERT);
            BufferedWriter sw = new BufferedWriter(writer);
            template.merge((Context)context, (Writer)sw);
            sw.flush();
            sw.close();
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String[] modelNames;
        String dataObjectPkgName = "com.ztesoft.zsmart.nros.sbc.nrosinventory.dao.model";
        String moduleName = "inventory";
        String dtoPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".model.dto";
        String paramPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".model.param";
        String queryPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".model.query";
        String convertPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".common.convertor.impl";
        String interfacePkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".api";
        String interfaceImplPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".service.impl";
        String domainFactoryPkgName = "com.ztesoft.zsmart.nros.sbc." + moduleName + ".domain.factory";
        String basePath = FrameGenerator.class.getResource("/").getPath().replace("/start/target/classes/", "");
        File fileDir = new File(basePath + "/server/src/main/java/" + dataObjectPkgName.replace('.', '/'));
        for (String modelName : modelNames = fileDir.list()) {
            String entity = modelName.replaceAll("DO.java", "");
            FrameGenerator.generateCode("DTO.vm", entity + "DTO", dtoPkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("Param.vm", entity + "Param", paramPkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("Query.vm", entity + "Query", queryPkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("Convertor.vm", entity + "Convertor", convertPkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("Service.vm", entity + "Service", interfacePkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("ServiceImpl.vm", entity + "ServiceImpl", interfaceImplPkgName, moduleName, entity, "", "");
            FrameGenerator.generateCode("DomainFactory.vm", entity + "DomainFactory", domainFactoryPkgName, moduleName, entity, "", "");
        }
    }
}

